/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.UnitEvent;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.UnitManagerEvent;
import org.mars_sim.msp.core.UnitManagerListener;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.Farming;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.tool.monitor.UnitTableModel;

public class SettlementTableModel
extends UnitTableModel {
    private static final int NAME = 0;
    private static final int POPULATION = 1;
    private static final int PARKED = 2;
    private static final int POWER = 3;
    private static final int GREENHOUSES = 4;
    private static final int CROPS = 5;
    private static final int MALFUNCTION = 6;
    private static final int OXYGEN = 7;
    private static final int HYDROGEN = 8;
    private static final int CO2 = 9;
    private static final int METHANE = 10;
    private static final int FOOD = 11;
    private static final int WATER = 12;
    private static final int WASTE_WATER = 13;
    private static final int ROCK_SAMPLES = 14;
    private static final int ICE = 15;
    private static final int COLUMNCOUNT = 16;
    private static String[] columnNames = new String[16];
    private static Class[] columnTypes = new Class[16];
    private UnitManagerListener unitManagerListener;
    private Map<Unit, Map<AmountResource, Integer>> resourceCache;

    public SettlementTableModel(UnitManager unitManager) {
        super("All Settlements", " settlements", columnNames, columnTypes);
        this.setSource(unitManager.getSettlements());
        this.unitManagerListener = new LocalUnitManagerListener();
        unitManager.addUnitManagerListener(this.unitManagerListener);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (rowIndex < this.getUnitNumber()) {
            Settlement settle = (Settlement)this.getUnit(rowIndex);
            BuildingManager bMgr = settle.getBuildingManager();
            Map<AmountResource, Integer> resourceMap = this.resourceCache.get(settle);
            try {
                switch (columnIndex) {
                    case 0: {
                        result = settle.getName();
                        break;
                    }
                    case 12: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"water"));
                        break;
                    }
                    case 11: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"food"));
                        break;
                    }
                    case 7: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"oxygen"));
                        break;
                    }
                    case 10: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"methane"));
                        break;
                    }
                    case 14: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"rock samples"));
                        break;
                    }
                    case 6: {
                        int severity = 0;
                        Malfunction malfunction = null;
                        for (Building building : settle.getBuildingManager().getBuildings()) {
                            Malfunction tempMalfunction = building.getMalfunctionManager().getMostSeriousMalfunction();
                            if (tempMalfunction == null || tempMalfunction.getSeverity() <= severity) continue;
                            malfunction = tempMalfunction;
                            severity = tempMalfunction.getSeverity();
                        }
                        if (malfunction != null) {
                            result = malfunction.getName();
                        }
                        break;
                    }
                    case 1: {
                        result = settle.getAllAssociatedPeople().size();
                        break;
                    }
                    case 2: {
                        result = settle.getParkedVehicleNum();
                        break;
                    }
                    case 3: {
                        result = (int)settle.getPowerGrid().getGeneratedPower();
                        break;
                    }
                    case 4: {
                        int greenhouses = bMgr.getBuildings("Farming").size();
                        result = greenhouses;
                        break;
                    }
                    case 5: {
                        int crops = 0;
                        List greenhouses = bMgr.getBuildings("Farming");
                        Iterator i = greenhouses.iterator();
                        while (i.hasNext()) {
                            try {
                                Building greenhouse = (Building)i.next();
                                Farming farm = (Farming)greenhouse.getFunction("Farming");
                                crops += farm.getCrops().size();
                            }
                            catch (Exception e) {}
                        }
                        result = crops;
                        break;
                    }
                    case 8: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"hydrogen"));
                        break;
                    }
                    case 13: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"waste water"));
                        break;
                    }
                    case 9: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"carbon dioxide"));
                        break;
                    }
                    case 15: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"ice"));
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public void unitUpdate(UnitEvent event) {
        Unit unit = (Unit)event.getSource();
        int unitIndex = this.getUnitIndex(unit);
        Object target = event.getTarget();
        String eventType = event.getType();
        int columnNum = -1;
        if (eventType.equals("name")) {
            columnNum = 0;
        } else if (eventType.equals("inventory storing unit") || eventType.equals("inventory retrieving unit")) {
            if (target instanceof Person) {
                columnNum = 1;
            } else if (target instanceof Vehicle) {
                columnNum = 2;
            }
        } else if (eventType.equals("generated power")) {
            columnNum = 3;
        } else if (eventType.equals("add building")) {
            if (target instanceof Farming) {
                columnNum = 4;
            }
        } else if (eventType.equals("crop event")) {
            columnNum = 5;
        } else if (eventType.equals("malfunction")) {
            columnNum = 6;
        } else if (eventType.equals("inventory resource event")) {
            try {
                int newValue;
                int currentValue;
                int tempColumnNum = -1;
                if (target.equals(AmountResource.findAmountResource((String)"oxygen"))) {
                    tempColumnNum = 7;
                } else if (target.equals(AmountResource.findAmountResource((String)"hydrogen"))) {
                    tempColumnNum = 8;
                } else if (target.equals(AmountResource.findAmountResource((String)"carbon dioxide"))) {
                    tempColumnNum = 9;
                } else if (target.equals(AmountResource.findAmountResource((String)"methane"))) {
                    tempColumnNum = 10;
                } else if (target.equals(AmountResource.findAmountResource((String)"food"))) {
                    tempColumnNum = 11;
                } else if (target.equals(AmountResource.findAmountResource((String)"water"))) {
                    tempColumnNum = 12;
                } else if (target.equals(AmountResource.findAmountResource((String)"waste water"))) {
                    tempColumnNum = 13;
                } else if (target.equals(AmountResource.findAmountResource((String)"rock samples"))) {
                    tempColumnNum = 14;
                } else if (target.equals(AmountResource.findAmountResource((String)"ice"))) {
                    tempColumnNum = 15;
                }
                if (tempColumnNum > -1 && (currentValue = ((Integer)this.getValueAt(unitIndex, tempColumnNum)).intValue()) != (newValue = this.getResourceStored(unit, (AmountResource)target).intValue())) {
                    columnNum = tempColumnNum;
                    Map<AmountResource, Integer> resourceMap = this.resourceCache.get(unit);
                    resourceMap.put((AmountResource)target, newValue);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (columnNum > -1) {
            SwingUtilities.invokeLater(new SettlementTableCellUpdater(unitIndex, columnNum));
        }
    }

    private void setSource(Collection<Settlement> source) {
        Iterator<Settlement> iter = source.iterator();
        while (iter.hasNext()) {
            this.addUnit((Unit)iter.next());
        }
    }

    @Override
    protected void addUnit(Unit newUnit) {
        if (this.resourceCache == null) {
            this.resourceCache = new HashMap<Unit, Map<AmountResource, Integer>>();
        }
        if (!this.resourceCache.containsKey(newUnit)) {
            try {
                HashMap<AmountResource, Integer> resourceMap = new HashMap<AmountResource, Integer>(9);
                AmountResource food = AmountResource.findAmountResource((String)"food");
                resourceMap.put(food, this.getResourceStored(newUnit, food));
                AmountResource oxygen = AmountResource.findAmountResource((String)"oxygen");
                resourceMap.put(oxygen, this.getResourceStored(newUnit, oxygen));
                AmountResource water = AmountResource.findAmountResource((String)"water");
                resourceMap.put(water, this.getResourceStored(newUnit, water));
                AmountResource hydrogen = AmountResource.findAmountResource((String)"hydrogen");
                resourceMap.put(hydrogen, this.getResourceStored(newUnit, hydrogen));
                AmountResource methane = AmountResource.findAmountResource((String)"methane");
                resourceMap.put(methane, this.getResourceStored(newUnit, methane));
                AmountResource rockSamples = AmountResource.findAmountResource((String)"rock samples");
                resourceMap.put(rockSamples, this.getResourceStored(newUnit, rockSamples));
                AmountResource wasteWater = AmountResource.findAmountResource((String)"waste water");
                resourceMap.put(wasteWater, this.getResourceStored(newUnit, wasteWater));
                AmountResource ice = AmountResource.findAmountResource((String)"ice");
                resourceMap.put(ice, this.getResourceStored(newUnit, ice));
                AmountResource carbonDioxide = AmountResource.findAmountResource((String)"carbon dioxide");
                resourceMap.put(carbonDioxide, this.getResourceStored(newUnit, carbonDioxide));
                this.resourceCache.put(newUnit, resourceMap);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.addUnit(newUnit);
    }

    @Override
    protected void removeUnit(Unit oldUnit) {
        if (this.resourceCache == null) {
            this.resourceCache = new HashMap<Unit, Map<AmountResource, Integer>>();
        }
        if (this.resourceCache.containsKey(oldUnit)) {
            Map<AmountResource, Integer> resourceMap = this.resourceCache.get(oldUnit);
            resourceMap.clear();
            this.resourceCache.remove(oldUnit);
        }
        super.removeUnit(oldUnit);
    }

    private Integer getResourceStored(Unit unit, AmountResource resource) {
        Integer result = null;
        Inventory inv = unit.getInventory();
        result = (int)inv.getAmountResourceStored(resource, true);
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        UnitManager unitManager = Simulation.instance().getUnitManager();
        unitManager.removeUnitManagerListener(this.unitManagerListener);
        this.unitManagerListener = null;
        if (this.resourceCache != null) {
            this.resourceCache.clear();
        }
        this.resourceCache = null;
    }

    static {
        SettlementTableModel.columnNames[0] = "Name";
        SettlementTableModel.columnTypes[0] = String.class;
        SettlementTableModel.columnNames[1] = "Total Population";
        SettlementTableModel.columnTypes[1] = Integer.class;
        SettlementTableModel.columnNames[2] = "Parked Vehicles";
        SettlementTableModel.columnTypes[2] = Integer.class;
        SettlementTableModel.columnNames[3] = "Power (kW)";
        SettlementTableModel.columnTypes[3] = Integer.class;
        SettlementTableModel.columnNames[4] = "Greenhouses";
        SettlementTableModel.columnTypes[4] = Integer.class;
        SettlementTableModel.columnNames[5] = "Crops";
        SettlementTableModel.columnTypes[5] = Integer.class;
        SettlementTableModel.columnNames[6] = "Malfunction";
        SettlementTableModel.columnTypes[6] = String.class;
        SettlementTableModel.columnNames[11] = "Food";
        SettlementTableModel.columnTypes[11] = Integer.class;
        SettlementTableModel.columnNames[7] = "Oxygen";
        SettlementTableModel.columnTypes[7] = Integer.class;
        SettlementTableModel.columnNames[12] = "Water";
        SettlementTableModel.columnTypes[12] = Integer.class;
        SettlementTableModel.columnNames[10] = "Methane";
        SettlementTableModel.columnTypes[10] = Integer.class;
        SettlementTableModel.columnNames[14] = "Rock Samples";
        SettlementTableModel.columnTypes[14] = Integer.class;
        SettlementTableModel.columnNames[8] = "Hydrogen";
        SettlementTableModel.columnTypes[8] = Integer.class;
        SettlementTableModel.columnNames[13] = "Waste Water";
        SettlementTableModel.columnTypes[13] = Integer.class;
        SettlementTableModel.columnNames[9] = "CO2";
        SettlementTableModel.columnTypes[9] = Integer.class;
        SettlementTableModel.columnNames[15] = "Ice";
        SettlementTableModel.columnTypes[15] = Integer.class;
    }

    private class LocalUnitManagerListener
    implements UnitManagerListener {
        private LocalUnitManagerListener() {
        }

        public void unitManagerUpdate(UnitManagerEvent event) {
            Unit unit = event.getUnit();
            String eventType = event.getEventType();
            if (unit instanceof Settlement) {
                if (eventType.equals("add unit")) {
                    if (!SettlementTableModel.this.containsUnit(unit)) {
                        SettlementTableModel.this.addUnit(unit);
                    }
                } else if (eventType.equals("remove unit") && SettlementTableModel.this.containsUnit(unit)) {
                    SettlementTableModel.this.removeUnit(unit);
                }
            }
        }
    }

    private class SettlementTableCellUpdater
    implements Runnable {
        private int row;
        private int column;

        private SettlementTableCellUpdater(int row, int column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public void run() {
            SettlementTableModel.this.fireTableCellUpdated(this.row, this.column);
        }
    }
}

