/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorTab;
import org.mars_sim.msp.ui.swing.tool.monitor.TableProperties;
import org.mars_sim.msp.ui.swing.tool.monitor.TableSorter;

abstract class TableTab
extends MonitorTab {
    private static Icon ascendingIcon = null;
    private static Icon descendingIcon = null;
    private static final Icon TABLEICON = ImageLoader.getIcon("Table");
    protected JTable table;
    private TableSorter sortedModel;
    private boolean sortAscending = true;
    private int sortedColumn = 0;

    public TableTab(MonitorModel model, boolean mandatory, boolean singleSelection) {
        super(model, mandatory, TABLEICON);
        if (ascendingIcon == null) {
            Color baseColor = UIManager.getColor("Label.background");
            ascendingIcon = new ColumnSortIcon(false, baseColor);
            descendingIcon = new ColumnSortIcon(true, baseColor);
        }
        if (!model.getOrdered()) {
            this.sortedModel = new TableSorter(model);
            this.table = new JTable(this.sortedModel){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() == -1) {
                        List selected = TableTab.this.getSelection();
                        super.tableChanged(e);
                        MonitorModel model = (MonitorModel)this.getModel();
                        for (Object selectedObject : selected) {
                            for (int x = 0; x < model.getRowCount(); ++x) {
                                if (!selectedObject.equals(model.getObject(x))) continue;
                                this.addRowSelectionInterval(x, x);
                            }
                        }
                    } else {
                        super.tableChanged(e);
                    }
                }

                @Override
                public String getToolTipText(MouseEvent e) {
                    return TableTab.this.getCellText(e);
                }
            };
            this.sortedModel.addTableModelListener(this.table);
            JTableHeader theHeader = this.table.getTableHeader();
            TableHeaderRenderer theRenderer = new TableHeaderRenderer(theHeader.getDefaultRenderer());
            theHeader.setDefaultRenderer(theRenderer);
            theHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int column = TableTab.this.table.getTableHeader().columnAtPoint(e.getPoint());
                    TableTab.this.setSortColumn(column);
                    TableTab.this.table.getTableHeader().repaint();
                }
            });
        } else {
            this.table = new JTable(model){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() == -1) {
                        List selected = TableTab.this.getSelection();
                        super.tableChanged(e);
                        MonitorModel model = (MonitorModel)this.getModel();
                        for (Object selectedObject : selected) {
                            for (int x = 0; x < model.getRowCount(); ++x) {
                                if (selectedObject != model.getObject(x)) continue;
                                this.addRowSelectionInterval(x, x);
                            }
                        }
                    } else {
                        super.tableChanged(e);
                    }
                }

                @Override
                public String getToolTipText(MouseEvent e) {
                    return TableTab.this.getCellText(e);
                }
            };
        }
        if (singleSelection) {
            this.table.getSelectionModel().setSelectionMode(0);
        }
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.setBorder(new MarsPanelBorder());
        this.add((Component)scroller, "Center");
        this.setName(model.getName());
        this.setSortColumn(0);
    }

    @Override
    public void displayProps(MainDesktopPane desktop) {
        TableProperties propsWindow = new TableProperties(this.getName(), this.table, desktop);
        propsWindow.show();
    }

    @Override
    protected List getSelection() {
        MonitorModel target = this.sortedModel != null ? this.sortedModel : this.getModel();
        int[] indexes = new int[]{};
        if (this.table != null) {
            indexes = this.table.getSelectedRows();
        }
        ArrayList<Object> selectedRows = new ArrayList<Object>();
        for (int indexe : indexes) {
            Object selected = target.getObject(indexe);
            if (selected == null) continue;
            selectedRows.add(selected);
        }
        return selectedRows;
    }

    private String getCellText(MouseEvent e) {
        Object cell;
        Point p = e.getPoint();
        int column = this.table.columnAtPoint(p);
        int row = this.table.rowAtPoint(p);
        String result = null;
        if (column >= 0 && row >= 0 && (cell = this.table.getValueAt(row, column)) != null) {
            result = cell.toString();
        }
        return result;
    }

    @Override
    public void removeTab() {
        super.removeTab();
        this.table = null;
        if (this.sortedModel != null) {
            this.sortedModel.destroy();
            this.sortedModel = null;
        }
    }

    private void setSortColumn(int index) {
        if (this.sortedModel != null) {
            if (this.sortedColumn == index) {
                this.sortAscending = !this.sortAscending;
            }
            this.sortedColumn = index;
            this.sortedModel.sortByColumn(this.sortedColumn, this.sortAscending);
        }
    }

    class TableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer defaultRenderer;

        public TableHeaderRenderer(TableCellRenderer theRenderer) {
            this.defaultRenderer = theRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component theResult = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (theResult instanceof JLabel) {
                JLabel cell = (JLabel)theResult;
                Icon icon = null;
                if (column == TableTab.this.sortedColumn) {
                    icon = TableTab.this.sortAscending ? ascendingIcon : descendingIcon;
                }
                cell.setIcon(icon);
            }
            return theResult;
        }
    }

    static class ColumnSortIcon
    implements Icon {
        static final int midw = 4;
        private Color lightShadow;
        private Color darkShadow;
        private boolean downwards;

        public ColumnSortIcon(boolean downwards, Color baseColor) {
            this.downwards = downwards;
            this.lightShadow = baseColor.brighter();
            this.darkShadow = baseColor.darker().darker();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int xo, int yo) {
            int w = this.getIconWidth();
            int xw = xo + w - 1;
            int h = this.getIconHeight();
            int yh = yo + h - 1;
            if (this.downwards) {
                g.setColor(this.lightShadow);
                g.drawLine(xo + 4 + 1, yo, xw, yh - 1);
                g.drawLine(xo, yh, xw, yh);
                g.setColor(this.darkShadow);
                g.drawLine(xo + 4 - 1, yo, xo, yh - 1);
            } else {
                g.setColor(this.lightShadow);
                g.drawLine(xw, yo + 1, xo + 4, yh);
                g.setColor(this.darkShadow);
                g.drawLine(xo + 1, yo + 1, xo + 4 - 1, yh);
                g.drawLine(xo, yo, xw, yo);
            }
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return this.getIconWidth() - 1;
        }
    }
}

