/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.UnitManagerEvent;
import org.mars_sim.msp.core.UnitManagerListener;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;
import org.mars_sim.msp.ui.swing.tool.monitor.TableTab;
import org.mars_sim.msp.ui.swing.tool.monitor.TradeTableModel;

public class TradeTab
extends TableTab
implements UnitManagerListener {
    TradeTab() {
        super((MonitorModel)new TradeTableModel(), true, false);
        this.table.setDefaultRenderer(Double.class, new NumberCellRenderer(2));
        Simulation.instance().getUnitManager().addUnitManagerListener((UnitManagerListener)this);
    }

    public void unitManagerUpdate(UnitManagerEvent event) {
        if (event.getUnit() instanceof Settlement) {
            TableColumn column;
            Settlement settlement = (Settlement)event.getUnit();
            if ("add unit".equals(event.getEventType())) {
                TableColumn column2 = new TableColumn(this.table.getColumnCount());
                column2.setHeaderValue(settlement.getName());
                SwingUtilities.invokeLater(new TradeColumnModifier(column2, true));
            } else if ("remove unit".equals(event.getEventType()) && (column = this.table.getColumn(settlement.getName())) != null) {
                SwingUtilities.invokeLater(new TradeColumnModifier(column, false));
            }
        }
    }

    private class TradeColumnModifier
    implements Runnable {
        private TableColumn column;
        private boolean addColumn;

        private TradeColumnModifier(TableColumn column, boolean addColumn) {
            this.column = column;
            this.addColumn = addColumn;
        }

        @Override
        public void run() {
            if (this.addColumn) {
                TradeTab.this.table.getColumnModel().addColumn(this.column);
            } else {
                TradeTab.this.table.getColumnModel().removeColumn(this.column);
            }
        }
    }
}

