/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.UnitEvent;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.UnitManagerEvent;
import org.mars_sim.msp.core.UnitManagerListener;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.person.ai.mission.MissionListener;
import org.mars_sim.msp.core.person.ai.mission.MissionManagerListener;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.tool.monitor.UnitTableModel;

public class VehicleTableModel
extends UnitTableModel {
    private static Logger logger = Logger.getLogger(VehicleTableModel.class.getName());
    private static final int NAME = 0;
    private static final int TYPE = 1;
    private static final int LOCATION = 2;
    private static final int DESTINATION = 3;
    private static final int DESTDIST = 4;
    private static final int MISSION = 5;
    private static final int CREW = 6;
    private static final int DRIVER = 7;
    private static final int STATUS = 8;
    private static final int BEACON = 9;
    private static final int RESERVED = 10;
    private static final int SPEED = 11;
    private static final int MALFUNCTION = 12;
    private static final int OXYGEN = 13;
    private static final int METHANE = 14;
    private static final int WATER = 15;
    private static final int FOOD = 16;
    private static final int ROCK_SAMPLES = 17;
    private static final int ICE = 18;
    private static final int COLUMNCOUNT = 19;
    private static String[] columnNames = new String[19];
    private static Class[] columnTypes = new Class[19];
    private UnitManagerListener unitManagerListener;
    private LocalMissionManagerListener missionManagerListener;
    private Map<Unit, Map<AmountResource, Integer>> resourceCache;

    public VehicleTableModel(UnitManager unitManager) {
        super("All Vehicles", " vehicles", columnNames, columnTypes);
        this.setSource(unitManager.getVehicles());
        this.unitManagerListener = new LocalUnitManagerListener();
        unitManager.addUnitManagerListener(this.unitManagerListener);
        this.missionManagerListener = new LocalMissionManagerListener();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (rowIndex < this.getUnitNumber()) {
            Vehicle vehicle = (Vehicle)this.getUnit(rowIndex);
            Map<AmountResource, Integer> resourceMap = this.resourceCache.get(vehicle);
            try {
                switch (columnIndex) {
                    case 0: {
                        result = vehicle.getName();
                        break;
                    }
                    case 1: {
                        result = vehicle.getDescription();
                        break;
                    }
                    case 6: {
                        if (vehicle instanceof Crewable) {
                            result = ((Crewable)vehicle).getCrewNum();
                            break;
                        }
                        result = 0;
                        break;
                    }
                    case 15: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"water"));
                        break;
                    }
                    case 16: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"food"));
                        break;
                    }
                    case 13: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"oxygen"));
                        break;
                    }
                    case 14: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"methane"));
                        break;
                    }
                    case 17: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"rock samples"));
                        break;
                    }
                    case 11: {
                        result = new Float(vehicle.getSpeed()).intValue();
                        break;
                    }
                    case 7: {
                        if (vehicle.getOperator() != null) {
                            result = vehicle.getOperator().getOperatorName();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 8: {
                        result = vehicle.getStatus();
                        break;
                    }
                    case 9: {
                        if (vehicle.isEmergencyBeacon()) {
                            result = "on";
                            break;
                        }
                        result = "off";
                        break;
                    }
                    case 10: {
                        if (vehicle.isReserved()) {
                            result = "true";
                            break;
                        }
                        result = "false";
                        break;
                    }
                    case 12: {
                        Malfunction failure = vehicle.getMalfunctionManager().getMostSeriousMalfunction();
                        if (failure != null) {
                            result = failure.getName();
                        }
                        break;
                    }
                    case 2: {
                        Settlement settle = vehicle.getSettlement();
                        if (settle != null) {
                            result = settle.getName();
                            break;
                        }
                        result = vehicle.getCoordinates().getFormattedString();
                        break;
                    }
                    case 3: {
                        VehicleMission vehicleMission;
                        result = null;
                        Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle(vehicle);
                        if (mission != null && mission instanceof VehicleMission && (vehicleMission = (VehicleMission)mission).getTravelStatus().equals("Traveling to navpoint")) {
                            NavPoint destination = vehicleMission.getNextNavpoint();
                            if (destination.isSettlementAtNavpoint()) {
                                result = destination.getSettlement().getName();
                                break;
                            }
                            result = destination.getLocation().getFormattedString();
                        }
                        break;
                    }
                    case 4: {
                        Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle(vehicle);
                        if (mission != null && mission instanceof VehicleMission) {
                            VehicleMission vehicleMission = (VehicleMission)mission;
                            try {
                                result = new Float(vehicleMission.getCurrentLegRemainingDistance()).intValue();
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Error getting current leg remaining distance.");
                                e.printStackTrace(System.err);
                            }
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 5: {
                        Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle(vehicle);
                        if (mission != null) {
                            result = mission.getName();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 18: {
                        result = resourceMap.get(AmountResource.findAmountResource((String)"ice"));
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public void unitUpdate(UnitEvent event) {
        Unit unit = (Unit)event.getSource();
        int unitIndex = this.getUnitIndex(unit);
        Object target = event.getTarget();
        String eventType = event.getType();
        int columnNum = -1;
        if (eventType.equals("name")) {
            columnNum = 0;
        } else if (eventType.equals("location")) {
            columnNum = 2;
        } else if (eventType.equals("inventory storing unit") || eventType.equals("inventory retrieving unit")) {
            if (target instanceof Person) {
                columnNum = 6;
            }
        } else if (eventType.equals("vehicle operator")) {
            columnNum = 7;
        } else if (eventType.equals("vehicle status")) {
            columnNum = 8;
        } else if (eventType.equals("vehicle emergency beacon event")) {
            columnNum = 9;
        } else if (eventType.equals("vehicle reserved event")) {
            columnNum = 10;
        } else if (eventType.equals("vehicle speed")) {
            columnNum = 11;
        } else if (eventType.equals("malfunction")) {
            columnNum = 12;
        } else if (eventType.equals("inventory resource event")) {
            try {
                int newValue;
                int currentValue;
                int tempColumnNum = -1;
                if (target.equals(AmountResource.findAmountResource((String)"oxygen"))) {
                    tempColumnNum = 13;
                } else if (target.equals(AmountResource.findAmountResource((String)"methane"))) {
                    tempColumnNum = 14;
                } else if (target.equals(AmountResource.findAmountResource((String)"food"))) {
                    tempColumnNum = 16;
                } else if (target.equals(AmountResource.findAmountResource((String)"water"))) {
                    tempColumnNum = 15;
                } else if (target.equals(AmountResource.findAmountResource((String)"rock samples"))) {
                    tempColumnNum = 17;
                } else if (target.equals(AmountResource.findAmountResource((String)"ice"))) {
                    tempColumnNum = 18;
                }
                if (tempColumnNum > -1 && (currentValue = ((Integer)this.getValueAt(unitIndex, tempColumnNum)).intValue()) != (newValue = this.getResourceStored(unit, (AmountResource)target).intValue())) {
                    columnNum = tempColumnNum;
                    Map<AmountResource, Integer> resourceMap = this.resourceCache.get(unit);
                    resourceMap.put((AmountResource)target, newValue);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
            }
        }
        if (columnNum > -1) {
            SwingUtilities.invokeLater(new VehicleTableCellUpdater(unitIndex, columnNum));
        }
    }

    private void setSource(Collection<Vehicle> source) {
        Iterator<Vehicle> iter = source.iterator();
        while (iter.hasNext()) {
            this.addUnit((Unit)iter.next());
        }
    }

    @Override
    protected void addUnit(Unit newUnit) {
        if (this.resourceCache == null) {
            this.resourceCache = new HashMap<Unit, Map<AmountResource, Integer>>();
        }
        if (!this.resourceCache.containsKey(newUnit)) {
            try {
                HashMap<AmountResource, Integer> resourceMap = new HashMap<AmountResource, Integer>(6);
                AmountResource food = AmountResource.findAmountResource((String)"food");
                resourceMap.put(food, this.getResourceStored(newUnit, food));
                AmountResource oxygen = AmountResource.findAmountResource((String)"oxygen");
                resourceMap.put(oxygen, this.getResourceStored(newUnit, oxygen));
                AmountResource water = AmountResource.findAmountResource((String)"water");
                resourceMap.put(water, this.getResourceStored(newUnit, water));
                AmountResource methane = AmountResource.findAmountResource((String)"methane");
                resourceMap.put(methane, this.getResourceStored(newUnit, methane));
                AmountResource rockSamples = AmountResource.findAmountResource((String)"rock samples");
                resourceMap.put(rockSamples, this.getResourceStored(newUnit, rockSamples));
                AmountResource ice = AmountResource.findAmountResource((String)"ice");
                resourceMap.put(ice, this.getResourceStored(newUnit, ice));
                this.resourceCache.put(newUnit, resourceMap);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
            }
        }
        super.addUnit(newUnit);
    }

    @Override
    protected void removeUnit(Unit oldUnit) {
        if (this.resourceCache == null) {
            this.resourceCache = new HashMap<Unit, Map<AmountResource, Integer>>();
        }
        if (this.resourceCache.containsKey(oldUnit)) {
            Map<AmountResource, Integer> resourceMap = this.resourceCache.get(oldUnit);
            resourceMap.clear();
            this.resourceCache.remove(oldUnit);
        }
        super.removeUnit(oldUnit);
    }

    private Integer getResourceStored(Unit unit, AmountResource resource) {
        Integer result = null;
        Inventory inv = unit.getInventory();
        result = (int)inv.getAmountResourceStored(resource, true);
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        UnitManager unitManager = Simulation.instance().getUnitManager();
        unitManager.removeUnitManagerListener(this.unitManagerListener);
        this.unitManagerListener = null;
        if (this.missionManagerListener != null) {
            this.missionManagerListener.destroy();
        }
        this.missionManagerListener = null;
        if (this.resourceCache != null) {
            this.resourceCache.clear();
        }
        this.resourceCache = null;
    }

    static {
        VehicleTableModel.columnNames[0] = "Name";
        VehicleTableModel.columnTypes[0] = String.class;
        VehicleTableModel.columnNames[1] = "Type";
        VehicleTableModel.columnTypes[1] = String.class;
        VehicleTableModel.columnNames[7] = "Driver";
        VehicleTableModel.columnTypes[7] = String.class;
        VehicleTableModel.columnNames[8] = "Status";
        VehicleTableModel.columnTypes[8] = String.class;
        VehicleTableModel.columnNames[9] = "Beacon";
        VehicleTableModel.columnTypes[9] = String.class;
        VehicleTableModel.columnNames[10] = "Reserved";
        VehicleTableModel.columnTypes[10] = String.class;
        VehicleTableModel.columnNames[2] = "Location";
        VehicleTableModel.columnTypes[2] = String.class;
        VehicleTableModel.columnNames[11] = "Speed";
        VehicleTableModel.columnTypes[11] = Integer.class;
        VehicleTableModel.columnNames[12] = "Malfunction";
        VehicleTableModel.columnTypes[12] = String.class;
        VehicleTableModel.columnNames[6] = "Crew";
        VehicleTableModel.columnTypes[6] = Integer.class;
        VehicleTableModel.columnNames[3] = "Destination";
        VehicleTableModel.columnTypes[3] = Coordinates.class;
        VehicleTableModel.columnNames[4] = "Dest. Dist.";
        VehicleTableModel.columnTypes[4] = Integer.class;
        VehicleTableModel.columnNames[5] = "Mission";
        VehicleTableModel.columnTypes[5] = String.class;
        VehicleTableModel.columnNames[16] = "Food";
        VehicleTableModel.columnTypes[16] = Integer.class;
        VehicleTableModel.columnNames[13] = "Oxygen";
        VehicleTableModel.columnTypes[13] = Integer.class;
        VehicleTableModel.columnNames[15] = "Water";
        VehicleTableModel.columnTypes[15] = Integer.class;
        VehicleTableModel.columnNames[14] = "Methane";
        VehicleTableModel.columnTypes[14] = Integer.class;
        VehicleTableModel.columnNames[17] = "Rock Samples";
        VehicleTableModel.columnTypes[17] = Integer.class;
        VehicleTableModel.columnNames[18] = "Ice";
        VehicleTableModel.columnTypes[18] = Integer.class;
    }

    private class LocalMissionListener
    implements MissionListener {
        private LocalMissionListener() {
        }

        public void missionUpdate(MissionEvent event) {
            Vehicle vehicle;
            Mission mission = (Mission)event.getSource();
            String eventType = event.getType();
            int columnNum = -1;
            if (eventType.equals("travel status") || eventType.equals("navpoints")) {
                columnNum = 3;
            } else if (eventType.equals("distance")) {
                columnNum = 4;
            } else if (eventType.equals("vehicle")) {
                columnNum = 5;
            }
            if (columnNum > -1 && mission instanceof VehicleMission && (vehicle = ((VehicleMission)mission).getVehicle()) != null) {
                int unitIndex = VehicleTableModel.this.getUnitIndex((Unit)vehicle);
                SwingUtilities.invokeLater(new VehicleTableCellUpdater(unitIndex, columnNum));
            }
        }
    }

    private class VehicleTableCellUpdater
    implements Runnable {
        private int row;
        private int column;

        private VehicleTableCellUpdater(int row, int column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public void run() {
            VehicleTableModel.this.fireTableCellUpdated(this.row, this.column);
        }
    }

    private class LocalMissionManagerListener
    implements MissionManagerListener {
        private List<Mission> missions;
        private MissionListener missionListener;

        LocalMissionManagerListener() {
            this.missionListener = new LocalMissionListener();
            this.missions = Simulation.instance().getMissionManager().getMissions();
            Iterator<Mission> i = this.missions.iterator();
            while (i.hasNext()) {
                this.addMission(i.next());
            }
        }

        public void addMission(Mission mission) {
            mission.addMissionListener(this.missionListener);
            this.updateVehicleMissionCell(mission);
        }

        public void removeMission(Mission mission) {
            mission.removeMissionListener(this.missionListener);
            this.updateVehicleMissionCell(mission);
        }

        private void updateVehicleMissionCell(Mission mission) {
            VehicleTableModel.this.fireTableDataChanged();
        }

        public void destroy() {
            Iterator<Mission> i = this.missions.iterator();
            while (i.hasNext()) {
                this.removeMission(i.next());
            }
            this.missions = null;
            this.missionListener = null;
        }
    }

    private class LocalUnitManagerListener
    implements UnitManagerListener {
        private LocalUnitManagerListener() {
        }

        public void unitManagerUpdate(UnitManagerEvent event) {
            Unit unit = event.getUnit();
            String eventType = event.getEventType();
            if (unit instanceof Vehicle) {
                if (eventType.equals("add unit")) {
                    if (!VehicleTableModel.this.containsUnit(unit)) {
                        VehicleTableModel.this.addUnit(unit);
                    }
                } else if (eventType.equals("remove unit") && VehicleTableModel.this.containsUnit(unit)) {
                    VehicleTableModel.this.removeUnit(unit);
                }
            }
        }
    }
}

