/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.navigator;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.mars.Mars;
import org.mars_sim.msp.ui.swing.tool.navigator.MarsGlobe;
import org.mars_sim.msp.ui.swing.tool.navigator.NavigatorWindow;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfo;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfoFactory;

class GlobeDisplay
extends JComponent
implements Runnable {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.tool.navigator.GlobeDisplay";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private MarsGlobe marsSphere;
    private MarsGlobe topoSphere;
    private Coordinates centerCoords;
    private Thread showThread;
    private boolean topo;
    private boolean recreate;
    private int width;
    private int height;
    private boolean useUSGSMap;
    private int[] shadingArray;
    private boolean showDayNightShading;
    private boolean update;
    private boolean keepRunning;
    private static int dragx;
    private static int dragy;
    private static final double HALF_PI = 1.5707963267948966;

    public GlobeDisplay(final NavigatorWindow navwin, int width, int height) {
        this.width = width;
        this.height = height;
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.marsSphere = new MarsGlobe("surface", this);
        this.topoSphere = new MarsGlobe("topo", this);
        this.centerCoords = new Coordinates(1.5707963267948966, 0.0);
        this.update = true;
        this.topo = false;
        this.recreate = true;
        this.useUSGSMap = false;
        this.shadingArray = new int[width * height];
        this.showDayNightShading = false;
        this.addMouseMotionListener(new MouseAdapter(){
            int lastx;
            int lasty;

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (y > dragy) {
                    if (y < this.lasty) {
                        dragy = y;
                    }
                } else if (y > this.lasty) {
                    dragy = y;
                }
                if (x > dragx) {
                    if (x < this.lastx) {
                        dragx = x;
                    }
                } else if (x > this.lastx) {
                    dragx = x;
                }
                int dify = dragy - y;
                int difx = dragx - x;
                this.lastx = x;
                this.lasty = y;
                if (dragx != 0 && dragy != 0) {
                    double newTheta;
                    double newPhi = GlobeDisplay.this.centerCoords.getPhi() + (double)dify * 0.0025 % Math.PI;
                    if (newPhi > Math.PI) {
                        newPhi = Math.PI;
                    }
                    if (newPhi < 0.0) {
                        newPhi = 0.0;
                    }
                    for (newTheta = GlobeDisplay.this.centerCoords.getTheta() + (double)difx * 0.0025 % 1.5707963267948966; newTheta > Math.PI * 2; newTheta -= Math.PI * 2) {
                    }
                    while (newTheta < 0.0) {
                        newTheta += Math.PI * 2;
                    }
                    GlobeDisplay.this.centerCoords = new Coordinates(newPhi, newTheta);
                    if (GlobeDisplay.this.topo) {
                        GlobeDisplay.this.topoSphere.drawSphere(GlobeDisplay.this.centerCoords);
                    } else {
                        GlobeDisplay.this.marsSphere.drawSphere(GlobeDisplay.this.centerCoords);
                    }
                    GlobeDisplay.this.recreate = false;
                    GlobeDisplay.this.repaint();
                }
                super.mouseDragged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                dragx = e.getX();
                dragy = e.getY();
                super.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                dragx = 0;
                dragy = 0;
                navwin.updateCoords(GlobeDisplay.this.centerCoords);
                super.mouseReleased(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                navwin.setCursor(new Cursor(12));
                super.mouseReleased(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                navwin.setCursor(new Cursor(0));
                super.mouseReleased(e);
            }
        });
        this.showSurf();
    }

    public void showSurf() {
        if (this.topo) {
            this.recreate = true;
        }
        this.topo = false;
        this.showGlobe(this.centerCoords);
    }

    public void showTopo() {
        if (!this.topo) {
            this.recreate = true;
        }
        this.topo = true;
        this.showGlobe(this.centerCoords);
    }

    public void showGlobe(Coordinates newCenter) {
        if (!this.centerCoords.equals((Object)newCenter)) {
            this.recreate = true;
            this.centerCoords.setCoords(newCenter);
        }
        this.updateDisplay();
    }

    private void updateDisplay() {
        if (this.showThread == null || !this.showThread.isAlive()) {
            this.showThread = new Thread((Runnable)this, "Globe");
            this.showThread.start();
        } else {
            this.showThread.interrupt();
        }
    }

    @Override
    public void run() {
        while (this.update) {
            this.refreshLoop();
        }
    }

    public void refreshLoop() {
        this.keepRunning = true;
        while (this.keepRunning) {
            if (this.recreate) {
                if (this.topo) {
                    this.topoSphere.drawSphere(this.centerCoords);
                } else {
                    this.marsSphere.drawSphere(this.centerCoords);
                }
                this.recreate = false;
                this.repaint();
                continue;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        MarsGlobe globe;
        g.setColor(Color.black);
        g.fillRect(0, 0, this.width, this.height);
        MarsGlobe marsGlobe = globe = this.topo ? this.topoSphere : this.marsSphere;
        if (globe.isImageDone()) {
            g.drawImage(globe.getGlobeImage(), 0, 0, this);
        }
        if (this.showDayNightShading) {
            this.drawShading(g);
        }
        this.drawUnits(g);
        this.drawCrossHair(g);
    }

    protected void drawShading(Graphics g) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        Mars mars = Simulation.instance().getMars();
        Coordinates location = new Coordinates(0.0, 0.0);
        for (int x = 0; x < 150; ++x) {
            for (int y = 0; y < 150; ++y) {
                int xDiff = x - centerX;
                int yDiff = y - centerY;
                if (Math.sqrt(xDiff * xDiff + yDiff * yDiff) <= 47.74648293) {
                    this.centerCoords.convertRectToSpherical((double)xDiff, (double)yDiff, 47.74648293, location);
                    double sunlight = mars.getSurfaceFeatures().getSurfaceSunlight(location);
                    int sunlightInt = (int)(127.0 * sunlight);
                    this.shadingArray[x + y * this.width] = 127 - sunlightInt << 24 & 0xFF000000;
                    continue;
                }
                this.shadingArray[x + y * 150] = -16777216;
            }
        }
        Image shadingMap = this.createImage(new MemoryImageSource(this.width, this.height, this.shadingArray, 0, this.width));
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(shadingMap, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "GlobeDisplay - ShadingMap interrupted: " + e);
        }
        g.drawImage(shadingMap, 0, 0, this);
    }

    protected void drawUnits(Graphics g) {
        for (Unit unit : Simulation.instance().getUnitManager().getUnits()) {
            Coordinates unitCoords;
            UnitDisplayInfo displayInfo = UnitDisplayInfoFactory.getUnitDisplayInfo(unit);
            if (!displayInfo.isGlobeDisplayed(unit) || !(this.centerCoords.getAngle(unitCoords = unit.getCoordinates()) < 1.5707963267948966)) continue;
            if (this.topo) {
                g.setColor(displayInfo.getTopoGlobeColor());
            } else {
                g.setColor(displayInfo.getSurfGlobeColor());
            }
            IntPoint tempLocation = this.getUnitDrawLocation(unitCoords);
            g.fillRect(tempLocation.getiX(), tempLocation.getiY(), 1, 1);
        }
    }

    protected void drawCrossHair(Graphics g) {
        g.setColor(Color.green);
        if (this.useUSGSMap & !this.topo) {
            g.drawRect(72, 72, 6, 6);
            g.drawLine(0, 75, 71, 75);
            g.drawLine(79, 75, 149, 75);
            g.drawLine(75, 0, 75, 71);
            g.drawLine(75, 79, 75, 149);
        } else {
            g.drawRect(57, 57, 33, 33);
            g.drawLine(0, 74, 56, 74);
            g.drawLine(90, 74, 149, 74);
            g.drawLine(74, 0, 74, 57);
            g.drawLine(74, 90, 74, 149);
        }
        Font positionFont = new Font("Helvetica", 0, 10);
        FontMetrics positionMetrics = this.getFontMetrics(positionFont);
        g.setFont(positionFont);
        int leftWidth = positionMetrics.stringWidth("Latitude:");
        int rightWidth = positionMetrics.stringWidth("Longitude:");
        g.drawString("Latitude:", 5, 130);
        g.drawString("Longitude:", 145 - rightWidth, 130);
        String latString = this.centerCoords.getFormattedLatitudeString();
        String longString = this.centerCoords.getFormattedLongitudeString();
        int latWidth = positionMetrics.stringWidth(latString);
        int longWidth = positionMetrics.stringWidth(longString);
        int latPosition = (leftWidth - latWidth) / 2 + 5;
        int longPosition = 145 - rightWidth + (rightWidth - longWidth) / 2;
        g.drawString(latString, latPosition, 142);
        g.drawString(longString, longPosition, 142);
    }

    private IntPoint getUnitDrawLocation(Coordinates unitCoords) {
        double rho = (double)this.width / Math.PI;
        int half_map = this.width / 2;
        int low_edge = 0;
        return Coordinates.findRectPosition((Coordinates)unitCoords, (Coordinates)this.centerCoords, (double)rho, (int)half_map, (int)low_edge);
    }

    public void setUSGSMap(boolean useUSGSMap) {
        this.useUSGSMap = useUSGSMap;
    }

    public void setDayNightTracking(boolean showDayNightShading) {
        this.showDayNightShading = showDayNightShading;
    }

    public Coordinates getCoordinates() {
        return this.centerCoords;
    }

    public void setCoordinates(Coordinates c) {
        if (c != null) {
            this.centerCoords = c;
        }
    }

    public void destroy() {
        this.update = false;
        this.keepRunning = false;
        this.marsSphere = null;
        this.topoSphere = null;
        this.centerCoords = null;
    }
}

