/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.navigator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.tool.navigator.NavigatorWindow;

public class NavButtonDisplay
extends JComponent
implements MouseListener {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.tool.navigator.NavButtonDisplay";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    static final double degree = Math.PI / 180;
    private NavigatorWindow parentNavigator;
    private int buttonLight;
    private Image navMain;
    private Coordinates centerCoords;
    private final Image[] lightUpButtons;
    private final Rectangle[] hotSpots;

    public NavButtonDisplay(NavigatorWindow parentNavigator) {
        this.setPreferredSize(new Dimension(150, 150));
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.addMouseListener(this);
        this.centerCoords = new Coordinates(1.5707963267948966, 0.0);
        this.buttonLight = -1;
        this.lightUpButtons = new Image[9];
        this.parentNavigator = parentNavigator;
        this.navMain = ImageLoader.getImage("NavMain.png");
        this.lightUpButtons[0] = ImageLoader.getImage("NavMainPlus.png");
        this.lightUpButtons[1] = ImageLoader.getImage("NavNorth.png");
        this.lightUpButtons[2] = ImageLoader.getImage("NavSouth.png");
        this.lightUpButtons[3] = ImageLoader.getImage("NavEast.png");
        this.lightUpButtons[4] = ImageLoader.getImage("NavWest.png");
        this.lightUpButtons[5] = ImageLoader.getImage("NavNorthPlus.png");
        this.lightUpButtons[6] = ImageLoader.getImage("NavSouthPlus.png");
        this.lightUpButtons[7] = ImageLoader.getImage("NavEastPlus.png");
        this.lightUpButtons[8] = ImageLoader.getImage("NavWestPlus.png");
        MediaTracker mtrack = new MediaTracker(this);
        mtrack.addImage(this.navMain, 0);
        for (int x = 0; x < 9; ++x) {
            mtrack.addImage(this.lightUpButtons[x], x + 1);
        }
        try {
            mtrack.waitForAll();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "NavButtonDisplay Media Tracker Error " + e);
        }
        this.hotSpots = new Rectangle[9];
        this.hotSpots[0] = new Rectangle(45, 45, 60, 60);
        this.hotSpots[1] = new Rectangle(38, 16, 74, 21);
        this.hotSpots[2] = new Rectangle(38, 112, 74, 21);
        this.hotSpots[3] = new Rectangle(113, 38, 21, 74);
        this.hotSpots[4] = new Rectangle(17, 38, 21, 74);
        this.hotSpots[5] = new Rectangle(60, 0, 29, 14);
        this.hotSpots[6] = new Rectangle(60, 134, 29, 14);
        this.hotSpots[7] = new Rectangle(135, 61, 15, 28);
        this.hotSpots[8] = new Rectangle(0, 61, 15, 28);
    }

    public void updateCoords(Coordinates newCenter) {
        this.centerCoords.setCoords(newCenter);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, 150, 150);
        g.drawImage(this.navMain, 0, 0, this);
        if (this.buttonLight >= 0) {
            g.drawImage(this.lightUpButtons[this.buttonLight], 0, 0, this);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.lightButton(event.getX(), event.getY());
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.unlightButtons();
        int spot = this.findHotSpot(event.getX(), event.getY());
        switch (spot) {
            case 0: {
                this.parentNavigator.updateCoords(this.centerCoords);
                break;
            }
            case 1: {
                this.centerCoords.setPhi(this.centerCoords.getPhi() - 0.08726646259971647);
                if (!(this.centerCoords.getPhi() < 0.0)) break;
                this.centerCoords.setPhi(0.0);
                break;
            }
            case 2: {
                this.centerCoords.setPhi(this.centerCoords.getPhi() + 0.08726646259971647);
                if (!(this.centerCoords.getPhi() > Math.PI)) break;
                this.centerCoords.setPhi(Math.PI);
                break;
            }
            case 3: {
                this.centerCoords.setTheta(this.centerCoords.getTheta() + 0.08726646259971647);
                if (!(this.centerCoords.getTheta() > Math.PI * 2)) break;
                this.centerCoords.setTheta(this.centerCoords.getTheta() - Math.PI * 2);
                break;
            }
            case 4: {
                this.centerCoords.setTheta(this.centerCoords.getTheta() - 0.08726646259971647);
                if (!(this.centerCoords.getTheta() < 0.0)) break;
                this.centerCoords.setTheta(this.centerCoords.getTheta() + Math.PI * 2);
                break;
            }
            case 5: {
                this.centerCoords.setPhi(this.centerCoords.getPhi() - 0.5235987755982988);
                if (!(this.centerCoords.getPhi() < 0.0)) break;
                this.centerCoords.setPhi(0.0);
                break;
            }
            case 6: {
                this.centerCoords.setPhi(this.centerCoords.getPhi() + 0.5235987755982988);
                if (!(this.centerCoords.getPhi() > Math.PI)) break;
                this.centerCoords.setPhi(Math.PI);
                break;
            }
            case 7: {
                this.centerCoords.setTheta(this.centerCoords.getTheta() + 0.5235987755982988);
                if (!(this.centerCoords.getTheta() >= Math.PI * 2)) break;
                this.centerCoords.setTheta(this.centerCoords.getTheta() - Math.PI * 2);
                break;
            }
            case 8: {
                this.centerCoords.setTheta(this.centerCoords.getTheta() - 0.5235987755982988);
                if (!(this.centerCoords.getTheta() < 0.0)) break;
                this.centerCoords.setTheta(this.centerCoords.getTheta() + Math.PI * 2);
            }
        }
        if (spot > 0) {
            this.parentNavigator.updateGlobeOnly(this.centerCoords);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    private void lightButton(int x, int y) {
        this.buttonLight = this.findHotSpot(x, y);
        if (this.buttonLight >= 0) {
            this.repaint();
        }
    }

    private void unlightButtons() {
        if (this.buttonLight >= 0) {
            this.buttonLight = -1;
            this.repaint();
        }
    }

    private int findHotSpot(int x, int y) {
        for (int i = 0; i < 9; ++i) {
            if (!this.hotSpots[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }
}

