/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;
import org.mars_sim.msp.ui.swing.tool.map.ExploredSiteMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.LandmarkMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;
import org.mars_sim.msp.ui.swing.tool.map.MapPanel;
import org.mars_sim.msp.ui.swing.tool.map.MineralMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.NavpointMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.ShadingMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.UnitIconMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.UnitLabelMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.VehicleTrailMapLayer;
import org.mars_sim.msp.ui.swing.tool.navigator.GlobeDisplay;
import org.mars_sim.msp.ui.swing.tool.navigator.LegendDisplay;
import org.mars_sim.msp.ui.swing.tool.navigator.NavButtonDisplay;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfo;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfoFactory;

public class NavigatorWindow
extends ToolWindow
implements ActionListener {
    public static final String NAME = "Mars Navigator";
    private MapPanel map;
    private GlobeDisplay globeNav;
    private NavButtonDisplay navButtons;
    private LegendDisplay legend;
    private JTextField latText;
    private JTextField longText;
    private JComboBox latDir;
    private JComboBox longDir;
    private JButton goThere;
    private JButton optionsButton;
    private JPopupMenu optionsMenu;
    private JButton mineralsButton;
    private JCheckBoxMenuItem topoItem;
    private JCheckBoxMenuItem unitLabelItem;
    private JCheckBoxMenuItem dayNightItem;
    private JCheckBoxMenuItem usgsItem;
    private JCheckBoxMenuItem trailItem;
    private JCheckBoxMenuItem landmarkItem;
    private JCheckBoxMenuItem navpointItem;
    private JCheckBoxMenuItem exploredSiteItem;
    private JCheckBoxMenuItem mineralItem;
    private MapLayer unitIconLayer;
    private MapLayer unitLabelLayer;
    private MapLayer shadingLayer;
    private MapLayer mineralLayer;
    private MapLayer trailLayer;
    private MapLayer navpointLayer;
    private MapLayer landmarkLayer;
    private MapLayer exploredSiteLayer;

    public NavigatorWindow(MainDesktopPane desktop) {
        super(NAME, desktop);
        this.setResizable(false);
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new BoxLayout(mainPane, 1));
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(mainPane);
        JPanel topMainPane = new JPanel();
        topMainPane.setLayout(new BoxLayout(topMainPane, 0));
        mainPane.add(topMainPane);
        JPanel leftTopPane = new JPanel();
        leftTopPane.setLayout(new BoxLayout(leftTopPane, 1));
        topMainPane.add(leftTopPane);
        this.globeNav = new GlobeDisplay(this, 150, 150);
        JPanel globePane = new JPanel(new FlowLayout(0, 0, 0));
        globePane.setBorder(new CompoundBorder(new BevelBorder(1), new LineBorder(Color.gray)));
        globePane.add(this.globeNav);
        leftTopPane.add(globePane);
        this.navButtons = new NavButtonDisplay(this);
        JPanel navPane = new JPanel(new FlowLayout(0, 0, 0));
        navPane.setBorder(new CompoundBorder(new BevelBorder(1), new LineBorder(Color.gray)));
        navPane.add(this.navButtons);
        leftTopPane.add(navPane);
        topMainPane.add(Box.createHorizontalStrut(5));
        JPanel rightTopPane = new JPanel();
        rightTopPane.setLayout(new BoxLayout(rightTopPane, 1));
        topMainPane.add(rightTopPane);
        JPanel mapPane = new JPanel(new BorderLayout(0, 0));
        mapPane.setBorder(new CompoundBorder(new BevelBorder(1), new LineBorder(Color.gray)));
        rightTopPane.add(mapPane);
        JPanel mapPaneInner = new JPanel(new BorderLayout(0, 0));
        mapPaneInner.setBackground(Color.black);
        this.map = new MapPanel();
        this.map.addMouseListener(new mapClickListener());
        this.unitIconLayer = new UnitIconMapLayer(this.map);
        this.unitLabelLayer = new UnitLabelMapLayer();
        this.map.addMapLayer(this.unitLabelLayer);
        this.mineralLayer = new MineralMapLayer(this.map);
        this.shadingLayer = new ShadingMapLayer(this.map);
        this.navpointLayer = new NavpointMapLayer(this.map);
        this.trailLayer = new VehicleTrailMapLayer();
        this.landmarkLayer = new LandmarkMapLayer();
        this.exploredSiteLayer = new ExploredSiteMapLayer(this.map);
        this.map.addMapLayer(this.unitIconLayer);
        this.map.addMapLayer(this.unitLabelLayer);
        this.map.addMapLayer(this.navpointLayer);
        this.map.addMapLayer(this.trailLayer);
        this.map.addMapLayer(this.landmarkLayer);
        this.map.showMap(new Coordinates(1.5707963267948966, 0.0));
        mapPaneInner.add((Component)this.map, "Center");
        mapPane.add((Component)mapPaneInner, "Center");
        this.unitIconLayer = new UnitIconMapLayer(this.map);
        rightTopPane.add(Box.createVerticalStrut(5));
        JPanel topoPane = new JPanel(new BorderLayout());
        topoPane.setBorder(new EmptyBorder(0, 3, 0, 0));
        mainPane.add(topoPane);
        JPanel optionsPane = new JPanel(new GridLayout(2, 1));
        topoPane.add((Component)optionsPane, "Center");
        this.optionsButton = new JButton("Map Options \u25bc");
        this.optionsButton.setToolTipText("Options for displaying map.");
        this.optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (NavigatorWindow.this.optionsMenu == null) {
                    NavigatorWindow.this.createOptionsMenu();
                }
                NavigatorWindow.this.optionsMenu.show(NavigatorWindow.this.optionsButton, 0, NavigatorWindow.this.optionsButton.getHeight());
            }
        });
        optionsPane.add(this.optionsButton);
        this.mineralsButton = new JButton("Minerals \u25bc");
        this.mineralsButton.setToolTipText("Options for displaying minerals on map.");
        this.mineralsButton.setEnabled(false);
        this.mineralsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JPopupMenu mineralsMenu = NavigatorWindow.this.createMineralsMenu();
                mineralsMenu.show(NavigatorWindow.this.mineralsButton, 0, NavigatorWindow.this.mineralsButton.getHeight());
            }
        });
        optionsPane.add(this.mineralsButton);
        this.legend = new LegendDisplay();
        this.legend.setBorder(new CompoundBorder(new BevelBorder(1), new LineBorder(Color.gray)));
        JPanel legendPanel = new JPanel(new BorderLayout(0, 0));
        legendPanel.add((Component)this.legend, "North");
        topoPane.add((Component)legendPanel, "East");
        JPanel positionPane = new JPanel();
        positionPane.setLayout(new BoxLayout(positionPane, 0));
        positionPane.setBorder(new EmptyBorder(6, 6, 3, 3));
        mainPane.add(positionPane);
        JLabel latLabel = new JLabel("Latitude: ");
        latLabel.setAlignmentY(0.5f);
        positionPane.add(latLabel);
        this.latText = new JTextField(5);
        positionPane.add(this.latText);
        String[] latStrings = new String[]{"N", "S"};
        this.latDir = new JComboBox<String>(latStrings);
        this.latDir.setEditable(false);
        this.latDir.setPreferredSize(new Dimension(45, -1));
        positionPane.add(this.latDir);
        positionPane.add(Box.createHorizontalGlue());
        positionPane.add(Box.createHorizontalStrut(5));
        JLabel longLabel = new JLabel("Longitude: ");
        longLabel.setAlignmentY(0.5f);
        positionPane.add(longLabel);
        this.longText = new JTextField(5);
        positionPane.add(this.longText);
        String[] longStrings = new String[]{"E", "W"};
        this.longDir = new JComboBox<String>(longStrings);
        this.longDir.setEditable(false);
        this.longDir.setPreferredSize(new Dimension(45, -1));
        positionPane.add(this.longDir);
        positionPane.add(Box.createHorizontalGlue());
        positionPane.add(Box.createHorizontalStrut(5));
        this.goThere = new JButton("Go There");
        this.goThere.addActionListener(this);
        this.goThere.setAlignmentY(0.5f);
        positionPane.add(this.goThere);
        this.pack();
    }

    public void updateCoords(Coordinates newCoords) {
        this.navButtons.updateCoords(newCoords);
        this.map.showMap(newCoords);
        this.globeNav.showGlobe(newCoords);
    }

    public void updateGlobeOnly(Coordinates newCoords) {
        this.globeNav.showGlobe(newCoords);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.goThere) {
            try {
                double latitude = new Float(this.latText.getText()).doubleValue();
                double longitude = new Float(this.longText.getText()).doubleValue();
                String latDirStr = (String)this.latDir.getSelectedItem();
                String longDirStr = (String)this.longDir.getSelectedItem();
                if (latitude >= 0.0 && latitude <= 90.0 && longitude >= 0.0 && longitude <= 180.0) {
                    latitude = latDirStr.equals("N") ? 90.0 - latitude : (latitude += 90.0);
                    if (longitude > 0.0 && longDirStr.equals("W")) {
                        longitude = 360.0 - longitude;
                    }
                    double phi = Math.PI * (latitude / 180.0);
                    double theta = Math.PI * 2 * (longitude / 360.0);
                    this.updateCoords(new Coordinates(phi, theta));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (source == this.topoItem) {
            if (this.topoItem.isSelected()) {
                this.map.setMapType("topographical map");
                this.globeNav.showTopo();
                this.legend.showColor();
            } else {
                this.map.setMapType("surface map");
                this.globeNav.showSurf();
                this.legend.showMap();
            }
        } else if (source == this.usgsItem) {
            if (this.usgsItem.isSelected()) {
                this.map.setMapType("USGS map");
            } else {
                this.map.setMapType("surface map");
            }
            this.globeNav.setUSGSMap(this.usgsItem.isSelected());
            this.legend.setUSGSMode(this.usgsItem.isSelected());
            this.legend.showMap();
            this.topoItem.setEnabled(!this.usgsItem.isSelected());
        } else if (source == this.dayNightItem) {
            this.setMapLayer(this.dayNightItem.isSelected(), this.shadingLayer);
            this.globeNav.setDayNightTracking(this.dayNightItem.isSelected());
        } else if (source == this.unitLabelItem) {
            this.setMapLayer(this.unitLabelItem.isSelected(), this.unitLabelLayer);
        } else if (source == this.trailItem) {
            this.setMapLayer(this.trailItem.isSelected(), this.trailLayer);
        } else if (source == this.landmarkItem) {
            this.setMapLayer(this.landmarkItem.isSelected(), this.landmarkLayer);
        } else if (source == this.navpointItem) {
            this.setMapLayer(this.navpointItem.isSelected(), this.navpointLayer);
        } else if (source == this.exploredSiteItem) {
            this.setMapLayer(this.exploredSiteItem.isSelected(), this.exploredSiteLayer);
        } else if (source == this.mineralItem) {
            this.setMapLayer(this.mineralItem.isSelected(), this.mineralLayer);
            this.mineralsButton.setEnabled(this.mineralItem.isSelected());
        }
    }

    private void setMapLayer(boolean setMap, MapLayer mapLayer) {
        if (setMap) {
            this.map.addMapLayer(mapLayer);
        } else {
            this.map.removeMapLayer(mapLayer);
        }
    }

    private void createOptionsMenu() {
        this.optionsMenu = new JPopupMenu("Map Options");
        this.topoItem = new JCheckBoxMenuItem("Topographical Mode", "topographical map".equals(this.map.getMapType()));
        this.topoItem.addActionListener(this);
        this.optionsMenu.add(this.topoItem);
        this.unitLabelItem = new JCheckBoxMenuItem("Show Unit Labels", this.map.hasMapLayer(this.unitLabelLayer));
        this.unitLabelItem.addActionListener(this);
        this.optionsMenu.add(this.unitLabelItem);
        this.dayNightItem = new JCheckBoxMenuItem("Day/Night Tracking", this.map.hasMapLayer(this.shadingLayer));
        this.dayNightItem.addActionListener(this);
        this.optionsMenu.add(this.dayNightItem);
        this.usgsItem = new JCheckBoxMenuItem("8x Surface Map Zoom", "USGS map".equals(this.map.getMapType()));
        this.usgsItem.addActionListener(this);
        this.usgsItem.setEnabled(false);
        this.optionsMenu.add(this.usgsItem);
        this.trailItem = new JCheckBoxMenuItem("Show Vehicle Trails", this.map.hasMapLayer(this.trailLayer));
        this.trailItem.addActionListener(this);
        this.optionsMenu.add(this.trailItem);
        this.landmarkItem = new JCheckBoxMenuItem("Show Landmarks", this.map.hasMapLayer(this.landmarkLayer));
        this.landmarkItem.addActionListener(this);
        this.optionsMenu.add(this.landmarkItem);
        this.navpointItem = new JCheckBoxMenuItem("Show Mission Navpoints", this.map.hasMapLayer(this.navpointLayer));
        this.navpointItem.addActionListener(this);
        this.optionsMenu.add(this.navpointItem);
        this.exploredSiteItem = new JCheckBoxMenuItem("Show Explored Sites", this.map.hasMapLayer(this.exploredSiteLayer));
        this.exploredSiteItem.addActionListener(this);
        this.optionsMenu.add(this.exploredSiteItem);
        this.mineralItem = new JCheckBoxMenuItem("Show Minerals", this.map.hasMapLayer(this.mineralLayer));
        this.mineralItem.addActionListener(this);
        this.optionsMenu.add(this.mineralItem);
        this.optionsMenu.pack();
    }

    private JPopupMenu createMineralsMenu() {
        JPopupMenu mineralsMenu = new JPopupMenu();
        MineralMapLayer mineralMapLayer = (MineralMapLayer)this.mineralLayer;
        Map<String, Color> mineralColors = mineralMapLayer.getMineralColors();
        for (String mineralName : mineralColors.keySet()) {
            Color mineralColor = mineralColors.get(mineralName);
            boolean isMineralDisplayed = mineralMapLayer.isMineralDisplayed(mineralName);
            JCheckBoxMenuItem mineralItem = new JCheckBoxMenuItem(mineralName, isMineralDisplayed);
            mineralItem.setIcon(this.createColorLegendIcon(mineralColor, mineralItem));
            mineralItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JCheckBoxMenuItem checkboxItem = (JCheckBoxMenuItem)event.getSource();
                    ((MineralMapLayer)NavigatorWindow.this.mineralLayer).setMineralDisplayed(checkboxItem.getText(), checkboxItem.isSelected());
                }
            });
            mineralsMenu.add(mineralItem);
        }
        mineralsMenu.pack();
        return mineralsMenu;
    }

    private Icon createColorLegendIcon(Color color, Component displayComponent) {
        int[] imageArray = new int[100];
        Arrays.fill(imageArray, color.getRGB());
        Image image = displayComponent.createImage(new MemoryImageSource(10, 10, imageArray, 0, 10));
        return new ImageIcon(image);
    }

    public void openUnitWindow(Unit unit) {
        this.desktop.openUnitWindow(unit, false);
    }

    @Override
    public void destroy() {
        this.map.destroy();
        this.globeNav.destroy();
    }

    private class mapClickListener
    extends MouseAdapter {
        private mapClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (NavigatorWindow.this.map.getCenterLocation() != null) {
                double rho = "USGS map".equals(NavigatorWindow.this.map.getMapType()) ? 3647.194675893874 : 458.3662361046586;
                Coordinates clickedPosition = NavigatorWindow.this.map.getCenterLocation().convertRectToSpherical((double)(event.getX() - 150 - 1), (double)(event.getY() - 150 - 1), rho);
                boolean unitsClicked = false;
                for (Unit unit : Simulation.instance().getUnitManager().getUnits()) {
                    UnitDisplayInfo displayInfo = UnitDisplayInfoFactory.getUnitDisplayInfo(unit);
                    if (!displayInfo.isMapDisplayed(unit)) continue;
                    Coordinates unitCoords = unit.getCoordinates();
                    double clickRange = unitCoords.getDistance(clickedPosition);
                    double unitClickRange = displayInfo.getMapClickRange();
                    if ("USGS map".equals(NavigatorWindow.this.map.getMapType())) {
                        unitClickRange *= 0.1257;
                    }
                    if (!(clickRange < unitClickRange)) continue;
                    NavigatorWindow.this.openUnitWindow(unit);
                    unitsClicked = true;
                }
                if (!unitsClicked) {
                    NavigatorWindow.this.updateCoords(clickedPosition);
                }
            }
        }
    }
}

