/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.events.HistoricalEvent;
import org.mars_sim.msp.core.events.HistoricalEventListener;
import org.mars_sim.msp.core.interplanetary.transport.TransportManager;
import org.mars_sim.msp.core.interplanetary.transport.Transportable;

public class ArrivedListPanel
extends JPanel
implements ListSelectionListener {
    private JList arrivedList;
    private ArrivedListModel listModel;

    public ArrivedListPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Arrived Transport Items"));
        this.setPreferredSize(new Dimension(200, 200));
        this.listModel = new ArrivedListModel();
        this.arrivedList = new JList(this.listModel);
        this.arrivedList.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.arrivedList);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollPane, "Center");
    }

    JList getArrivedList() {
        return this.arrivedList;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        JList incomingList;
        if (evt.getValueIsAdjusting() && (incomingList = (JList)evt.getSource()).getSelectedValue() != null) {
            this.arrivedList.clearSelection();
        }
    }

    public void destroy() {
        this.listModel.destroy();
    }

    private class ArrivedListModel
    extends AbstractListModel
    implements HistoricalEventListener {
        private List<Transportable> resupplyList;

        private ArrivedListModel() {
            TransportManager manager = Simulation.instance().getTransportManager();
            this.resupplyList = manager.getArrivedTransportItems();
            Collections.sort(this.resupplyList);
            Simulation.instance().getEventManager().addListener((HistoricalEventListener)this);
        }

        @Override
        public Transportable getElementAt(int index) {
            Transportable result = null;
            if (index > -1 && index < this.resupplyList.size()) {
                result = this.resupplyList.get(index);
            }
            return result;
        }

        @Override
        public int getSize() {
            return this.resupplyList.size();
        }

        public void eventAdded(int index, HistoricalEvent event) {
            if (event.getCategory().equals("Transport")) {
                Transportable transportItem = (Transportable)event.getSource();
                if ("Transport Item Arrived".equals(event.getType())) {
                    this.resupplyList.add(transportItem);
                    Collections.sort(this.resupplyList);
                    int transportItemIndex = this.resupplyList.indexOf(transportItem);
                    this.fireIntervalAdded(this, transportItemIndex, transportItemIndex);
                }
            }
        }

        public void eventsRemoved(int startIndex, int endIndex) {
        }

        public void destroy() {
            this.resupplyList.clear();
            this.resupplyList = null;
            Simulation.instance().getEventManager().removeListener((HistoricalEventListener)this);
        }
    }
}

