/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.events.HistoricalEvent;
import org.mars_sim.msp.core.events.HistoricalEventListener;
import org.mars_sim.msp.core.interplanetary.transport.settlement.ArrivingSettlement;
import org.mars_sim.msp.core.time.ClockListener;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;

public class ArrivingSettlementDetailPanel
extends JPanel
implements ClockListener,
HistoricalEventListener {
    private ArrivingSettlement arrivingSettlement;
    private JLabel nameValueLabel;
    private JLabel stateValueLabel;
    private JLabel arrivalDateValueLabel;
    private JLabel timeArrivalValueLabel;
    private int solsToArrival = -1;
    private JLabel templateValueLabel;
    private JLabel locationValueLabel;
    private JLabel populationValueLabel;

    public ArrivingSettlementDetailPanel() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(new MarsPanelBorder());
        JPanel infoPane = new JPanel(new BorderLayout());
        this.add((Component)infoPane, "North");
        JLabel titleLabel = new JLabel("Arriving Settlement", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        titleLabel.setPreferredSize(new Dimension(-1, 25));
        infoPane.add((Component)titleLabel, "North");
        JPanel info2Pane = new JPanel(new GridLayout(7, 1, 5, 5));
        infoPane.add((Component)info2Pane, "Center");
        JPanel namePane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(namePane);
        JLabel nameTitleLabel = new JLabel("Name: ", 2);
        namePane.add(nameTitleLabel);
        this.nameValueLabel = new JLabel("", 2);
        namePane.add(this.nameValueLabel);
        JPanel statePane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(statePane);
        JLabel stateTitleLabel = new JLabel("State: ", 2);
        statePane.add(stateTitleLabel);
        this.stateValueLabel = new JLabel("", 2);
        statePane.add(this.stateValueLabel);
        JPanel templatePane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(templatePane);
        JLabel templateTitleLabel = new JLabel("Layout Template: ", 2);
        templatePane.add(templateTitleLabel);
        this.templateValueLabel = new JLabel("", 2);
        templatePane.add(this.templateValueLabel);
        JPanel populationPane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(populationPane);
        JLabel populationTitleLabel = new JLabel("Immigrants: ", 2);
        populationPane.add(populationTitleLabel);
        this.populationValueLabel = new JLabel("", 2);
        populationPane.add(this.populationValueLabel);
        JPanel arrivalDatePane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(arrivalDatePane);
        JLabel arrivalDateTitleLabel = new JLabel("Arrival Date: ", 2);
        arrivalDatePane.add(arrivalDateTitleLabel);
        this.arrivalDateValueLabel = new JLabel("", 2);
        arrivalDatePane.add(this.arrivalDateValueLabel);
        JPanel timeArrivalPane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(timeArrivalPane);
        JLabel timeArrivalTitleLabel = new JLabel("Time Until Arrival: ", 2);
        timeArrivalPane.add(timeArrivalTitleLabel);
        this.timeArrivalValueLabel = new JLabel("", 2);
        timeArrivalPane.add(this.timeArrivalValueLabel);
        JPanel locationPane = new JPanel(new FlowLayout(0, 0, 0));
        info2Pane.add(locationPane);
        JLabel locationTitleLabel = new JLabel("Location: ", 2);
        locationPane.add(locationTitleLabel);
        this.locationValueLabel = new JLabel("", 2);
        locationPane.add(this.locationValueLabel);
        Simulation.instance().getMasterClock().addClockListener((ClockListener)this);
        Simulation.instance().getEventManager().addListener((HistoricalEventListener)this);
    }

    public void setArrivingSettlement(ArrivingSettlement newArrivingSettlement) {
        if (this.arrivingSettlement != newArrivingSettlement) {
            this.arrivingSettlement = newArrivingSettlement;
            if (newArrivingSettlement == null) {
                this.clearInfo();
            } else {
                this.updateArrivingSettlementInfo();
            }
        }
    }

    private void clearInfo() {
        this.nameValueLabel.setText("");
        this.stateValueLabel.setText("");
        this.arrivalDateValueLabel.setText("");
        this.timeArrivalValueLabel.setText("");
        this.templateValueLabel.setText("");
        this.locationValueLabel.setText("");
        this.populationValueLabel.setText("");
    }

    private void updateArrivingSettlementInfo() {
        this.nameValueLabel.setText(this.arrivingSettlement.getName());
        this.stateValueLabel.setText(this.arrivingSettlement.getTransitState());
        this.arrivalDateValueLabel.setText(this.arrivingSettlement.getArrivalDate().getDateString());
        this.updateTimeToArrival();
        this.templateValueLabel.setText(this.arrivingSettlement.getTemplate());
        this.locationValueLabel.setText(this.arrivingSettlement.getLandingLocation().getFormattedString());
        this.populationValueLabel.setText(Integer.toString(this.arrivingSettlement.getPopulationNum()));
        this.validate();
    }

    private void updateTimeToArrival() {
        String timeArrival = "---";
        this.solsToArrival = -1;
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        double timeDiff = MarsClock.getTimeDiff((MarsClock)this.arrivingSettlement.getArrivalDate(), (MarsClock)currentTime);
        if (timeDiff > 0.0) {
            this.solsToArrival = (int)Math.abs(timeDiff / 1000.0);
            timeArrival = Integer.toString(this.solsToArrival) + " Sols";
        }
        this.timeArrivalValueLabel.setText(timeArrival);
    }

    public void destroy() {
        this.arrivingSettlement = null;
        Simulation.instance().getEventManager().removeListener((HistoricalEventListener)this);
        Simulation.instance().getMasterClock().removeClockListener((ClockListener)this);
    }

    public void eventAdded(int index, HistoricalEvent event) {
        if ("Transport".equals(event.getCategory()) && "Transport Item Modified".equals(event.getType()) && this.arrivingSettlement != null && event.getSource().equals(this.arrivingSettlement)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ArrivingSettlementDetailPanel.this.arrivingSettlement != null) {
                        ArrivingSettlementDetailPanel.this.updateArrivingSettlementInfo();
                    }
                }
            });
        }
    }

    public void eventsRemoved(int startIndex, int endIndex) {
    }

    public void clockPulse(double time) {
        if (this.arrivingSettlement != null && this.solsToArrival >= 0) {
            MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
            double timeDiff = MarsClock.getTimeDiff((MarsClock)this.arrivingSettlement.getArrivalDate(), (MarsClock)currentTime);
            double newSolsToArrival = (int)Math.abs(timeDiff / 1000.0);
            if (newSolsToArrival != (double)this.solsToArrival) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ArrivingSettlementDetailPanel.this.arrivingSettlement != null) {
                            ArrivingSettlementDetailPanel.this.updateTimeToArrival();
                        }
                    }
                });
            }
        }
    }

    public void pauseChange(boolean isPaused) {
    }
}

