/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import javax.swing.DefaultComboBoxModel;
import org.mars_sim.msp.core.time.MarsClock;

public class MartianSolComboBoxModel
extends DefaultComboBoxModel {
    private int maxSolNum;

    public MartianSolComboBoxModel(int month, int orbit) {
        this.maxSolNum = MarsClock.getSolsInMonth((int)month, (int)orbit);
        for (int x = 1; x <= this.maxSolNum; ++x) {
            this.addElement(x);
        }
    }

    public void updateSolNumber(int month, int orbit) {
        int newMaxSolNum = MarsClock.getSolsInMonth((int)month, (int)orbit);
        if (newMaxSolNum != this.maxSolNum) {
            int oldSelectedSol = (Integer)this.getSelectedItem();
            if (newMaxSolNum < this.maxSolNum) {
                this.removeElementAt(this.maxSolNum - 1);
                if (oldSelectedSol == this.maxSolNum) {
                    this.setSelectedItem(newMaxSolNum);
                }
            } else {
                this.addElement(newMaxSolNum);
            }
            this.maxSolNum = newMaxSolNum;
        }
    }
}

