/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.resupply.ArrivingSettlementEditingPanel;
import org.mars_sim.msp.ui.swing.tool.resupply.ResupplyMissionEditingPanel;
import org.mars_sim.msp.ui.swing.tool.resupply.TransportItemEditingPanel;

public class NewTransportItemDialog
extends JDialog {
    private static final String DEFAULT_MESSAGE = "Select Transport Item Type";
    private static final String RESUPPLY_MISSION = "New Resupply Mission";
    private static final String ARRIVING_SETTLEMENT = "New Arriving Settlement";
    private TransportItemEditingPanel editingPanel;
    private JPanel mainEditingPanel;
    private CardLayout mainEditingLayout;
    private JPanel emptyPanel;
    private TransportItemEditingPanel resupplyMissionPanel;
    private TransportItemEditingPanel arrivingSettlementPanel;
    private JButton createButton;

    public NewTransportItemDialog(JFrame owner) {
        super(owner, "New Transport Item", true);
        this.setLayout(new BorderLayout(0, 0));
        ((JComponent)this.getContentPane()).setBorder(new MarsPanelBorder());
        JPanel transportTypePanel = new JPanel(new FlowLayout(10, 10, 1));
        this.getContentPane().add((Component)transportTypePanel, "North");
        JComboBox<String> typeBox = new JComboBox<String>();
        typeBox.addItem(DEFAULT_MESSAGE);
        typeBox.addItem(RESUPPLY_MISSION);
        typeBox.addItem(ARRIVING_SETTLEMENT);
        typeBox.setSelectedItem(DEFAULT_MESSAGE);
        typeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JComboBox cb = (JComboBox)evt.getSource();
                NewTransportItemDialog.this.setEditingPanel((String)cb.getSelectedItem());
            }
        });
        transportTypePanel.add(typeBox);
        this.mainEditingLayout = new CardLayout();
        this.mainEditingPanel = new JPanel(this.mainEditingLayout);
        this.getContentPane().add((Component)this.mainEditingPanel, "Center");
        this.emptyPanel = new JPanel();
        this.emptyPanel.setBorder(new MarsPanelBorder());
        this.mainEditingPanel.add((Component)this.emptyPanel, DEFAULT_MESSAGE);
        this.resupplyMissionPanel = new ResupplyMissionEditingPanel(null);
        this.mainEditingPanel.add((Component)this.resupplyMissionPanel, RESUPPLY_MISSION);
        this.arrivingSettlementPanel = new ArrivingSettlementEditingPanel(null);
        this.mainEditingPanel.add((Component)this.arrivingSettlementPanel, ARRIVING_SETTLEMENT);
        JPanel buttonPane = new JPanel(new FlowLayout(1, 10, 5));
        this.getContentPane().add((Component)buttonPane, "South");
        this.createButton = new JButton("Create");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTransportItemDialog.this.createTransportItem();
            }
        });
        this.createButton.setEnabled(false);
        buttonPane.add(this.createButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NewTransportItemDialog.this.dispose();
            }
        });
        buttonPane.add(cancelButton);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void setEditingPanel(String panelKey) {
        if (panelKey != null) {
            this.mainEditingLayout.show(this.mainEditingPanel, panelKey);
            if (panelKey.equals(DEFAULT_MESSAGE)) {
                this.editingPanel = null;
                this.createButton.setEnabled(false);
            } else if (panelKey.equals(RESUPPLY_MISSION)) {
                this.editingPanel = this.resupplyMissionPanel;
                this.createButton.setEnabled(true);
            } else if (panelKey.equals(ARRIVING_SETTLEMENT)) {
                this.editingPanel = this.arrivingSettlementPanel;
                this.createButton.setEnabled(true);
            }
        }
    }

    private void createTransportItem() {
        if (this.editingPanel != null && this.editingPanel.createTransportItem()) {
            this.dispose();
        }
    }
}

