/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.interplanetary.transport.Transportable;
import org.mars_sim.msp.core.interplanetary.transport.resupply.Resupply;
import org.mars_sim.msp.core.interplanetary.transport.settlement.ArrivingSettlement;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;
import org.mars_sim.msp.ui.swing.tool.resupply.ArrivedListPanel;
import org.mars_sim.msp.ui.swing.tool.resupply.IncomingListPanel;
import org.mars_sim.msp.ui.swing.tool.resupply.ModifyTransportItemDialog;
import org.mars_sim.msp.ui.swing.tool.resupply.NewTransportItemDialog;
import org.mars_sim.msp.ui.swing.tool.resupply.TransportDetailPanel;

public class ResupplyWindow
extends ToolWindow
implements ListSelectionListener {
    public static final String NAME = "Resupply Tool";
    private IncomingListPanel incomingListPane;
    private ArrivedListPanel arrivedListPane;
    private TransportDetailPanel detailPane;
    private JButton modifyButton;
    private JButton cancelButton;

    public ResupplyWindow(MainDesktopPane desktop) {
        super(NAME, desktop);
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(mainPane);
        JPanel listPane = new JPanel(new GridLayout(2, 1));
        mainPane.add((Component)listPane, "West");
        this.incomingListPane = new IncomingListPanel();
        this.incomingListPane.getIncomingList().addListSelectionListener(this);
        listPane.add(this.incomingListPane);
        this.arrivedListPane = new ArrivedListPanel();
        listPane.add(this.arrivedListPane);
        this.incomingListPane.getIncomingList().addListSelectionListener(this.arrivedListPane);
        this.arrivedListPane.getArrivedList().addListSelectionListener(this.incomingListPane);
        this.detailPane = new TransportDetailPanel();
        this.incomingListPane.getIncomingList().addListSelectionListener(this.detailPane);
        this.arrivedListPane.getArrivedList().addListSelectionListener(this.detailPane);
        mainPane.add((Component)this.detailPane, "Center");
        JPanel buttonPane = new JPanel(new FlowLayout(1));
        mainPane.add((Component)buttonPane, "South");
        JButton newButton = new JButton("New");
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResupplyWindow.this.createNewTransportItem();
            }
        });
        buttonPane.add(newButton);
        this.modifyButton = new JButton("Modify");
        this.modifyButton.setEnabled(false);
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResupplyWindow.this.modifyTransportItem();
            }
        });
        buttonPane.add(this.modifyButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResupplyWindow.this.cancelTransportItem();
            }
        });
        buttonPane.add(this.cancelButton);
        this.pack();
    }

    private void createNewTransportItem() {
        this.desktop.getMainWindow().pauseSimulation();
        new NewTransportItemDialog(this.desktop.getMainWindow().getFrame());
        this.desktop.getMainWindow().unpauseSimulation();
    }

    private void modifyTransportItem() {
        this.desktop.getMainWindow().pauseSimulation();
        Transportable transportItem = (Transportable)this.incomingListPane.getIncomingList().getSelectedValue();
        if (transportItem != null) {
            if (transportItem instanceof Resupply) {
                Resupply resupply = (Resupply)transportItem;
                String title = "Modify Resupply Mission";
                new ModifyTransportItemDialog(this.desktop.getMainWindow().getFrame(), title, (Transportable)resupply);
            } else if (transportItem instanceof ArrivingSettlement) {
                ArrivingSettlement settlement = (ArrivingSettlement)transportItem;
                String title = "Modify Arriving Settlement";
                new ModifyTransportItemDialog(this.desktop.getMainWindow().getFrame(), title, (Transportable)settlement);
            }
        }
        this.desktop.getMainWindow().unpauseSimulation();
    }

    private void cancelTransportItem() {
        Transportable transportItem = (Transportable)this.incomingListPane.getIncomingList().getSelectedValue();
        if (transportItem != null) {
            Simulation.instance().getTransportManager().cancelTransportItem(transportItem);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            JList incomingList = (JList)evt.getSource();
            Object selected = incomingList.getSelectedValue();
            if (selected != null) {
                this.modifyButton.setEnabled(true);
                this.cancelButton.setEnabled(true);
            } else {
                this.modifyButton.setEnabled(false);
                this.cancelButton.setEnabled(false);
            }
        }
    }

    @Override
    public void destroy() {
        this.incomingListPane.destroy();
        this.arrivedListPane.destroy();
        this.detailPane.destroy();
    }
}

