/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.resupply;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.interplanetary.transport.Transportable;
import org.mars_sim.msp.core.interplanetary.transport.resupply.Resupply;
import org.mars_sim.msp.core.interplanetary.transport.settlement.ArrivingSettlement;
import org.mars_sim.msp.ui.swing.tool.resupply.ArrivingSettlementDetailPanel;
import org.mars_sim.msp.ui.swing.tool.resupply.ResupplyDetailPanel;

public class TransportDetailPanel
extends JPanel
implements ListSelectionListener {
    private static final String RESUPPLY = "resupply";
    private static final String SETTLEMENT = "settlement";
    private CardLayout cardLayout = new CardLayout();
    private ResupplyDetailPanel resupplyPanel;
    private ArrivingSettlementDetailPanel arrivingSettlementPanel;

    public TransportDetailPanel() {
        this.setLayout(this.cardLayout);
        this.setPreferredSize(new Dimension(300, 300));
        this.resupplyPanel = new ResupplyDetailPanel();
        this.add((Component)this.resupplyPanel, RESUPPLY);
        this.arrivingSettlementPanel = new ArrivingSettlementDetailPanel();
        this.add((Component)this.arrivingSettlementPanel, SETTLEMENT);
        this.cardLayout.show(this, RESUPPLY);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        JList transportList = (JList)evt.getSource();
        if (!transportList.getValueIsAdjusting()) {
            Transportable newTransportable = (Transportable)transportList.getSelectedValue();
            if (newTransportable instanceof Resupply) {
                this.resupplyPanel.setResupply((Resupply)newTransportable);
                this.cardLayout.show(this, RESUPPLY);
            } else if (newTransportable instanceof ArrivingSettlement) {
                this.arrivingSettlementPanel.setArrivingSettlement((ArrivingSettlement)newTransportable);
                this.cardLayout.show(this, SETTLEMENT);
            }
        }
    }

    public void destroy() {
        this.resupplyPanel.destroy();
        this.arrivingSettlementPanel.destroy();
    }
}

