/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.science;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.science.ScienceWindow;

class ResearcherPanel
extends JPanel {
    private static final String BLANK_PANE = "blank";
    private static final String RESEARCHER_PANE = "researcher";
    private static final String PRIMARY_RESEARCHER = "Primary Researcher  ";
    private static final String COLLAB_RESEARCHER = "Collaborative Researcher  ";
    private static final String BLANK_ACTIVITY_BAR = "blank activity bar";
    private static final String SHOW_ACTIVITY_BAR = "show activity bar";
    private ScienceWindow scienceWindow;
    private ScientificStudy study;
    private Person researcher;
    private JLabel titleLabel;
    private JButton nameButton;
    private JLabel scienceLabel;
    private JLabel activityLabel;
    private JProgressBar activityBar;
    private JPanel activityBarPane;

    ResearcherPanel(ScienceWindow scienceWindow) {
        this.scienceWindow = scienceWindow;
        this.setLayout(new CardLayout());
        JPanel blankPane = new JPanel();
        this.add((Component)blankPane, BLANK_PANE);
        JPanel researcherPane = new JPanel(new BorderLayout());
        researcherPane.setBorder(new MarsPanelBorder());
        this.add((Component)researcherPane, RESEARCHER_PANE);
        JPanel topPane = new JPanel(new GridLayout(2, 1, 0, 0));
        researcherPane.add((Component)topPane, "North");
        JPanel titlePane = new JPanel(new FlowLayout(0, 0, 0));
        topPane.add(titlePane);
        this.titleLabel = new JLabel(PRIMARY_RESEARCHER);
        titlePane.add(this.titleLabel);
        this.nameButton = new JButton("");
        this.nameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ResearcherPanel.this.researcher != null) {
                    ResearcherPanel.this.openResearcherWindow(ResearcherPanel.this.researcher);
                }
            }
        });
        titlePane.add(this.nameButton);
        this.scienceLabel = new JLabel("Scientific Field: ");
        topPane.add(this.scienceLabel);
        JPanel bottomPane = new JPanel(new BorderLayout());
        researcherPane.add((Component)bottomPane, "South");
        this.activityLabel = new JLabel("Study Activity: None     ");
        bottomPane.add((Component)this.activityLabel, "West");
        this.activityBarPane = new JPanel(new CardLayout());
        bottomPane.add((Component)this.activityBarPane, "Center");
        JPanel blankActivityBarPane = new JPanel();
        this.activityBarPane.add((Component)blankActivityBarPane, BLANK_ACTIVITY_BAR);
        this.activityBar = new JProgressBar(0, 100);
        this.activityBar.setStringPainted(true);
        this.activityBarPane.add((Component)this.activityBar, SHOW_ACTIVITY_BAR);
    }

    Person getStudyResearcher() {
        return this.researcher;
    }

    void setStudyResearcher(ScientificStudy study, Person researcher) {
        this.study = study;
        this.researcher = researcher;
        CardLayout cardLayout = (CardLayout)this.getLayout();
        if (study == null || researcher == null) {
            cardLayout.show(this, BLANK_PANE);
        } else {
            cardLayout.show(this, RESEARCHER_PANE);
            if (researcher.equals(study.getPrimaryResearcher())) {
                this.titleLabel.setText(PRIMARY_RESEARCHER);
                this.scienceLabel.setText("Scientific Field: " + study.getScience());
            } else {
                this.titleLabel.setText(COLLAB_RESEARCHER);
                Science collabScience = (Science)study.getCollaborativeResearchers().get(researcher);
                this.scienceLabel.setText("Scientific Field: " + collabScience.getName());
            }
            this.nameButton.setText(researcher.getName());
            this.update();
        }
    }

    void update() {
        this.activityLabel.setText(this.getStudyActivityText());
        this.setActivityProgressBar();
    }

    private void openResearcherWindow(Person researcher) {
        this.scienceWindow.openResearcherWindow(researcher);
    }

    private String getStudyActivityText() {
        String result = "Study Activity: None";
        if (this.study != null && this.researcher != null) {
            boolean isPrimaryResearcher = this.researcher.equals(this.study.getPrimaryResearcher());
            if (!this.study.isCompleted()) {
                String phase = this.study.getPhase();
                if ("Study Proposal".equals(phase)) {
                    if (isPrimaryResearcher) {
                        result = "Study Activity: Writing study proposal  ";
                    }
                } else if ("Collaborator Invitation".equals(phase)) {
                    if (isPrimaryResearcher) {
                        result = "Study Activity: Inviting collaborators";
                    }
                } else if ("Research".equals(phase)) {
                    result = "Study Activity: Performing study research  ";
                } else if ("Writing Paper".equals(phase)) {
                    result = "Study Activity: Compiling study results  ";
                } else if ("Peer Review".equals(phase) && isPrimaryResearcher) {
                    result = "Study Activity: Awaiting peer review  ";
                }
            } else {
                double achievement = 0.0;
                achievement = isPrimaryResearcher ? this.study.getPrimaryResearcherEarnedScientificAchievement() : this.study.getCollaborativeResearcherEarnedScientificAchievement(this.researcher);
                DecimalFormat formatter = new DecimalFormat("0.0");
                String achievementString = formatter.format(achievement);
                result = "Scientific Achievement: " + achievementString;
            }
        }
        return result;
    }

    private void setActivityProgressBar() {
        boolean showProgress = false;
        double workCompleted = 0.0;
        double workRequired = 0.0;
        if (this.study != null && this.researcher != null && !this.study.isCompleted()) {
            boolean isPrimaryResearcher = this.researcher.equals(this.study.getPrimaryResearcher());
            String phase = this.study.getPhase();
            if ("Study Proposal".equals(phase)) {
                if (isPrimaryResearcher) {
                    showProgress = true;
                    workCompleted = this.study.getProposalWorkTimeCompleted();
                    workRequired = this.study.getTotalProposalWorkTimeRequired();
                }
            } else if ("Research".equals(phase)) {
                showProgress = true;
                if (isPrimaryResearcher) {
                    workCompleted = this.study.getPrimaryResearchWorkTimeCompleted();
                    workRequired = this.study.getTotalPrimaryResearchWorkTimeRequired();
                } else {
                    workCompleted = this.study.getCollaborativeResearchWorkTimeCompleted(this.researcher);
                    workRequired = this.study.getTotalCollaborativeResearchWorkTimeRequired();
                }
            } else if ("Writing Paper".equals(phase)) {
                showProgress = true;
                if (isPrimaryResearcher) {
                    workCompleted = this.study.getPrimaryPaperWorkTimeCompleted();
                    workRequired = this.study.getTotalPrimaryPaperWorkTimeRequired();
                } else {
                    workCompleted = this.study.getCollaborativePaperWorkTimeCompleted(this.researcher);
                    workRequired = this.study.getTotalCollaborativePaperWorkTimeRequired();
                }
            } else if ("Peer Review".equals(phase) && isPrimaryResearcher) {
                showProgress = true;
                workCompleted = this.study.getPeerReviewTimeCompleted();
                workRequired = this.study.getTotalPeerReviewTimeRequired();
            }
        }
        if (showProgress) {
            int progressValue = 0;
            if (workRequired > 0.0) {
                progressValue = (int)(workCompleted / workRequired * 100.0);
            }
            this.activityBar.setValue(progressValue);
            ((CardLayout)this.activityBarPane.getLayout()).show(this.activityBarPane, SHOW_ACTIVITY_BAR);
        } else {
            ((CardLayout)this.activityBarPane.getLayout()).show(this.activityBarPane, BLANK_ACTIVITY_BAR);
        }
    }
}

