/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.science;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;
import org.mars_sim.msp.ui.swing.tool.science.FinishedStudyListPanel;
import org.mars_sim.msp.ui.swing.tool.science.OngoingStudyListPanel;
import org.mars_sim.msp.ui.swing.tool.science.StudyDetailPanel;

public class ScienceWindow
extends ToolWindow {
    public static final String NAME = "Science Tool";
    private OngoingStudyListPanel ongoingStudyListPane;
    private FinishedStudyListPanel finishedStudyListPane;
    private StudyDetailPanel studyDetailPane;
    private ScientificStudy selectedStudy = null;

    public ScienceWindow(MainDesktopPane desktop) {
        super(NAME, desktop);
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(mainPane);
        JPanel listsPane = new JPanel(new GridLayout(2, 1));
        mainPane.add((Component)listsPane, "West");
        this.ongoingStudyListPane = new OngoingStudyListPanel(this);
        listsPane.add(this.ongoingStudyListPane);
        this.finishedStudyListPane = new FinishedStudyListPanel(this);
        listsPane.add(this.finishedStudyListPane);
        this.studyDetailPane = new StudyDetailPanel(this);
        mainPane.add((Component)this.studyDetailPane, "Center");
        this.pack();
    }

    public void setScientificStudy(ScientificStudy study) {
        this.selectedStudy = study;
        this.studyDetailPane.displayScientificStudy(study);
        this.ongoingStudyListPane.selectScientificStudy(study, true);
        this.finishedStudyListPane.selectScientificStudy(study, true);
    }

    public ScientificStudy getScientificStudy() {
        return this.selectedStudy;
    }

    @Override
    public void update() {
        this.ongoingStudyListPane.update();
        this.finishedStudyListPane.update();
        this.studyDetailPane.update();
    }

    void openResearcherWindow(Person researcher) {
        this.desktop.openUnitWindow((Unit)researcher, false);
    }
}

