/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.UnitManagerEvent;
import org.mars_sim.msp.core.UnitManagerListener;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;

public class SearchWindow
extends ToolWindow {
    public static final String NAME = "Search Tool";
    public static final String PEOPLE = "People";
    public static final String SETTLEMENTS = "Settlements";
    public static final String VEHICLES = "Vehicles";
    private JComboBox searchForSelect;
    private JList unitList;
    private UnitListModel unitListModel;
    private JTextField selectTextField;
    private JLabel statusLabel;
    private JCheckBox openWindowCheck;
    private JCheckBox centerMapCheck;
    private boolean lockUnitList;
    private boolean lockSearchText;
    private String[] unitCategoryNames;

    public SearchWindow(MainDesktopPane desktop) {
        super(NAME, desktop);
        if (this.unitListModel != null) {
            UnitManager manager = Simulation.instance().getUnitManager();
            manager.removeUnitManagerListener((UnitManagerListener)this.unitListModel);
            this.unitListModel.clear();
            this.unitListModel = null;
        }
        this.lockUnitList = false;
        this.lockSearchText = false;
        this.unitCategoryNames = new String[3];
        this.unitCategoryNames[0] = PEOPLE;
        this.unitCategoryNames[1] = SETTLEMENTS;
        this.unitCategoryNames[2] = VEHICLES;
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(new MarsPanelBorder());
        this.setContentPane(mainPane);
        JPanel searchForPane = new JPanel(new FlowLayout(1));
        mainPane.add((Component)searchForPane, "North");
        JLabel searchForLabel = new JLabel("Search for: ");
        searchForPane.add(searchForLabel);
        String[] categoryStrings = new String[]{PEOPLE, SETTLEMENTS, VEHICLES};
        this.searchForSelect = new JComboBox<String>(categoryStrings);
        this.searchForSelect.setSelectedIndex(0);
        this.searchForSelect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                SearchWindow.this.changeCategory((String)SearchWindow.this.searchForSelect.getSelectedItem());
            }
        });
        searchForPane.add(this.searchForSelect);
        JPanel selectUnitPane = new JPanel(new BorderLayout());
        mainPane.add((Component)selectUnitPane, "Center");
        this.selectTextField = new JTextField();
        this.selectTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                SearchWindow.this.searchTextChange();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                SearchWindow.this.searchTextChange();
            }
        });
        selectUnitPane.add((Component)this.selectTextField, "North");
        this.unitListModel = new UnitListModel(PEOPLE);
        this.unitList = new JList(this.unitListModel);
        this.unitList.setSelectedIndex(0);
        this.unitList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    SearchWindow.this.search();
                } else if (!SearchWindow.this.lockUnitList) {
                    String selectedUnitName = ((Unit)SearchWindow.this.unitList.getSelectedValue()).getName();
                    SearchWindow.this.lockSearchText = true;
                    if (!SearchWindow.this.selectTextField.getText().equals(selectedUnitName)) {
                        SearchWindow.this.selectTextField.setText(selectedUnitName);
                    }
                    SearchWindow.this.lockSearchText = false;
                }
            }
        });
        selectUnitPane.add((Component)new JScrollPane(this.unitList), "Center");
        JPanel bottomPane = new JPanel(new BorderLayout());
        mainPane.add((Component)bottomPane, "South");
        JPanel selectOptionsPane = new JPanel(new GridLayout(2, 1));
        bottomPane.add((Component)selectOptionsPane, "North");
        this.openWindowCheck = new JCheckBox("Open Detail Window");
        this.openWindowCheck.setSelected(true);
        selectOptionsPane.add(this.openWindowCheck);
        this.centerMapCheck = new JCheckBox("Recenter Mars Navigator");
        selectOptionsPane.add(this.centerMapCheck);
        this.statusLabel = new JLabel(" ", 0);
        this.statusLabel.setBorder(new EtchedBorder());
        bottomPane.add((Component)this.statusLabel, "Center");
        JPanel searchButtonPane = new JPanel(new FlowLayout(1));
        bottomPane.add((Component)searchButtonPane, "South");
        JButton searchButton = new JButton("Search");
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchWindow.this.search();
            }
        });
        searchButtonPane.add(searchButton);
        this.pack();
    }

    private void search() {
        Collection units = null;
        String category = (String)this.searchForSelect.getSelectedItem();
        UnitManager unitManager = Simulation.instance().getUnitManager();
        if (category.equals(PEOPLE)) {
            Collection people = unitManager.getPeople();
            units = CollectionUtils.sortByName((Collection)people);
        } else if (category.equals(SETTLEMENTS)) {
            Collection settlement = unitManager.getSettlements();
            units = CollectionUtils.sortByName((Collection)settlement);
        } else if (category.equals(VEHICLES)) {
            Collection vehicle = unitManager.getVehicles();
            units = CollectionUtils.sortByName((Collection)vehicle);
        }
        Iterator unitI = units.iterator();
        boolean foundUnit = false;
        while (unitI.hasNext()) {
            Unit unit = (Unit)unitI.next();
            if (!this.selectTextField.getText().equalsIgnoreCase(unit.getName())) continue;
            foundUnit = true;
            if (this.openWindowCheck.isSelected()) {
                this.desktop.openUnitWindow(unit, false);
            }
            if (!this.centerMapCheck.isSelected()) continue;
            this.desktop.centerMapGlobe(unit.getCoordinates());
        }
        String tempName = this.unitCategoryNames[this.searchForSelect.getSelectedIndex()];
        if (!foundUnit) {
            this.statusLabel.setText(tempName + " Not Found");
        }
        if (this.selectTextField.getText().length() == 0) {
            this.statusLabel.setText("Enter The Name of a " + tempName);
        }
    }

    private void changeCategory(String category) {
        this.lockUnitList = true;
        this.unitListModel.updateCategory(category);
        this.unitList.setSelectedIndex(0);
        this.unitList.ensureIndexIsVisible(0);
        this.lockUnitList = false;
        this.statusLabel.setText(" ");
    }

    private void searchTextChange() {
        if (!this.lockSearchText) {
            String searchText = this.selectTextField.getText().toLowerCase();
            int fitIndex = 0;
            boolean goodFit = false;
            for (int x = this.unitListModel.size() - 1; x > -1; --x) {
                Unit unit = (Unit)this.unitListModel.elementAt(x);
                String unitString = unit.getName().toLowerCase();
                if (!unitString.startsWith(searchText)) continue;
                fitIndex = x;
                goodFit = true;
            }
            if (goodFit) {
                this.lockUnitList = true;
                this.unitList.setSelectedIndex(fitIndex);
                this.unitList.ensureIndexIsVisible(fitIndex);
                this.lockUnitList = false;
            }
        }
        this.statusLabel.setText(" ");
    }

    @Override
    public void destroy() {
    }

    private class UnitListModel
    extends DefaultListModel
    implements UnitManagerListener {
        private String category;

        public UnitListModel(String initialCategory) {
            this.category = initialCategory;
            this.updateList();
            Simulation.instance().getUnitManager().addUnitManagerListener((UnitManagerListener)this);
        }

        private void updateCategory(String category) {
            if (!this.category.equals(category)) {
                this.category = category;
                this.updateList();
            }
        }

        private void updateList() {
            this.clear();
            Collection units = null;
            UnitManager unitManager = Simulation.instance().getUnitManager();
            if (this.category.equals(SearchWindow.PEOPLE)) {
                Collection people = unitManager.getPeople();
                units = CollectionUtils.sortByName((Collection)people);
            } else if (this.category.equals(SearchWindow.SETTLEMENTS)) {
                Collection settlement = unitManager.getSettlements();
                units = CollectionUtils.sortByName((Collection)settlement);
            } else if (this.category.equals(SearchWindow.VEHICLES)) {
                Collection vehicle = unitManager.getVehicles();
                units = CollectionUtils.sortByName((Collection)vehicle);
            }
            Iterator unitI = units.iterator();
            while (unitI.hasNext()) {
                this.addElement(unitI.next());
            }
        }

        public void unitManagerUpdate(UnitManagerEvent event) {
            int index;
            Unit selectedUnit = (Unit)SearchWindow.this.unitList.getSelectedValue();
            SearchWindow.this.lockUnitList = true;
            this.updateList();
            if (selectedUnit != null && (index = this.indexOf(selectedUnit)) >= 0) {
                SearchWindow.this.unitList.setSelectedIndex(index);
                SearchWindow.this.unitList.ensureIndexIsVisible(index);
            }
            SearchWindow.this.lockUnitList = false;
        }
    }
}

