/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.settlement;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapPanel;

public class BackgroundTileMapLayer
implements SettlementMapLayer {
    private static final int MAX_BACKGROUND_IMAGE_NUM = 20;
    private static final int MAX_BACKGROUND_DIMENSION = 1600;
    private Map<Settlement, String> settlementBackgroundMap;
    private Image backgroundTileImage;
    private Settlement currentSettlement;
    private double currentScale;
    private SettlementMapPanel mapPanel;

    public BackgroundTileMapLayer(SettlementMapPanel mapPanel) {
        this.mapPanel = mapPanel;
        this.settlementBackgroundMap = new HashMap<Settlement, String>(20);
    }

    @Override
    public void displayLayer(Graphics2D g2d, Settlement settlement, double xPos, double yPos, int mapWidth, int mapHeight, double rotation, double scale) {
        AffineTransform saveTransform = g2d.getTransform();
        if (!settlement.equals(this.currentSettlement)) {
            this.backgroundTileImage = null;
            this.currentSettlement = settlement;
        }
        if (scale != this.currentScale) {
            this.backgroundTileImage = null;
            this.currentScale = scale;
        }
        g2d.rotate(rotation, (double)mapWidth / 2.0, (double)mapHeight / 2.0);
        double diagonal = Math.hypot(mapWidth, mapHeight);
        if (this.backgroundTileImage == null) {
            ImageIcon backgroundTileIcon = this.getBackgroundImage(settlement);
            double imageScale = scale / 5.0;
            int imageWidth = (int)((double)backgroundTileIcon.getIconWidth() * imageScale);
            int imageHeight = (int)((double)backgroundTileIcon.getIconHeight() * imageScale);
            this.backgroundTileImage = this.resizeImage(backgroundTileIcon.getImage(), backgroundTileIcon.getImageObserver(), imageWidth, imageHeight);
        }
        if (this.backgroundTileImage != null) {
            int tileCenterOffsetX;
            int offsetX = (int)(xPos * scale);
            int tileWidth = this.backgroundTileImage.getWidth(this.mapPanel);
            int bufferX = (int)diagonal - mapWidth;
            int startX = tileCenterOffsetX = mapWidth / 2 % tileWidth - (int)(1.5f * (float)tileWidth);
            while (startX + offsetX > 0 - bufferX) {
                startX -= tileWidth;
            }
            while (startX + offsetX < 0 - tileWidth - bufferX) {
                startX += tileWidth;
            }
            int endX = mapWidth;
            while (endX + offsetX < mapWidth + bufferX) {
                endX += tileWidth;
            }
            while (endX + offsetX > mapWidth + tileWidth + bufferX) {
                endX -= tileWidth;
            }
            for (int x = startX; x < endX; x += tileWidth) {
                int tileCenterOffsetY;
                int offsetY = (int)(yPos * scale);
                int tileHeight = this.backgroundTileImage.getHeight(this.mapPanel);
                int bufferY = (int)diagonal - mapHeight;
                int startY = tileCenterOffsetY = mapHeight / 2 % tileHeight - (int)(1.5f * (float)tileHeight);
                while (startY + offsetY > 0 - bufferY) {
                    startY -= tileHeight;
                }
                while (startY + offsetY < 0 - tileHeight - bufferY) {
                    startY += tileHeight;
                }
                int endY = mapHeight;
                while (endY + offsetY < mapHeight + bufferY) {
                    endY += tileHeight;
                }
                while (endY + offsetY > mapHeight + tileHeight + bufferY) {
                    endY -= tileHeight;
                }
                for (int y = startY; y < endY; y += tileHeight) {
                    g2d.drawImage(this.backgroundTileImage, x + offsetX, y + offsetY, this.mapPanel);
                }
            }
        }
        g2d.setTransform(saveTransform);
    }

    private Image resizeImage(Image image, ImageObserver observer, int width, int height) {
        Image result = image;
        int w = image.getWidth(observer);
        int h = image.getHeight(observer);
        do {
            if (w > width) {
                if ((w /= 2) < width) {
                    w = width;
                }
            } else if (w < width) {
                w = width;
            }
            if (h > height) {
                if ((h /= 2) < height) {
                    h = height;
                }
            } else if (h < height) {
                h = height;
            }
            int bufferWidth = w;
            int bufferHeight = h;
            int xOffset = 0;
            int yOffset = 0;
            if (w > 1600 || h > 1600) {
                float reductionW = 1600.0f / (float)w;
                float reductionH = 1600.0f / (float)h;
                float reduction = reductionW;
                if (reductionH < reductionW) {
                    reduction = reductionH;
                }
                bufferWidth = (int)((float)w * reduction);
                bufferHeight = (int)((float)h * reduction);
                xOffset = (w - bufferWidth) / -2;
                yOffset = (h - bufferHeight) / -2;
            }
            BufferedImage tmpImage = new BufferedImage(bufferWidth, bufferHeight, 2);
            Graphics2D g2d = (Graphics2D)tmpImage.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setClip(0, 0, bufferWidth, bufferHeight);
            g2d.drawImage(result, xOffset, yOffset, w, h, null);
            g2d.dispose();
            result = tmpImage;
        } while (w != width || h != height);
        return result;
    }

    private ImageIcon getBackgroundImage(Settlement settlement) {
        ImageIcon result = null;
        if (this.settlementBackgroundMap.containsKey(settlement)) {
            String backgroundImageName = this.settlementBackgroundMap.get(settlement);
            result = ImageLoader.getIcon(backgroundImageName, "jpg");
        } else {
            int count = 1;
            Iterator i = Simulation.instance().getUnitManager().getSettlements().iterator();
            while (i.hasNext()) {
                if (((Settlement)i.next()).equals(settlement)) {
                    String backgroundImageName = "settlement_map_tile" + count;
                    this.settlementBackgroundMap.put(settlement, backgroundImageName);
                    result = ImageLoader.getIcon(backgroundImageName, "jpg");
                }
                if (++count <= 20) continue;
                count = 1;
            }
        }
        return result;
    }

    @Override
    public void destroy() {
    }
}

