/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.settlement;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.tool.settlement.PersonMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapPanel;

public class LabelMapLayer
implements SettlementMapLayer {
    private static final Color BUILDING_LABEL_COLOR = new Color(0, 0, 255);
    private static final Color BUILDING_LABEL_OUTLINE_COLOR = new Color(255, 255, 255, 190);
    private static final Color CONSTRUCTION_SITE_LABEL_COLOR = new Color(0, 0, 255);
    private static final Color CONSTRUCTION_SITE_LABEL_OUTLINE_COLOR = new Color(255, 255, 255, 190);
    private static final Color VEHICLE_LABEL_COLOR = new Color(127, 0, 127);
    private static final Color VEHICLE_LABEL_OUTLINE_COLOR = new Color(255, 255, 255, 190);
    private static final Color PERSON_LABEL_COLOR = new Color(0, 255, 255);
    private static final Color PERSON_LABEL_OUTLINE_COLOR = new Color(0, 0, 0, 190);
    private static final Color SELECTED_LABEL_COLOR = new Color(255, 255, 255);
    private static final Color SELECTED_LABEL_OUTLINE_COLOR = new Color(0, 0, 0, 190);
    private SettlementMapPanel mapPanel;
    private Map<String, BufferedImage> labelImageCache;

    public LabelMapLayer(SettlementMapPanel mapPanel) {
        this.mapPanel = mapPanel;
        this.labelImageCache = new HashMap<String, BufferedImage>(30);
    }

    @Override
    public void displayLayer(Graphics2D g2d, Settlement settlement, double xPos, double yPos, int mapWidth, int mapHeight, double rotation, double scale) {
        AffineTransform saveTransform = g2d.getTransform();
        double mapCenterX = (double)mapWidth / 2.0;
        double mapCenterY = (double)mapHeight / 2.0;
        g2d.translate(mapCenterX + xPos * scale, mapCenterY + yPos * scale);
        g2d.rotate(rotation, 0.0 - xPos * scale, 0.0 - yPos * scale);
        if (this.mapPanel.isShowBuildingLabels()) {
            this.drawBuildingLabels(g2d, settlement);
        }
        if (this.mapPanel.isShowConstructionLabels()) {
            this.drawConstructionSiteLabels(g2d, settlement);
        }
        if (this.mapPanel.isShowVehicleLabels()) {
            this.drawVehicleLabels(g2d, settlement);
        }
        if (this.mapPanel.isShowPersonLabels()) {
            this.drawPersonLabels(g2d, settlement);
        }
        g2d.setTransform(saveTransform);
    }

    private void drawBuildingLabels(Graphics2D g2d, Settlement settlement) {
        if (settlement != null) {
            for (Building building : settlement.getBuildingManager().getBuildings()) {
                this.drawLabel(g2d, building.getName(), building.getXLocation(), building.getYLocation(), BUILDING_LABEL_COLOR, BUILDING_LABEL_OUTLINE_COLOR);
            }
        }
    }

    private void drawConstructionSiteLabels(Graphics2D g2d, Settlement settlement) {
        if (settlement != null) {
            for (ConstructionSite site : settlement.getConstructionManager().getConstructionSites()) {
                String siteLabel = LabelMapLayer.getConstructionLabel(site);
                this.drawLabel(g2d, siteLabel, site.getXLocation(), site.getYLocation(), CONSTRUCTION_SITE_LABEL_COLOR, CONSTRUCTION_SITE_LABEL_OUTLINE_COLOR);
            }
        }
    }

    public static String getConstructionLabel(ConstructionSite site) {
        String label = "";
        ConstructionStage stage = site.getCurrentConstructionStage();
        label = stage != null ? (site.isUndergoingConstruction() ? "Constructing " + stage.getInfo().getName() : (site.isUndergoingSalvage() ? "Salvaging " + stage.getInfo().getName() : (site.hasUnfinishedStage() ? (stage.isSalvaging() ? "Salvaging " + stage.getInfo().getName() + " unfinished" : "Constructing " + stage.getInfo().getName() + " unfinished") : stage.getInfo().getName() + " completed"))) : "No construction";
        return label;
    }

    private void drawVehicleLabels(Graphics2D g2d, Settlement settlement) {
        if (settlement != null) {
            for (Vehicle vehicle : Simulation.instance().getUnitManager().getVehicles()) {
                Coordinates settlementLoc = settlement.getCoordinates();
                Coordinates vehicleLoc = vehicle.getCoordinates();
                if (!vehicleLoc.equals((Object)settlementLoc)) continue;
                this.drawLabel(g2d, vehicle.getName(), vehicle.getXLocation(), vehicle.getYLocation(), VEHICLE_LABEL_COLOR, VEHICLE_LABEL_OUTLINE_COLOR);
            }
        }
    }

    private void drawPersonLabels(Graphics2D g2d, Settlement settlement) {
        List<Person> people = PersonMapLayer.getPeopleToDisplay(settlement);
        Person selectedPerson = this.mapPanel.getSelectedPerson();
        int offset = 8;
        for (Person person : people) {
            if (person.equals(selectedPerson)) continue;
            this.drawLabelRight(g2d, person.getName(), person.getXLocation(), person.getYLocation(), PERSON_LABEL_COLOR, PERSON_LABEL_OUTLINE_COLOR, offset, 0);
        }
        if (people.contains(selectedPerson)) {
            this.drawLabelRight(g2d, selectedPerson.getName(), selectedPerson.getXLocation(), selectedPerson.getYLocation(), SELECTED_LABEL_COLOR, SELECTED_LABEL_OUTLINE_COLOR, offset, 0);
            String taskString = "Activity: " + selectedPerson.getMind().getTaskManager().getTaskDescription();
            this.drawLabelRight(g2d, taskString, selectedPerson.getXLocation(), selectedPerson.getYLocation(), SELECTED_LABEL_COLOR, SELECTED_LABEL_OUTLINE_COLOR, offset, 12);
            Mission mission = selectedPerson.getMind().getMission();
            if (mission != null) {
                String missionString = "Mission: " + mission.getDescription() + " - " + mission.getPhaseDescription();
                this.drawLabelRight(g2d, missionString, selectedPerson.getXLocation(), selectedPerson.getYLocation(), SELECTED_LABEL_COLOR, SELECTED_LABEL_OUTLINE_COLOR, offset, 24);
            }
        }
    }

    private void drawLabel(Graphics2D g2d, String label, double xLoc, double yLoc, Color labelColor, Color labelOutlineColor) {
        AffineTransform saveTransform = g2d.getTransform();
        Font saveFont = g2d.getFont();
        Font font = g2d.getFont().deriveFont(1, 12.0f);
        g2d.setFont(font);
        BufferedImage labelImage = this.getLabelImage(label, font, g2d.getFontRenderContext(), labelColor, labelOutlineColor);
        double centerX = (double)labelImage.getWidth() / 2.0;
        double centerY = (double)labelImage.getHeight() / 2.0;
        double translationX = -1.0 * xLoc * this.mapPanel.getScale() - centerX;
        double translationY = -1.0 * yLoc * this.mapPanel.getScale() - centerY;
        AffineTransform newTransform = new AffineTransform(saveTransform);
        newTransform.translate(translationX, translationY);
        newTransform.rotate(this.mapPanel.getRotation() * -1.0, centerX, centerY);
        g2d.setTransform(newTransform);
        g2d.drawImage((Image)labelImage, 0, 0, this.mapPanel);
        g2d.setTransform(saveTransform);
        g2d.setFont(saveFont);
    }

    private void drawLabelRight(Graphics2D g2d, String label, double xLoc, double yLoc, Color labelColor, Color labelOutlineColor, int xOffset, int yOffset) {
        AffineTransform saveTransform = g2d.getTransform();
        Font saveFont = g2d.getFont();
        Font font = g2d.getFont().deriveFont(1, 12.0f);
        g2d.setFont(font);
        BufferedImage labelImage = this.getLabelImage(label, font, g2d.getFontRenderContext(), labelColor, labelOutlineColor);
        double centerX = (double)labelImage.getWidth() / 2.0;
        double centerY = (double)labelImage.getHeight() / 2.0;
        double translationX = -1.0 * xLoc * this.mapPanel.getScale() - centerX;
        double translationY = -1.0 * yLoc * this.mapPanel.getScale() - centerY;
        AffineTransform newTransform = new AffineTransform(saveTransform);
        newTransform.translate(translationX, translationY);
        newTransform.rotate(this.mapPanel.getRotation() * -1.0, centerX, centerY);
        g2d.setTransform(newTransform);
        int totalRightOffset = labelImage.getWidth() / 2 + xOffset;
        g2d.drawImage((Image)labelImage, totalRightOffset, yOffset, this.mapPanel);
        g2d.setTransform(saveTransform);
        g2d.setFont(saveFont);
    }

    private BufferedImage getLabelImage(String label, Font font, FontRenderContext fontRenderContext, Color labelColor, Color labelOutlineColor) {
        BufferedImage labelImage = null;
        String labelId = label + font.toString() + labelColor.toString() + labelOutlineColor.toString();
        if (this.labelImageCache.containsKey(labelId)) {
            labelImage = this.labelImageCache.get(labelId);
        } else {
            labelImage = this.createLabelImage(label, font, fontRenderContext, labelColor, labelOutlineColor);
            this.labelImageCache.put(labelId, labelImage);
        }
        return labelImage;
    }

    private BufferedImage createLabelImage(String label, Font font, FontRenderContext fontRenderContext, Color labelColor, Color labelOutlineColor) {
        TextLayout textLayout1 = new TextLayout(label, font, fontRenderContext);
        Rectangle2D bounds1 = textLayout1.getBounds();
        Shape labelShape = textLayout1.getOutline(null);
        int width = (int)(bounds1.getWidth() + bounds1.getX()) + 4;
        int height = (int)bounds1.getHeight() + 4;
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(2.0 - bounds1.getX(), 2.0 - bounds1.getY());
        Stroke saveStroke = g2d.getStroke();
        g2d.setColor(labelOutlineColor);
        g2d.setStroke(new BasicStroke(2.0f, 1, 1));
        g2d.draw(labelShape);
        g2d.setStroke(saveStroke);
        g2d.setColor(labelColor);
        g2d.fill(labelShape);
        g2d.dispose();
        return bufferedImage;
    }

    @Override
    public void destroy() {
        this.labelImageCache.clear();
    }
}

