/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.settlement;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapPanel;

public class PersonMapLayer
implements SettlementMapLayer {
    private static final Color PERSON_COLOR = new Color(0, 255, 255);
    private static final Color PERSON_OUTLINE_COLOR = new Color(0, 0, 0, 190);
    private static final Color SELECTED_COLOR = new Color(255, 255, 255);
    private static final Color SELECTED_OUTLINE_COLOR = new Color(0, 0, 0, 190);
    private SettlementMapPanel mapPanel;

    public static List<Person> getPeopleToDisplay(Settlement settlement) {
        ArrayList<Person> result = new ArrayList<Person>();
        if (settlement != null) {
            for (Person person : Simulation.instance().getUnitManager().getPeople()) {
                if (person.getPhysicalCondition().isDead()) continue;
                Coordinates settlementLoc = settlement.getCoordinates();
                Coordinates personLoc = person.getCoordinates();
                if (!personLoc.equals((Object)settlementLoc)) continue;
                result.add(person);
            }
        }
        return result;
    }

    public PersonMapLayer(SettlementMapPanel mapPanel) {
        this.mapPanel = mapPanel;
    }

    @Override
    public void displayLayer(Graphics2D g2d, Settlement settlement, double xPos, double yPos, int mapWidth, int mapHeight, double rotation, double scale) {
        AffineTransform saveTransform = g2d.getTransform();
        double mapCenterX = (double)mapWidth / 2.0;
        double mapCenterY = (double)mapHeight / 2.0;
        g2d.translate(mapCenterX + xPos * scale, mapCenterY + yPos * scale);
        g2d.rotate(rotation, 0.0 - xPos * scale, 0.0 - yPos * scale);
        this.drawPeople(g2d, settlement);
        g2d.setTransform(saveTransform);
    }

    private void drawPeople(Graphics2D g2d, Settlement settlement) {
        List<Person> people = PersonMapLayer.getPeopleToDisplay(settlement);
        Person selectedPerson = this.mapPanel.getSelectedPerson();
        for (Person person : people) {
            if (person.equals(selectedPerson)) continue;
            this.drawPerson(g2d, person, PERSON_COLOR, PERSON_OUTLINE_COLOR);
        }
        if (people.contains(selectedPerson)) {
            this.drawPerson(g2d, selectedPerson, SELECTED_COLOR, SELECTED_OUTLINE_COLOR);
        }
    }

    private void drawPerson(Graphics2D g2d, Person person, Color iconColor, Color outlineColor) {
        if (person != null) {
            AffineTransform saveTransform = g2d.getTransform();
            double circleDiameter = 10.0;
            double centerX = circleDiameter / 2.0;
            double centerY = circleDiameter / 2.0;
            double translationX = -1.0 * person.getXLocation() * this.mapPanel.getScale() - centerX;
            double translationY = -1.0 * person.getYLocation() * this.mapPanel.getScale() - centerY;
            AffineTransform newTransform = new AffineTransform(saveTransform);
            newTransform.translate(translationX, translationY);
            newTransform.rotate(this.mapPanel.getRotation() * -1.0, centerX, centerY);
            g2d.setTransform(newTransform);
            g2d.setColor(outlineColor);
            g2d.fillOval(0, 0, 11, 11);
            g2d.setColor(iconColor);
            g2d.fillOval(0, 0, 10, 10);
            g2d.setTransform(saveTransform);
        }
    }

    @Override
    public void destroy() {
    }
}

