/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.settlement;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.batik.gvt.GraphicsNode;
import org.mars_sim.msp.ui.swing.SVGLoader;

public final class SVGMapUtil {
    private static Properties svgMapProperties;

    private SVGMapUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSVGImageMappingPropertiesFile() {
        svgMapProperties = new Properties();
        String fileName = "/svg/svg_image_mapping.properties";
        URL resource = SVGLoader.class.getResource(fileName);
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            svgMapProperties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private static GraphicsNode getSVGGraphicsNode(String prefix, String name) {
        String propertyName;
        String svgFileName;
        GraphicsNode result = null;
        if (svgMapProperties == null) {
            SVGMapUtil.loadSVGImageMappingPropertiesFile();
        }
        StringBuffer propertyNameBuff = new StringBuffer("");
        if (prefix != null) {
            propertyNameBuff.append(prefix);
            propertyNameBuff.append(".");
        }
        if (name != null) {
            String prepName = name.trim().toLowerCase();
            propertyNameBuff.append(prepName);
        }
        if ((svgFileName = svgMapProperties.getProperty(propertyName = propertyNameBuff.toString())) != null) {
            result = SVGLoader.getSVGImage(svgFileName);
        }
        return result;
    }

    public static GraphicsNode getBuildingSVG(String buildingName) {
        return SVGMapUtil.getSVGGraphicsNode("building", buildingName);
    }

    public static GraphicsNode getConstructionSiteSVG(String constructionSiteStageName) {
        return SVGMapUtil.getSVGGraphicsNode("construction_stage", constructionSiteStageName);
    }

    public static GraphicsNode getVehicleSVG(String vehicleType) {
        return SVGMapUtil.getSVGGraphicsNode("vehicle", vehicleType);
    }

    public static GraphicsNode getMaintenanceOverlaySVG(String vehicleType) {
        return SVGMapUtil.getSVGGraphicsNode("vehicle.maintenance", vehicleType);
    }

    public static GraphicsNode getLoadingOverlaySVG(String vehicleType) {
        return SVGMapUtil.getSVGGraphicsNode("vehicle.loading", vehicleType);
    }

    public static GraphicsNode getAttachmentPartSVG(String partType) {
        return SVGMapUtil.getSVGGraphicsNode("vehicle.attachment_part", partType);
    }
}

