/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.settlement;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.gvt.GraphicsNode;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.LoadVehicleGarage;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleEVA;
import org.mars_sim.msp.core.person.ai.task.UnloadVehicleGarage;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.tool.settlement.SVGMapUtil;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapLayer;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementMapPanel;

public class VehicleMapLayer
implements SettlementMapLayer {
    private static final Color VEHICLE_COLOR = Color.RED;
    private SettlementMapPanel mapPanel;
    private Map<Double, Map<GraphicsNode, BufferedImage>> svgImageCache;
    private double scale;

    public VehicleMapLayer(SettlementMapPanel mapPanel) {
        this.mapPanel = mapPanel;
        this.svgImageCache = new HashMap<Double, Map<GraphicsNode, BufferedImage>>(21);
        System.setProperty("org.apache.batik.warn_destination", "false");
    }

    @Override
    public void displayLayer(Graphics2D g2d, Settlement settlement, double xPos, double yPos, int mapWidth, int mapHeight, double rotation, double scale) {
        this.scale = scale;
        AffineTransform saveTransform = g2d.getTransform();
        double mapCenterX = (double)mapWidth / 2.0;
        double mapCenterY = (double)mapHeight / 2.0;
        g2d.translate(mapCenterX + xPos * scale, mapCenterY + yPos * scale);
        g2d.rotate(rotation, 0.0 - xPos * scale, 0.0 - yPos * scale);
        this.drawVehicles(g2d, settlement);
        g2d.setTransform(saveTransform);
    }

    private void drawVehicles(Graphics2D g2d, Settlement settlement) {
        if (settlement != null) {
            for (Vehicle vehicle : Simulation.instance().getUnitManager().getVehicles()) {
                Coordinates settlementLoc = settlement.getCoordinates();
                Coordinates vehicleLoc = vehicle.getCoordinates();
                if (!vehicleLoc.equals((Object)settlementLoc)) continue;
                this.drawVehicle(vehicle, g2d);
            }
        }
    }

    private void drawVehicle(Vehicle vehicle, Graphics2D g2d) {
        GraphicsNode svg = SVGMapUtil.getVehicleSVG(vehicle.getDescription().toLowerCase());
        if (svg != null) {
            this.drawSVGVehicle(g2d, vehicle.getXLocation(), vehicle.getYLocation(), vehicle.getWidth(), vehicle.getLength(), vehicle.getFacing(), svg);
            if (this.isVehicleRepairOrMaintenance(vehicle)) {
                this.drawSVGRepairMaint(g2d, vehicle);
            }
            if (this.isVehicleLoading(vehicle)) {
                this.drawSVGLoading(g2d, vehicle);
            }
            if (vehicle instanceof LightUtilityVehicle) {
                this.drawSVGPartAttachments(g2d, (LightUtilityVehicle)vehicle);
            }
        } else {
            this.drawRectangleVehicle(g2d, vehicle.getXLocation(), vehicle.getYLocation(), vehicle.getWidth(), vehicle.getLength(), vehicle.getFacing(), VEHICLE_COLOR);
        }
    }

    private boolean isVehicleRepairOrMaintenance(Vehicle vehicle) {
        boolean result = false;
        if (vehicle.isReservedForMaintenance()) {
            result = true;
        }
        if (vehicle.getMalfunctionManager().hasMalfunction()) {
            result = true;
        }
        return result;
    }

    private void drawSVGRepairMaint(Graphics2D g2d, Vehicle vehicle) {
        GraphicsNode maintOverlaySvg = SVGMapUtil.getMaintenanceOverlaySVG(vehicle.getDescription().toLowerCase());
        GraphicsNode vehicleSvg = SVGMapUtil.getVehicleSVG(vehicle.getDescription().toLowerCase());
        if (maintOverlaySvg != null && vehicleSvg != null) {
            this.drawVehicleOverlay(g2d, vehicle.getXLocation(), vehicle.getYLocation(), vehicle.getWidth(), vehicle.getLength(), vehicle.getFacing(), vehicleSvg, maintOverlaySvg);
        }
    }

    private boolean isVehicleLoading(Vehicle vehicle) {
        boolean result = false;
        Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle(vehicle);
        if (mission != null && mission instanceof VehicleMission) {
            VehicleMission vehicleMission = (VehicleMission)mission;
            String missionPhase = vehicleMission.getPhase();
            if (("Embarking".equals(missionPhase) || "Load Goods".equals(missionPhase)) && !mission.getPhaseEnded()) {
                result = true;
            } else if ("Disembarking".equals(missionPhase) || "Unload Goods".equals(missionPhase)) {
                result = true;
            }
        }
        if (!result) {
            for (Person person : Simulation.instance().getUnitManager().getPeople()) {
                Task task;
                if (person.getPhysicalCondition().isDead() || (task = person.getMind().getTaskManager().getTask()) == null) continue;
                if (task instanceof LoadVehicleGarage) {
                    if (!vehicle.equals(((LoadVehicleGarage)task).getVehicle())) continue;
                    result = true;
                    continue;
                }
                if (task instanceof LoadVehicleEVA) {
                    if (!vehicle.equals(((LoadVehicleEVA)task).getVehicle())) continue;
                    result = true;
                    continue;
                }
                if (task instanceof UnloadVehicleGarage) {
                    if (!vehicle.equals(((UnloadVehicleGarage)task).getVehicle())) continue;
                    result = true;
                    continue;
                }
                if (!(task instanceof UnloadVehicleEVA) || !vehicle.equals(((UnloadVehicleEVA)task).getVehicle())) continue;
                result = true;
            }
        }
        return result;
    }

    private void drawSVGLoading(Graphics2D g2d, Vehicle vehicle) {
        GraphicsNode loadOverlaySvg = SVGMapUtil.getLoadingOverlaySVG(vehicle.getDescription().toLowerCase());
        GraphicsNode vehicleSvg = SVGMapUtil.getVehicleSVG(vehicle.getDescription().toLowerCase());
        if (loadOverlaySvg != null && vehicleSvg != null) {
            this.drawVehicleOverlay(g2d, vehicle.getXLocation(), vehicle.getYLocation(), vehicle.getWidth(), vehicle.getLength(), vehicle.getFacing(), vehicleSvg, loadOverlaySvg);
        }
    }

    private void drawSVGVehicle(Graphics2D g2d, double xLoc, double yLoc, double width, double length, double facing, GraphicsNode svg) {
        this.drawVehicle(true, g2d, xLoc, yLoc, width, length, facing, svg, null);
    }

    private void drawRectangleVehicle(Graphics2D g2d, double xLoc, double yLoc, double width, double length, double facing, Color color) {
        this.drawVehicle(false, g2d, xLoc, yLoc, width, length, facing, null, color);
    }

    private void drawVehicle(boolean isSVG, Graphics2D g2d, double xLoc, double yLoc, double width, double length, double facing, GraphicsNode svg, Color color) {
        AffineTransform saveTransform = g2d.getTransform();
        Rectangle2D bounds = null;
        bounds = isSVG ? svg.getBounds() : new Rectangle2D.Double(0.0, 0.0, width, length);
        double scalingWidth = width / bounds.getWidth() * this.scale;
        double scalingLength = length / bounds.getHeight() * this.scale;
        double boundsPosX = bounds.getX() * scalingWidth;
        double boundsPosY = bounds.getY() * scalingLength;
        double centerX = width * this.scale / 2.0;
        double centerY = length * this.scale / 2.0;
        double translationX = -1.0 * xLoc * this.scale - centerX - boundsPosX;
        double translationY = -1.0 * yLoc * this.scale - centerY - boundsPosY;
        double facingRadian = facing / 180.0 * Math.PI;
        AffineTransform newTransform = new AffineTransform();
        newTransform.translate(translationX, translationY);
        newTransform.rotate(facingRadian, centerX + boundsPosX, centerY + boundsPosY);
        if (isSVG) {
            BufferedImage image = this.getBufferedImage(svg, width, length);
            if (image != null) {
                g2d.transform(newTransform);
                g2d.drawImage((Image)image, 0, 0, this.mapPanel);
            }
        } else {
            newTransform.scale(scalingWidth, scalingLength);
            g2d.transform(newTransform);
            g2d.setColor(color);
            g2d.fill(bounds);
        }
        g2d.setTransform(saveTransform);
    }

    private void drawSVGPartAttachments(Graphics2D g2d, LightUtilityVehicle vehicle) {
        for (Part part : vehicle.getPossibleAttachmentParts()) {
            if (vehicle.getInventory().getItemResourceNum((ItemResource)part) <= 0) continue;
            GraphicsNode partSvg = SVGMapUtil.getAttachmentPartSVG(part.getName().toLowerCase());
            GraphicsNode vehicleSvg = SVGMapUtil.getVehicleSVG(vehicle.getDescription().toLowerCase());
            if (partSvg == null || vehicleSvg == null) continue;
            this.drawVehicleOverlay(g2d, vehicle.getXLocation(), vehicle.getYLocation(), vehicle.getWidth(), vehicle.getLength(), vehicle.getFacing(), vehicleSvg, partSvg);
        }
    }

    private void drawVehicleOverlay(Graphics2D g2d, double xLoc, double yLoc, double vehicleWidth, double vehicleLength, double facing, GraphicsNode vehicleSvg, GraphicsNode overlaySvg) {
        AffineTransform saveTransform = g2d.getTransform();
        Rectangle2D partBounds = overlaySvg.getBounds();
        Rectangle2D vehicleBounds = vehicleSvg.getBounds();
        double partWidth = partBounds.getWidth() / vehicleBounds.getWidth() * vehicleWidth;
        double partLength = partBounds.getHeight() / vehicleBounds.getHeight() * vehicleLength;
        double scalingWidth = partWidth / partBounds.getWidth() * this.scale;
        double scalingLength = partLength / partBounds.getHeight() * this.scale;
        double boundsPosX = partBounds.getX() * scalingWidth;
        double boundsPosY = partBounds.getY() * scalingLength;
        double centerX = partWidth * this.scale / 2.0;
        double centerY = partLength * this.scale / 2.0;
        double translationX = -1.0 * xLoc * this.scale - centerX - boundsPosX;
        double translationY = -1.0 * yLoc * this.scale - centerY - boundsPosY;
        double facingRadian = facing / 180.0 * Math.PI;
        AffineTransform newTransform = new AffineTransform();
        newTransform.translate(translationX, translationY);
        newTransform.rotate(facingRadian, centerX + boundsPosX, centerY + boundsPosY);
        BufferedImage image = this.getBufferedImage(overlaySvg, partWidth, partLength);
        if (image != null) {
            g2d.transform(newTransform);
            g2d.drawImage((Image)image, 0, 0, this.mapPanel);
        }
        g2d.setTransform(saveTransform);
    }

    private BufferedImage getBufferedImage(GraphicsNode svg, double width, double length) {
        Map<Object, Object> imageCache = null;
        if (this.svgImageCache.containsKey(this.scale)) {
            imageCache = this.svgImageCache.get(this.scale);
        } else {
            imageCache = new HashMap(100);
            this.svgImageCache.put(this.scale, imageCache);
        }
        BufferedImage image = null;
        if (imageCache.containsKey(svg)) {
            image = (BufferedImage)imageCache.get(svg);
        } else {
            image = this.createBufferedImage(svg, width, length);
            imageCache.put(svg, image);
        }
        return image;
    }

    private BufferedImage createBufferedImage(GraphicsNode svg, double width, double length) {
        int imageLength;
        int imageWidth = (int)(width * this.scale);
        if (imageWidth <= 0) {
            imageWidth = 1;
        }
        if ((imageLength = (int)(length * this.scale)) <= 0) {
            imageLength = 1;
        }
        BufferedImage bufferedImage = new BufferedImage(imageWidth, imageLength, 2);
        Rectangle2D bounds = svg.getBounds();
        double scalingWidth = width / bounds.getWidth() * this.scale;
        double scalingLength = length / bounds.getHeight() * this.scale;
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        svg.setTransform(AffineTransform.getScaleInstance(scalingWidth, scalingLength));
        svg.paint(g2d);
        g2d.dispose();
        return bufferedImage;
    }

    @Override
    public void destroy() {
        Iterator<Map<GraphicsNode, BufferedImage>> i = this.svgImageCache.values().iterator();
        while (i.hasNext()) {
            i.next().clear();
        }
        this.svgImageCache.clear();
    }
}

