/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.time;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.mars_sim.msp.core.time.MarsClock;

class MarsCalendarDisplay
extends JComponent {
    private MarsClock marsTime;
    private int solOfMonthCache;

    public MarsCalendarDisplay(MarsClock marsTime) {
        this.marsTime = marsTime;
        this.solOfMonthCache = marsTime.getSolOfMonth();
        this.setPreferredSize(new Dimension(140, 90));
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
    }

    public void update() {
        if (this.solOfMonthCache != this.marsTime.getSolOfMonth()) {
            this.solOfMonthCache = this.marsTime.getSolOfMonth();
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int x;
        g.setColor(new Color(0, 95, 0));
        g.fillRect(0, 0, 140, 90);
        g.setColor(new Color(0, 127, 0));
        g.fillRect(0, 0, 140, 10);
        int solsInMonth = MarsClock.getSolsInMonth((int)this.marsTime.getMonth(), (int)this.marsTime.getOrbit());
        if (solsInMonth == 27) {
            g.setColor(Color.black);
            g.fillRect(121, 71, 138, 88);
        }
        g.setColor(Color.green);
        g.drawRect(0, 0, 139, 89);
        for (x = 1; x < 7; ++x) {
            g.drawLine(20 * x, 0, 20 * x, 89);
        }
        for (x = 0; x < 4; ++x) {
            g.drawLine(0, 20 * x + 10, 139, 20 * x + 10);
        }
        Font weekFont = new Font("SansSerif", 0, 8);
        FontMetrics weekMetrics = this.getFontMetrics(weekFont);
        int weekHeight = weekMetrics.getAscent();
        g.setFont(weekFont);
        char[] weekLetters = new char[]{'S', 'P', 'D', 'T', 'H', 'V', 'J'};
        for (int x2 = 0; x2 < 7; ++x2) {
            int letterWidth = weekMetrics.charWidth(weekLetters[x2]);
            g.drawString("" + weekLetters[x2], 20 * x2 + 11 - letterWidth / 2, weekHeight - 1);
        }
        Font solFont = new Font("SansSerif", 1, 10);
        FontMetrics solMetrics = this.getFontMetrics(solFont);
        int solHeight = solMetrics.getAscent();
        g.setFont(solFont);
        for (int y = 0; y < 4; ++y) {
            for (int x3 = 0; x3 < 7; ++x3) {
                int solNumber = y * 7 + x3 + 1;
                int solNumberWidth = solMetrics.stringWidth("" + solNumber);
                int xPos = 20 * x3 + 11 - solNumberWidth / 2;
                int yPos = 20 * y + 30 - solHeight / 2;
                if (solNumber <= solsInMonth) {
                    g.drawString("" + solNumber, xPos, yPos);
                }
                if (solNumber != this.marsTime.getSolOfMonth()) continue;
                g.fillRect(20 * x3 + 2, 20 * y + 12, 17, 17);
                g.setColor(Color.black);
                g.drawString("" + solNumber, xPos, yPos);
                g.setColor(Color.green);
            }
        }
    }
}

