/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.time;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.time.ClockListener;
import org.mars_sim.msp.core.time.EarthClock;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.time.MasterClock;
import org.mars_sim.msp.core.time.UpTimer;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;
import org.mars_sim.msp.ui.swing.tool.time.MarsCalendarDisplay;

public class TimeWindow
extends ToolWindow
implements ClockListener {
    private static Logger logger = Logger.getLogger(TimeWindow.class.getName());
    public static final String NAME = "Time Tool";
    private static final double ratioatmid = 1000.0;
    private static final double maxratio = 10800.0;
    private static final double minfracratio = 0.001;
    private static final double maxfracratio = 0.98;
    private static final double minslider = 20.0;
    private static final double midslider = 30.0;
    private static final double maxslider = 80.0;
    private static final double minfracpos = 1.0;
    private static final double maxfracpos = 19.0;
    private MasterClock master;
    private MarsClock marsTime;
    private EarthClock earthTime;
    private UpTimer uptimer;
    private MarsCalendarDisplay calendarDisplay;
    private JLabel martianTimeLabel;
    private JLabel martianMonthLabel;
    private JLabel northernSeasonLabel;
    private JLabel southernSeasonLabel;
    private JLabel earthTimeLabel;
    private JLabel uptimeLabel;
    private JLabel pulsespersecondLabel;
    private JSlider pulseSlider;
    private int sliderpos = 50;
    private JButton pauseButton;

    public TimeWindow(MainDesktopPane desktop) {
        super(NAME, desktop);
        this.setResizable(false);
        this.master = Simulation.instance().getMasterClock();
        this.master.addClockListener((ClockListener)this);
        this.marsTime = this.master.getMarsClock();
        this.earthTime = this.master.getEarthClock();
        this.uptimer = this.master.getUpTimer();
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(new MarsPanelBorder());
        this.setContentPane(mainPane);
        JPanel martianTimePane = new JPanel(new BorderLayout());
        martianTimePane.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        mainPane.add((Component)martianTimePane, "North");
        JLabel martianTimeHeaderLabel = new JLabel("Martian Time", 0);
        martianTimePane.add((Component)martianTimeHeaderLabel, "North");
        this.martianTimeLabel = new JLabel(this.marsTime.getTimeStamp(), 0);
        martianTimePane.add((Component)this.martianTimeLabel, "South");
        JPanel martianCalendarPane = new JPanel(new FlowLayout());
        martianCalendarPane.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        mainPane.add((Component)martianCalendarPane, "Center");
        JPanel calendarMonthPane = new JPanel(new BorderLayout());
        martianCalendarPane.add(calendarMonthPane);
        this.martianMonthLabel = new JLabel(this.marsTime.getMonthName(), 0);
        calendarMonthPane.add((Component)this.martianMonthLabel, "North");
        this.calendarDisplay = new MarsCalendarDisplay(this.marsTime);
        JPanel innerCalendarPane = new JPanel(new FlowLayout(0, 0, 0));
        innerCalendarPane.setBorder(new BevelBorder(1));
        innerCalendarPane.add(this.calendarDisplay);
        calendarMonthPane.add((Component)innerCalendarPane, "Center");
        JPanel southPane = new JPanel(new BorderLayout());
        mainPane.add((Component)southPane, "South");
        JPanel simulationPane = new JPanel(new BorderLayout());
        southPane.add((Component)simulationPane, "South");
        JPanel marsSeasonPane = new JPanel(new BorderLayout());
        marsSeasonPane.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        southPane.add((Component)marsSeasonPane, "North");
        JLabel marsSeasonLabel = new JLabel("Martian Seasons", 0);
        marsSeasonPane.add((Component)marsSeasonLabel, "North");
        this.northernSeasonLabel = new JLabel("Northern Hemisphere: " + this.marsTime.getSeason(1), 0);
        marsSeasonPane.add((Component)this.northernSeasonLabel, "Center");
        this.southernSeasonLabel = new JLabel("Southern Hemisphere: " + this.marsTime.getSeason(2), 0);
        marsSeasonPane.add((Component)this.southernSeasonLabel, "South");
        JPanel earthTimePane = new JPanel(new BorderLayout());
        earthTimePane.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        southPane.add((Component)earthTimePane, "Center");
        JLabel earthTimeHeaderLabel = new JLabel("Earth Time", 0);
        earthTimePane.add((Component)earthTimeHeaderLabel, "North");
        this.earthTimeLabel = new JLabel(this.earthTime.getTimeStamp(), 0);
        earthTimePane.add((Component)this.earthTimeLabel, "South");
        JPanel uptimePane = new JPanel(new BorderLayout());
        uptimePane.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        simulationPane.add((Component)uptimePane, "North");
        JPanel pulsespersecondPane = new JPanel(new BorderLayout());
        pulsespersecondPane.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        uptimePane.add((Component)pulsespersecondPane, "South");
        JPanel pausePane = new JPanel(new BorderLayout());
        southPane.add((Component)pausePane, "North");
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeWindow.this.master.setPaused(!TimeWindow.this.master.isPaused());
            }
        });
        JLabel uptimeHeaderLabel = new JLabel("Simulation Uptime", 0);
        uptimePane.add((Component)uptimeHeaderLabel, "North");
        JLabel pulsespersecondHeaderLabel = new JLabel("Ticks Per Second", 0);
        pulsespersecondPane.add((Component)pulsespersecondHeaderLabel, "North");
        this.uptimeLabel = new JLabel(this.uptimer.getUptime(), 0);
        uptimePane.add((Component)this.uptimeLabel, "Center");
        DecimalFormat formatter = new DecimalFormat("0.00");
        String pulsePerSecond = formatter.format(this.master.getPulsesPerSecond());
        this.pulsespersecondLabel = new JLabel(pulsePerSecond, 0);
        pulsespersecondPane.add((Component)this.pulsespersecondLabel, "Center");
        JPanel pulsePane = new JPanel(new BorderLayout());
        pulsePane.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        simulationPane.add((Component)pulsePane, "South");
        JLabel pulseHeaderLabel = new JLabel("1 realsec : sim Time", 0);
        pulsePane.add((Component)pulseHeaderLabel, "North");
        pulsespersecondPane.add((Component)this.pauseButton, "South");
        try {
            this.setTimeRatioFromSlider(this.sliderpos);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        String s = this.master.getTimeString(this.master.getTimeRatio());
        final JLabel pulseCurRatioLabel = new JLabel(s, 0);
        pulsePane.add((Component)pulseCurRatioLabel, "Center");
        pulseCurRatioLabel.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (pulseCurRatioLabel.getText().contains(":")) {
                    pulseCurRatioLabel.setText(String.format("%8.4f", TimeWindow.this.master.getTimeRatio()));
                } else {
                    pulseCurRatioLabel.setText(TimeWindow.this.master.getTimeString(TimeWindow.this.master.getTimeRatio()));
                }
            }
        });
        this.pulseSlider = new JSlider(1, 100, this.sliderpos);
        this.pulseSlider.setMajorTickSpacing(10);
        this.pulseSlider.setMinorTickSpacing(2);
        this.pulseSlider.setPaintTicks(true);
        this.pulseSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    TimeWindow.this.setTimeRatioFromSlider(TimeWindow.this.pulseSlider.getValue());
                    if (pulseCurRatioLabel.getText().contains(":")) {
                        pulseCurRatioLabel.setText(TimeWindow.this.master.getTimeString(TimeWindow.this.master.getTimeRatio()));
                    } else {
                        pulseCurRatioLabel.setText(String.format("%8.4f", TimeWindow.this.master.getTimeRatio()));
                    }
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, e2.getMessage());
                }
            }
        });
        pulsePane.add((Component)this.pulseSlider, "South");
        this.pack();
        Dimension windowSize = this.getSize();
        this.setSize(new Dimension((int)windowSize.getWidth() + 10, (int)windowSize.getHeight()));
    }

    private void setTimeRatioFromSlider(int sliderValue) {
        double timeRatio;
        if (sliderValue > 0 && sliderValue <= 100) {
            if ((double)sliderValue >= 50.0) {
                double a = 1000.0;
                double b = 10.8;
                double T = 50.0;
                double expo = ((double)sliderValue - 20.0 - 30.0) / T;
                timeRatio = a * Math.pow(b, expo);
            } else if ((double)sliderValue >= 20.0) {
                double a = 1.0;
                double b = 1000.0;
                double T = 30.0;
                double expo = ((double)sliderValue - 20.0) / T;
                timeRatio = a * Math.pow(b, expo);
            } else {
                double offset = 0.001;
                double slope = 0.05438888888888889;
                timeRatio = ((double)sliderValue - 1.0) * slope + offset;
            }
        } else {
            double timeRatio2 = 15.0;
            throw new IllegalArgumentException("Time ratio should be in 1..100");
        }
        this.master.setTimeRatio(timeRatio);
    }

    public void setTimeRatioSlider(int r) {
        if (r >= this.pulseSlider.getMinimum() && r <= this.pulseSlider.getMaximum()) {
            this.pulseSlider.setValue(r);
        }
    }

    public void clockPulse(double time) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TimeWindow.this.marsTime != null) {
                    TimeWindow.this.martianTimeLabel.setText(TimeWindow.this.marsTime.getTimeStamp());
                    TimeWindow.this.martianMonthLabel.setText(TimeWindow.this.marsTime.getMonthName());
                    TimeWindow.this.northernSeasonLabel.setText("Northern Hemisphere: " + TimeWindow.this.marsTime.getSeason(1));
                    TimeWindow.this.southernSeasonLabel.setText("Southern Hemisphere: " + TimeWindow.this.marsTime.getSeason(2));
                }
                if (TimeWindow.this.earthTime != null) {
                    TimeWindow.this.earthTimeLabel.setText(TimeWindow.this.earthTime.getTimeStamp());
                }
                if (TimeWindow.this.master != null) {
                    DecimalFormat formatter = new DecimalFormat("0.00");
                    String pulsePerSecond = formatter.format(TimeWindow.this.master.getPulsesPerSecond());
                    TimeWindow.this.pulsespersecondLabel.setText(pulsePerSecond);
                }
                if (TimeWindow.this.uptimer != null) {
                    TimeWindow.this.uptimeLabel.setText(TimeWindow.this.uptimer.getUptime());
                }
                TimeWindow.this.calendarDisplay.update();
            }
        });
    }

    public void pauseChange(boolean isPaused) {
        if (isPaused) {
            this.pauseButton.setText("Resume");
        } else {
            this.pauseButton.setText("Pause");
        }
    }

    @Override
    public void destroy() {
        if (this.master != null) {
            this.master.removeClockListener((ClockListener)this);
        }
        this.master = null;
        this.marsTime = null;
        this.earthTime = null;
        this.uptimer = null;
    }
}

