/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_display_info;

import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.unit_display_info.CargoRoverDisplayInfoBean;
import org.mars_sim.msp.ui.swing.unit_display_info.EquipmentDisplayInfoBean;
import org.mars_sim.msp.ui.swing.unit_display_info.ExplorerRoverDisplayInfoBean;
import org.mars_sim.msp.ui.swing.unit_display_info.LUVDisplayInfoBean;
import org.mars_sim.msp.ui.swing.unit_display_info.PersonDisplayInfoBean;
import org.mars_sim.msp.ui.swing.unit_display_info.RoverDisplayInfoBean;
import org.mars_sim.msp.ui.swing.unit_display_info.SettlementDisplayInfoBean;
import org.mars_sim.msp.ui.swing.unit_display_info.TransportRoverDisplayInfoBean;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfo;

public final class UnitDisplayInfoFactory {
    private static UnitDisplayInfo settlementBean = new SettlementDisplayInfoBean();
    private static UnitDisplayInfo personBean = new PersonDisplayInfoBean();
    private static UnitDisplayInfo roverBean = new RoverDisplayInfoBean();
    private static UnitDisplayInfo explorerRoverBean = new ExplorerRoverDisplayInfoBean();
    private static UnitDisplayInfo transportRoverBean = new TransportRoverDisplayInfoBean();
    private static UnitDisplayInfo cargoRoverBean = new CargoRoverDisplayInfoBean();
    private static UnitDisplayInfo luvBean = new LUVDisplayInfoBean();
    private static UnitDisplayInfo equipmentBean = new EquipmentDisplayInfoBean();

    private UnitDisplayInfoFactory() {
    }

    public static UnitDisplayInfo getUnitDisplayInfo(Unit unit) {
        if (unit instanceof Settlement) {
            return settlementBean;
        }
        if (unit instanceof Person) {
            return personBean;
        }
        if (unit instanceof Vehicle) {
            if (unit instanceof Rover) {
                if (unit.getDescription().equals("Explorer Rover")) {
                    return explorerRoverBean;
                }
                if (unit.getDescription().equals("Transport Rover")) {
                    return transportRoverBean;
                }
                if (unit.getDescription().equals("Cargo Rover")) {
                    return cargoRoverBean;
                }
                return roverBean;
            }
            if (unit instanceof LightUtilityVehicle) {
                return luvBean;
            }
            return null;
        }
        if (unit instanceof Equipment) {
            return equipmentBean;
        }
        return null;
    }
}

