/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_display_info;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfo;

abstract class VehicleDisplayInfoBean
implements UnitDisplayInfo {
    private static double VEHICLE_CLICK_RANGE = 40.0;
    private Icon surfMapIcon = ImageLoader.getIcon("VehicleSymbol");
    private Icon topoMapIcon = ImageLoader.getIcon("VehicleSymbolBlack");
    private Font mapLabelFont = new Font("SansSerif", 0, 9);

    VehicleDisplayInfoBean() {
    }

    @Override
    public boolean isMapDisplayed(Unit unit) {
        Vehicle vehicle;
        boolean result = true;
        Unit container = unit.getContainerUnit();
        if (container != null) {
            result = false;
        }
        if ((vehicle = (Vehicle)unit).isSalvaged()) {
            result = false;
        }
        return result;
    }

    @Override
    public Icon getSurfMapIcon(Unit unit) {
        return this.surfMapIcon;
    }

    @Override
    public Icon getTopoMapIcon(Unit unit) {
        return this.topoMapIcon;
    }

    @Override
    public boolean isMapBlink(Unit unit) {
        return ((Vehicle)unit).isEmergencyBeacon();
    }

    @Override
    public Color getSurfMapLabelColor() {
        return Color.white;
    }

    @Override
    public Color getTopoMapLabelColor() {
        return Color.black;
    }

    @Override
    public Font getMapLabelFont() {
        return this.mapLabelFont;
    }

    @Override
    public double getMapClickRange() {
        return VEHICLE_CLICK_RANGE;
    }

    @Override
    public boolean isGlobeDisplayed(Unit unit) {
        Vehicle vehicle;
        boolean result = true;
        Unit container = unit.getContainerUnit();
        if (container != null) {
            result = false;
        }
        if ((vehicle = (Vehicle)unit).isSalvaged()) {
            result = false;
        }
        return result;
    }

    @Override
    public Color getSurfGlobeColor() {
        return Color.white;
    }

    @Override
    public Color getTopoGlobeColor() {
        return Color.black;
    }
}

