/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;

public class MalfunctionPanel
extends JPanel {
    private Malfunction malfunction;
    private JLabel nameLabel;
    private BoundedRangeModel repairBarModel;
    private JLabel partsLabel;

    public MalfunctionPanel(Malfunction malfunction) {
        this.malfunction = malfunction;
        this.setLayout(new GridLayout(3, 1, 0, 0));
        this.setBorder(new MarsPanelBorder());
        this.nameLabel = new JLabel(malfunction.getName(), 0);
        if (malfunction.getCompletedEmergencyWorkTime() < malfunction.getEmergencyWorkTime()) {
            this.nameLabel.setText(malfunction.getName() + " - Emergency");
            this.nameLabel.setForeground(Color.red);
        }
        this.add(this.nameLabel);
        JPanel repairPane = new JPanel(new FlowLayout(1, 0, 0));
        this.add(repairPane);
        JProgressBar repairBar = new JProgressBar();
        this.repairBarModel = repairBar.getModel();
        repairBar.setStringPainted(true);
        repairPane.add(repairBar);
        double totalRequiredWork = malfunction.getEmergencyWorkTime() + malfunction.getWorkTime() + malfunction.getEVAWorkTime();
        double totalCompletedWork = malfunction.getCompletedEmergencyWorkTime() + malfunction.getCompletedWorkTime() + malfunction.getCompletedEVAWorkTime();
        int percentComplete = 0;
        if (totalRequiredWork > 0.0) {
            percentComplete = (int)(100.0 * (totalCompletedWork / totalRequiredWork));
        }
        this.repairBarModel.setValue(percentComplete);
        this.partsLabel = new JLabel(this.getPartsString(), 0);
        this.partsLabel.setPreferredSize(new Dimension(-1, -1));
        this.add(this.partsLabel);
        this.setToolTipText(this.getToolTipString());
    }

    public void update() {
        if (this.malfunction.getCompletedEmergencyWorkTime() < this.malfunction.getEmergencyWorkTime()) {
            this.nameLabel.setText(this.malfunction.getName() + " - Emergency");
            this.nameLabel.setForeground(Color.red);
        } else {
            this.nameLabel.setText(this.malfunction.getName());
            this.nameLabel.setForeground(Color.black);
        }
        double totalRequiredWork = this.malfunction.getEmergencyWorkTime() + this.malfunction.getWorkTime() + this.malfunction.getEVAWorkTime();
        double totalCompletedWork = this.malfunction.getCompletedEmergencyWorkTime() + this.malfunction.getCompletedWorkTime() + this.malfunction.getCompletedEVAWorkTime();
        int percentComplete = 0;
        if (totalRequiredWork > 0.0) {
            percentComplete = (int)(100.0 * (totalCompletedWork / totalRequiredWork));
        }
        this.repairBarModel.setValue(percentComplete);
        this.partsLabel.setText(this.getPartsString());
    }

    private String getPartsString() {
        StringBuilder buf = new StringBuilder("Parts: ");
        Map parts = this.malfunction.getRepairParts();
        if (parts.size() > 0) {
            Iterator i = parts.keySet().iterator();
            while (i.hasNext()) {
                Part part = (Part)i.next();
                int number = (Integer)parts.get(part);
                buf.append(number).append(" ").append(part.getName());
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
        } else {
            buf.append("none");
        }
        return buf.toString();
    }

    public Malfunction getMalfunction() {
        return this.malfunction;
    }

    private String getToolTipString() {
        StringBuilder result = new StringBuilder("<html>");
        result.append(this.malfunction.getName()).append("<br>");
        result.append("General repair time: ").append((int)this.malfunction.getWorkTime()).append(" milliols<br>");
        result.append("EVA repair time: ").append((int)this.malfunction.getEVAWorkTime()).append(" milliols<br>");
        result.append("Emergency repair time: ").append((int)this.malfunction.getEmergencyWorkTime()).append(" milliols<br>");
        result.append("Repair ").append(this.getPartsString().toLowerCase());
        result.append("</html>");
        return result.toString();
    }
}

