/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window;

import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.UnitWindow;
import org.mars_sim.msp.ui.swing.unit_window.equipment.EquipmentWindow;
import org.mars_sim.msp.ui.swing.unit_window.person.PersonWindow;
import org.mars_sim.msp.ui.swing.unit_window.structure.SettlementWindow;
import org.mars_sim.msp.ui.swing.unit_window.vehicle.VehicleWindow;

public class UnitWindowFactory {
    private UnitWindowFactory() {
    }

    public static UnitWindow getUnitWindow(Unit unit, MainDesktopPane desktop) {
        if (unit instanceof Person) {
            return new PersonWindow(desktop, (Person)unit);
        }
        if (unit instanceof Vehicle) {
            return new VehicleWindow(desktop, (Vehicle)unit);
        }
        if (unit instanceof Settlement) {
            return new SettlementWindow(desktop, unit);
        }
        if (unit instanceof Equipment) {
            return new EquipmentWindow(desktop, (Equipment)unit);
        }
        return null;
    }
}

