/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.equipment;

import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.InventoryTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.LocationTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.MaintenanceTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.SalvageTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.UnitWindow;

public class EquipmentWindow
extends UnitWindow {
    private boolean salvaged;

    public EquipmentWindow(MainDesktopPane desktop, Equipment equipment) {
        super(desktop, (Unit)equipment, false);
        this.addTabPanel(new LocationTabPanel((Unit)equipment, desktop));
        this.addTabPanel(new InventoryTabPanel((Unit)equipment, desktop));
        if (equipment instanceof Malfunctionable) {
            this.addTabPanel(new MaintenanceTabPanel((Unit)equipment, desktop));
        }
        this.salvaged = equipment.isSalvaged();
        if (this.salvaged) {
            this.addTabPanel(new SalvageTabPanel((Unit)equipment, desktop));
        }
    }

    @Override
    public void update() {
        super.update();
        Equipment equipment = (Equipment)this.getUnit();
        if (!this.salvaged && equipment.isSalvaged()) {
            this.addTabPanel(new SalvageTabPanel((Unit)equipment, this.desktop));
            this.salvaged = true;
        }
    }
}

