/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.person;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.Mind;
import org.mars_sim.msp.core.person.ai.job.Job;
import org.mars_sim.msp.core.person.ai.job.JobManager;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.task.TaskManager;
import org.mars_sim.msp.core.person.medical.DeathInfo;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.MissionWindow;
import org.mars_sim.msp.ui.swing.tool.monitor.PersonTableModel;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class ActivityTabPanel
extends TabPanel
implements ActionListener {
    private JTextArea taskTextArea;
    private JTextArea taskPhaseTextArea;
    private JTextArea missionTextArea;
    private JTextArea missionPhaseTextArea;
    private JLabel jobLabel;
    private JComboBox jobComboBox;
    private JButton monitorButton;
    private JButton missionButton;
    private String jobCache = "";
    private String taskCache = "";
    private String taskPhaseCache = "";
    private String missionCache = "";
    private String missionPhaseCache = "";

    public ActivityTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Activity", null, "Activity", unit, desktop);
        Person person = (Person)unit;
        Mind mind = person.getMind();
        boolean dead = person.getPhysicalCondition().isDead();
        DeathInfo deathInfo = person.getPhysicalCondition().getDeathDetails();
        JPanel activityLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(activityLabelPanel);
        JLabel activityLabel = new JLabel("Activity", 0);
        activityLabelPanel.add(activityLabel);
        JPanel jobPanel = new JPanel(new FlowLayout(1));
        jobPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(jobPanel);
        this.jobLabel = new JLabel("Job: ", 0);
        jobPanel.add(this.jobLabel);
        this.jobCache = mind.getJob().getName();
        String[] jobNames = new String[JobManager.getJobs().size()];
        for (int x = 0; x < JobManager.getJobs().size(); ++x) {
            jobNames[x] = ((Job)JobManager.getJobs().get(x)).getName();
        }
        this.jobComboBox = new JComboBox<String>(jobNames);
        this.jobComboBox.setSelectedItem(this.jobCache);
        this.jobComboBox.addActionListener(this);
        jobPanel.add(this.jobComboBox);
        JPanel activityPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        this.centerContentPanel.add(activityPanel);
        JPanel taskTopPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        taskTopPanel.setBorder(new MarsPanelBorder());
        activityPanel.add(taskTopPanel);
        JPanel taskPanel = new JPanel(new BorderLayout(0, 0));
        taskTopPanel.add(taskPanel);
        JLabel taskLabel = new JLabel("Task", 0);
        taskPanel.add((Component)taskLabel, "North");
        this.taskCache = dead ? deathInfo.getTask() : mind.getTaskManager().getTaskDescription();
        this.taskTextArea = new JTextArea(2, 20);
        if (this.taskCache != null) {
            this.taskTextArea.setText(this.taskCache);
        }
        this.taskTextArea.setLineWrap(true);
        this.taskTextArea.setEditable(false);
        taskPanel.add((Component)new JScrollPane(this.taskTextArea), "Center");
        JPanel taskPhasePanel = new JPanel(new BorderLayout(0, 0));
        taskTopPanel.add(taskPhasePanel);
        JLabel taskPhaseLabel = new JLabel("Task Phase", 0);
        taskPhasePanel.add((Component)taskPhaseLabel, "North");
        this.taskPhaseCache = dead ? deathInfo.getTaskPhase() : mind.getTaskManager().getPhase();
        this.taskPhaseTextArea = new JTextArea(2, 20);
        if (this.taskPhaseCache != null) {
            this.taskPhaseTextArea.setText(this.taskPhaseCache);
        }
        this.taskPhaseTextArea.setLineWrap(true);
        this.taskPhaseTextArea.setEditable(false);
        taskPhasePanel.add((Component)new JScrollPane(this.taskPhaseTextArea), "Center");
        JPanel missionTopPanel = new JPanel(new FlowLayout(1));
        missionTopPanel.setBorder(new MarsPanelBorder());
        activityPanel.add(missionTopPanel);
        JPanel missionLeftPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        missionTopPanel.add((Component)missionLeftPanel, "Center");
        JPanel missionPanel = new JPanel(new BorderLayout(0, 0));
        missionLeftPanel.add(missionPanel);
        JLabel missionLabel = new JLabel("Mission", 0);
        missionPanel.add((Component)missionLabel, "North");
        if (dead) {
            this.missionCache = deathInfo.getMission();
        } else if (mind.getMission() != null) {
            this.missionCache = mind.getMission().getDescription();
        }
        this.missionTextArea = new JTextArea(2, 20);
        if (this.missionCache != null) {
            this.missionTextArea.setText(this.missionCache);
        }
        this.missionTextArea.setLineWrap(true);
        this.missionTextArea.setEditable(false);
        missionPanel.add((Component)new JScrollPane(this.missionTextArea), "Center");
        JPanel missionPhasePanel = new JPanel(new BorderLayout(0, 0));
        missionLeftPanel.add(missionPhasePanel);
        JLabel missionPhaseLabel = new JLabel("Mission Phase", 0);
        missionPhasePanel.add((Component)missionPhaseLabel, "North");
        if (dead) {
            this.missionPhaseCache = deathInfo.getMissionPhase();
        } else if (mind.getMission() != null) {
            this.missionPhaseCache = mind.getMission().getPhaseDescription();
        }
        this.missionPhaseTextArea = new JTextArea(2, 20);
        if (this.missionPhaseCache != null) {
            this.missionPhaseTextArea.setText(this.missionPhaseCache);
        }
        this.missionPhaseTextArea.setLineWrap(true);
        this.missionPhaseTextArea.setEditable(false);
        missionPhasePanel.add((Component)new JScrollPane(this.missionPhaseTextArea), "Center");
        JPanel missionButtonPanel = new JPanel(new GridLayout(2, 1, 0, 2));
        missionTopPanel.add(missionButtonPanel);
        this.missionButton = new JButton(ImageLoader.getIcon("Mission"));
        this.missionButton.setMargin(new Insets(1, 1, 1, 1));
        this.missionButton.setToolTipText("Open mission in mission tool.");
        this.missionButton.addActionListener(this);
        this.missionButton.setEnabled(mind.getMission() != null);
        missionButtonPanel.add(this.missionButton);
        this.monitorButton = new JButton(ImageLoader.getIcon("Monitor"));
        this.monitorButton.setMargin(new Insets(1, 1, 1, 1));
        this.monitorButton.setToolTipText("Open tab in monitor tool for this mission.");
        this.monitorButton.addActionListener(this);
        this.monitorButton.setEnabled(mind.getMission() != null);
        missionButtonPanel.add(this.monitorButton);
    }

    @Override
    public void update() {
        Person person = (Person)this.unit;
        Mind mind = person.getMind();
        boolean dead = person.getPhysicalCondition().isDead();
        DeathInfo deathInfo = person.getPhysicalCondition().getDeathDetails();
        if (dead) {
            this.jobCache = deathInfo.getJob();
            this.jobComboBox.setEnabled(false);
        } else {
            this.jobCache = mind.getJob().getName();
        }
        if (!this.jobCache.equals(this.jobComboBox.getSelectedItem())) {
            this.jobComboBox.setSelectedItem(this.jobCache);
        }
        TaskManager taskManager = null;
        Mission mission = null;
        if (!dead) {
            taskManager = mind.getTaskManager();
            if (mind.hasActiveMission()) {
                mission = mind.getMission();
            }
        }
        this.taskCache = dead ? deathInfo.getTask() : taskManager.getTaskDescription();
        if (!this.taskCache.equals(this.taskTextArea.getText())) {
            this.taskTextArea.setText(this.taskCache);
        }
        this.taskPhaseCache = dead ? deathInfo.getTaskPhase() : taskManager.getPhase();
        if (!this.taskPhaseCache.equals(this.taskPhaseTextArea.getText())) {
            this.taskPhaseTextArea.setText(this.taskPhaseCache);
        }
        this.missionCache = dead ? deathInfo.getMission() : (mission != null ? mission.getDescription() : "");
        if (this.missionCache != null && !this.missionCache.equals(this.missionTextArea.getText())) {
            this.missionTextArea.setText(this.missionCache);
        }
        this.missionPhaseCache = dead ? deathInfo.getMissionPhase() : (mission != null ? mission.getPhaseDescription() : "");
        if (this.missionPhaseCache != null && !this.missionPhaseCache.equals(this.missionPhaseTextArea.getText())) {
            this.missionPhaseTextArea.setText(this.missionPhaseCache);
        }
        this.missionButton.setEnabled(mission != null);
        this.monitorButton.setEnabled(mission != null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.missionButton || source == this.monitorButton) {
            Mind mind;
            Person person = (Person)this.unit;
            if (!person.getPhysicalCondition().isDead() && (mind = person.getMind()).hasActiveMission()) {
                if (source == this.missionButton) {
                    ((MissionWindow)this.desktop.getToolWindow("Mission Tool")).selectMission(mind.getMission());
                    this.getDesktop().openToolWindow("Mission Tool");
                } else if (source == this.monitorButton) {
                    this.desktop.addModel(new PersonTableModel(mind.getMission()));
                }
            }
        } else if (source == this.jobComboBox) {
            int jobIndex = this.jobComboBox.getSelectedIndex();
            Job job = (Job)JobManager.getJobs().get(jobIndex);
            ((Person)this.unit).getMind().setJob(job, true);
        }
    }
}

