/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.person;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.medical.DeathInfo;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class DeathTabPanel
extends TabPanel
implements ActionListener {
    public DeathTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Death", null, "Death Info", unit, desktop);
        Person person = (Person)unit;
        PhysicalCondition condition = person.getPhysicalCondition();
        DeathInfo death = condition.getDeathDetails();
        JPanel deathInfoLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(deathInfoLabelPanel);
        JLabel deathInfoLabel = new JLabel("Death Info", 0);
        deathInfoLabelPanel.add(deathInfoLabel);
        JPanel deathLabelPanel = new JPanel(new GridLayout(3, 1, 0, 0));
        deathLabelPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add((Component)deathLabelPanel, "North");
        JLabel causeLabel = new JLabel("Cause: " + death.getIllness(), 2);
        deathLabelPanel.add(causeLabel);
        JLabel timeLabel = new JLabel("Time: " + death.getTimeOfDeath(), 2);
        deathLabelPanel.add(timeLabel);
        JLabel malfunctionLabel = new JLabel("Malfunction (if any): " + death.getMalfunction(), 2);
        deathLabelPanel.add(malfunctionLabel);
        JPanel bottomContentPanel = new JPanel(new BorderLayout(0, 0));
        this.centerContentPanel.add((Component)bottomContentPanel, "Center");
        JPanel locationPanel = new JPanel(new BorderLayout());
        locationPanel.setBorder(new MarsPanelBorder());
        bottomContentPanel.add((Component)locationPanel, "North");
        JPanel locationLabelPanel = new JPanel(new FlowLayout(0));
        locationPanel.add((Component)locationLabelPanel, "North");
        JButton centerMapButton = new JButton(ImageLoader.getIcon("CenterMap"));
        centerMapButton.setMargin(new Insets(1, 1, 1, 1));
        centerMapButton.addActionListener(this);
        centerMapButton.setToolTipText("Locate in Mars Navigator");
        locationLabelPanel.add(centerMapButton);
        JLabel locationLabel = new JLabel("Location: ", 0);
        locationLabelPanel.add(locationLabel);
        if (death.getContainerUnit() != null) {
            JButton topContainerButton = new JButton(death.getContainerUnit().getName());
            topContainerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DeathInfo death = ((Person)DeathTabPanel.this.getUnit()).getPhysicalCondition().getDeathDetails();
                    DeathTabPanel.this.getDesktop().openUnitWindow(death.getContainerUnit(), false);
                }
            });
            locationLabelPanel.add(topContainerButton);
        } else {
            JLabel locationLabel2 = new JLabel(death.getPlaceOfDeath(), 0);
            locationLabelPanel.add(locationLabel2);
        }
        JPanel locationCoordsPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        locationPanel.add((Component)locationCoordsPanel, "Center");
        Coordinates deathLocation = death.getLocationOfDeath();
        JLabel latitudeLabel = new JLabel("Latitude: " + deathLocation.getFormattedLatitudeString(), 2);
        locationCoordsPanel.add(latitudeLabel);
        JLabel longitudeLabel = new JLabel("Longitude: " + deathLocation.getFormattedLongitudeString(), 2);
        locationCoordsPanel.add(longitudeLabel);
        bottomContentPanel.add((Component)new JPanel(), "Center");
    }

    @Override
    public void update() {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.desktop.centerMapGlobe(this.unit.getCoordinates());
    }
}

