/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.person;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PhysicalCondition;
import org.mars_sim.msp.core.person.medical.HealthProblem;
import org.mars_sim.msp.core.person.medical.Medication;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class HealthTabPanel
extends TabPanel {
    private DecimalFormat formatter = new DecimalFormat("0.0");
    private JLabel fatigueLabel;
    private JLabel hungerLabel;
    private JLabel stressLabel;
    private JLabel performanceLabel;
    private MedicationTableModel medicationTableModel;
    private HealthProblemTableModel healthProblemTableModel;
    private double fatigueCache;
    private double hungerCache;
    private double stressCache;
    private double performanceCache;

    public HealthTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Health", null, "Health", unit, desktop);
        Person person = (Person)unit;
        PhysicalCondition condition = person.getPhysicalCondition();
        JPanel healthLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(healthLabelPanel);
        JLabel healthLabel = new JLabel("Health", 0);
        healthLabelPanel.add(healthLabel);
        JPanel conditionPanel = new JPanel(new GridLayout(4, 2, 0, 0));
        conditionPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add((Component)conditionPanel, "North");
        JLabel fatigueNameLabel = new JLabel("Fatigue", 2);
        conditionPanel.add(fatigueNameLabel);
        this.fatigueCache = condition.getFatigue();
        this.fatigueLabel = new JLabel(this.formatter.format(this.fatigueCache) + " millisols", 4);
        conditionPanel.add(this.fatigueLabel);
        JLabel hungerNameLabel = new JLabel("Hunger", 2);
        conditionPanel.add(hungerNameLabel);
        this.hungerCache = condition.getHunger();
        this.hungerLabel = new JLabel(this.formatter.format(this.hungerCache) + " millisols", 4);
        conditionPanel.add(this.hungerLabel);
        JLabel stressNameLabel = new JLabel("Stress", 2);
        conditionPanel.add(stressNameLabel);
        this.stressCache = condition.getStress();
        this.stressLabel = new JLabel(this.formatter.format(this.stressCache) + " %", 4);
        conditionPanel.add(this.stressLabel);
        JLabel performanceNameLabel = new JLabel("Performance", 2);
        conditionPanel.add(performanceNameLabel);
        this.performanceCache = person.getPerformanceRating() * 100.0;
        this.performanceLabel = new JLabel(this.formatter.format(this.performanceCache) + " %", 4);
        conditionPanel.add(this.performanceLabel);
        JPanel tablePanel = new JPanel(new GridLayout(2, 1));
        this.centerContentPanel.add((Component)tablePanel, "Center");
        JPanel medicationPanel = new JPanel(new BorderLayout());
        medicationPanel.setBorder(new MarsPanelBorder());
        tablePanel.add(medicationPanel);
        JLabel medicationLabel = new JLabel("Medication", 0);
        medicationPanel.add((Component)medicationLabel, "North");
        JScrollPane medicationScrollPanel = new JScrollPane();
        medicationPanel.add((Component)medicationScrollPanel, "Center");
        this.medicationTableModel = new MedicationTableModel(person);
        JTable medicationTable = new JTable(this.medicationTableModel);
        medicationTable.setPreferredScrollableViewportSize(new Dimension(225, 50));
        medicationTable.setCellSelectionEnabled(false);
        medicationScrollPanel.setViewportView(medicationTable);
        JPanel healthProblemPanel = new JPanel(new BorderLayout());
        healthProblemPanel.setBorder(new MarsPanelBorder());
        tablePanel.add(healthProblemPanel);
        JLabel healthProblemLabel = new JLabel("Health Problems", 0);
        healthProblemPanel.add((Component)healthProblemLabel, "North");
        JScrollPane healthProblemScrollPanel = new JScrollPane();
        healthProblemPanel.add((Component)healthProblemScrollPanel, "Center");
        this.healthProblemTableModel = new HealthProblemTableModel(person);
        JTable healthProblemTable = new JTable(this.healthProblemTableModel);
        healthProblemTable.setPreferredScrollableViewportSize(new Dimension(225, 50));
        healthProblemTable.setCellSelectionEnabled(false);
        healthProblemScrollPanel.setViewportView(healthProblemTable);
    }

    @Override
    public void update() {
        Person person = (Person)this.unit;
        PhysicalCondition condition = person.getPhysicalCondition();
        if (this.fatigueCache != condition.getFatigue()) {
            this.fatigueCache = condition.getFatigue();
            this.fatigueLabel.setText(this.formatter.format(this.fatigueCache) + " millisols");
        }
        if (this.hungerCache != condition.getHunger()) {
            this.hungerCache = condition.getHunger();
            this.hungerLabel.setText(this.formatter.format(this.hungerCache) + " millisols");
        }
        if (this.stressCache != condition.getStress()) {
            this.stressCache = condition.getStress();
            this.stressLabel.setText(this.formatter.format(this.stressCache) + " %");
        }
        if (this.performanceCache != person.getPerformanceRating() * 100.0) {
            this.performanceCache = person.getPerformanceRating() * 100.0;
            this.performanceLabel.setText(this.formatter.format(this.performanceCache) + "%");
        }
        this.medicationTableModel.update();
        this.healthProblemTableModel.update();
    }

    private static class MedicationTableModel
    extends AbstractTableModel {
        private PhysicalCondition condition;
        private List<Medication> medicationCache;

        private MedicationTableModel(Person person) {
            this.condition = person.getPhysicalCondition();
            this.medicationCache = this.condition.getMedicationList();
        }

        @Override
        public int getRowCount() {
            return this.medicationCache.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            } else if (columnIndex == 1) {
                dataType = Double.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Medication";
            }
            if (columnIndex == 1) {
                return "Duration (millisols)";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.getRowCount()) {
                if (column == 0) {
                    result = this.medicationCache.get(row).getName();
                } else if (column == 1) {
                    result = this.medicationCache.get(row).getDuration();
                }
            }
            return result;
        }

        public void update() {
            if (!this.medicationCache.equals(this.condition.getMedicationList())) {
                this.medicationCache = this.condition.getMedicationList();
            }
            this.fireTableDataChanged();
        }
    }

    private static class HealthProblemTableModel
    extends AbstractTableModel {
        PhysicalCondition condition;
        Collection problemsCache;

        private HealthProblemTableModel(Person person) {
            this.condition = person.getPhysicalCondition();
            this.problemsCache = this.condition.getProblems();
        }

        @Override
        public int getRowCount() {
            return this.problemsCache.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            }
            if (columnIndex == 1) {
                dataType = String.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Problem";
            }
            if (columnIndex == 1) {
                return "Condition";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            HealthProblem problem = null;
            if (row < this.problemsCache.size()) {
                Iterator i = this.problemsCache.iterator();
                int count = 0;
                while (i.hasNext()) {
                    HealthProblem prob = (HealthProblem)i.next();
                    if (count == row) {
                        problem = prob;
                    }
                    ++count;
                }
            }
            if (problem != null) {
                if (column == 0) {
                    return problem.getIllness().getName();
                }
                if (column == 1) {
                    String conditionStr = problem.getStateString();
                    if (!this.condition.isDead()) {
                        conditionStr = conditionStr + " (" + problem.getHealthRating() + "%)";
                    }
                    return conditionStr;
                }
                return "unknown";
            }
            return "unknown";
        }

        public void update() {
            if (!this.problemsCache.equals(this.condition.getProblems())) {
                this.problemsCache = this.condition.getProblems();
            }
            this.fireTableDataChanged();
        }
    }
}

