/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.person;

import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.InventoryTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.LocationTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.UnitWindow;
import org.mars_sim.msp.ui.swing.unit_window.person.ActivityTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.person.AttributeTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.person.DeathTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.person.GeneralTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.person.HealthTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.person.ScienceTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.person.SkillTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.person.SocialTabPanel;

public class PersonWindow
extends UnitWindow {
    private boolean dead = false;

    public PersonWindow(MainDesktopPane desktop, Person person) {
        super(desktop, (Unit)person, false);
        this.addTabPanel(new LocationTabPanel((Unit)person, desktop));
        this.addTabPanel(new InventoryTabPanel((Unit)person, desktop));
        this.addTabPanel(new AttributeTabPanel(person, desktop));
        this.addTabPanel(new SkillTabPanel(person, desktop));
        this.addTabPanel(new ActivityTabPanel((Unit)person, desktop));
        this.addTabPanel(new HealthTabPanel((Unit)person, desktop));
        this.addTabPanel(new GeneralTabPanel((Unit)person, desktop));
        this.addTabPanel(new SocialTabPanel(person, desktop));
        this.addTabPanel(new ScienceTabPanel(person, desktop));
        if (person.getPhysicalCondition().isDead()) {
            this.dead = true;
            this.addTabPanel(new DeathTabPanel((Unit)person, desktop));
        } else {
            this.dead = false;
        }
    }

    @Override
    public void update() {
        super.update();
        Person person = (Person)this.unit;
        if (!this.dead && person.getPhysicalCondition().isDead()) {
            this.dead = true;
            this.addTabPanel(new DeathTabPanel((Unit)person, this.desktop));
        }
    }
}

