/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.person;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;
import org.mars_sim.msp.ui.swing.tool.science.ScienceWindow;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class ScienceTabPanel
extends TabPanel {
    private JButton scienceToolButton;
    private StudyTableModel studyTableModel;
    private JTable studyTable;
    private AchievementTableModel achievementTableModel;
    private JTable achievementTable;
    private JLabel totalAchievementLabel;

    public ScienceTabPanel(Person person, MainDesktopPane desktop) {
        super("Science", null, "Science", (Unit)person, desktop);
        JPanel titlePane = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(titlePane);
        JLabel titleLabel = new JLabel("Science", 0);
        titlePane.add(titleLabel);
        JPanel mainPane = new JPanel(new GridLayout(2, 1, 0, 0));
        this.centerContentPanel.add(mainPane);
        JPanel studiesPane = new JPanel(new BorderLayout());
        studiesPane.setBorder(new MarsPanelBorder());
        mainPane.add(studiesPane);
        JLabel studiesLabel = new JLabel("Scientific Studies", 0);
        studiesPane.add((Component)studiesLabel, "North");
        JScrollPane studyScrollPane = new JScrollPane();
        studyScrollPane.setBorder(new MarsPanelBorder());
        studyScrollPane.setHorizontalScrollBarPolicy(31);
        studiesPane.add((Component)studyScrollPane, "Center");
        this.studyTableModel = new StudyTableModel(person);
        this.studyTable = new JTable(this.studyTableModel);
        this.studyTable.setPreferredScrollableViewportSize(new Dimension(225, -1));
        this.studyTable.setCellSelectionEnabled(false);
        this.studyTable.setRowSelectionAllowed(true);
        this.studyTable.setSelectionMode(0);
        this.studyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting() && ScienceTabPanel.this.studyTable.getSelectedRow() >= 0) {
                    ScienceTabPanel.this.setEnabledScienceToolButton(true);
                }
            }
        });
        studyScrollPane.setViewportView(this.studyTable);
        JPanel buttonPane = new JPanel(new FlowLayout(1));
        studiesPane.add((Component)buttonPane, "South");
        this.scienceToolButton = new JButton(ImageLoader.getIcon("Science"));
        this.scienceToolButton.setEnabled(false);
        this.scienceToolButton.setMargin(new Insets(1, 1, 1, 1));
        this.scienceToolButton.setToolTipText("Open study in science tool.");
        this.scienceToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScienceTabPanel.this.displayStudyInScienceTool();
            }
        });
        buttonPane.add(this.scienceToolButton);
        JPanel achievementPane = new JPanel(new BorderLayout());
        achievementPane.setBorder(new MarsPanelBorder());
        mainPane.add(achievementPane);
        JPanel achievementLabelPane = new JPanel(new GridLayout(2, 1, 0, 0));
        achievementPane.add((Component)achievementLabelPane, "North");
        JLabel achievementLabel = new JLabel("Scientific Achievement", 0);
        achievementLabelPane.add(achievementLabel);
        DecimalFormat formatter = new DecimalFormat("0.0");
        String totalAchievementString = formatter.format(person.getTotalScientificAchievement());
        this.totalAchievementLabel = new JLabel("Total Achievement Credit: " + totalAchievementString, 0);
        achievementLabelPane.add(this.totalAchievementLabel);
        JScrollPane achievementScrollPane = new JScrollPane();
        achievementScrollPane.setBorder(new MarsPanelBorder());
        achievementScrollPane.setHorizontalScrollBarPolicy(31);
        achievementPane.add((Component)achievementScrollPane, "Center");
        this.achievementTableModel = new AchievementTableModel(person);
        this.achievementTable = new JTable(this.achievementTableModel);
        this.achievementTable.setPreferredScrollableViewportSize(new Dimension(225, -1));
        this.achievementTable.setCellSelectionEnabled(false);
        this.achievementTable.setDefaultRenderer(Double.class, new NumberCellRenderer(1));
        achievementScrollPane.setViewportView(this.achievementTable);
    }

    @Override
    public void update() {
        int newStudyIndex;
        int selectedStudyIndex = this.studyTable.getSelectedRow();
        ScientificStudy selectedStudy = null;
        if (selectedStudyIndex >= 0) {
            selectedStudy = this.studyTableModel.getStudy(selectedStudyIndex);
        }
        this.studyTableModel.update();
        if (selectedStudy != null && (newStudyIndex = this.studyTableModel.getStudyIndex(selectedStudy)) >= 0) {
            this.studyTable.getSelectionModel().setSelectionInterval(newStudyIndex, newStudyIndex);
        }
        this.achievementTableModel.update();
        Person person = (Person)this.getUnit();
        DecimalFormat formatter = new DecimalFormat("0.0");
        String totalAchievementString = formatter.format(person.getTotalScientificAchievement());
        this.totalAchievementLabel.setText("Total Achievement Credit: " + totalAchievementString);
    }

    private void setEnabledScienceToolButton(boolean enabled) {
        this.scienceToolButton.setEnabled(enabled);
    }

    private void displayStudyInScienceTool() {
        int selectedStudyIndex = this.studyTable.getSelectedRow();
        if (selectedStudyIndex >= 0) {
            ScientificStudy selectedStudy = this.studyTableModel.getStudy(selectedStudyIndex);
            ((ScienceWindow)this.desktop.getToolWindow("Science Tool")).setScientificStudy(selectedStudy);
            this.getDesktop().openToolWindow("Science Tool");
        }
    }

    private static class AchievementTableModel
    extends AbstractTableModel {
        private Person person;
        private List<Science> sciences;

        private AchievementTableModel(Person person) {
            this.person = person;
            this.sciences = ScienceUtil.getAllSciences();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Science";
            }
            if (columnIndex == 1) {
                return "Achievement Credit";
            }
            return "unknown";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            } else if (columnIndex == 1) {
                dataType = Double.class;
            }
            return dataType;
        }

        @Override
        public int getRowCount() {
            return this.sciences.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object result = null;
            if (rowIndex >= 0 && rowIndex < this.sciences.size()) {
                Science science = this.sciences.get(rowIndex);
                if (columnIndex == 0) {
                    result = science.getName();
                } else if (columnIndex == 1) {
                    result = this.person.getScientificAchievement(science);
                }
            }
            return result;
        }

        private void update() {
            this.fireTableDataChanged();
        }
    }

    private static class StudyTableModel
    extends AbstractTableModel {
        private Person person;
        private List<ScientificStudy> studies;

        private StudyTableModel(Person person) {
            this.person = person;
            ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
            this.studies = manager.getAllStudies(person);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Study";
            }
            if (columnIndex == 1) {
                return "Role";
            }
            if (columnIndex == 2) {
                return "Status";
            }
            return "unknown";
        }

        @Override
        public int getRowCount() {
            return this.studies.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String result = null;
            if (rowIndex >= 0 && rowIndex < this.studies.size()) {
                ScientificStudy study = this.studies.get(rowIndex);
                if (columnIndex == 0) {
                    result = study.toString();
                } else if (columnIndex == 1) {
                    result = this.person.equals(study.getPrimaryResearcher()) ? "Primary" : "Collaborator";
                } else if (columnIndex == 2) {
                    result = study.isCompleted() ? study.getCompletionState() : study.getPhase();
                }
            }
            return result;
        }

        private void update() {
            ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
            List newStudies = manager.getAllStudies(this.person);
            if (!newStudies.equals(this.studies)) {
                this.studies = newStudies;
            }
            this.fireTableDataChanged();
        }

        private ScientificStudy getStudy(int rowIndex) {
            ScientificStudy result = null;
            if (rowIndex >= 0 && rowIndex < this.studies.size()) {
                result = this.studies.get(rowIndex);
            }
            return result;
        }

        private int getStudyIndex(ScientificStudy study) {
            int result = -1;
            if (study != null && this.studies.contains(study)) {
                result = this.studies.indexOf(study);
            }
            return result;
        }
    }
}

