/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.person;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.SkillManager;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class SkillTabPanel
extends TabPanel {
    private SkillTableModel skillTableModel;

    public SkillTabPanel(Person person, MainDesktopPane desktop) {
        super("Skills", null, "Skills", (Unit)person, desktop);
        JPanel skillLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(skillLabelPanel);
        JLabel skillLabel = new JLabel("Skills", 0);
        skillLabelPanel.add(skillLabel);
        JScrollPane skillScrollPanel = new JScrollPane();
        skillScrollPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add(skillScrollPanel);
        this.skillTableModel = new SkillTableModel(person);
        JTable skillTable = new JTable(this.skillTableModel);
        skillTable.setPreferredScrollableViewportSize(new Dimension(225, 100));
        skillTable.getColumnModel().getColumn(0).setPreferredWidth(120);
        skillTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        skillTable.setCellSelectionEnabled(false);
        skillTable.setDefaultRenderer(Integer.class, new NumberCellRenderer());
        skillScrollPanel.setViewportView(skillTable);
    }

    @Override
    public void update() {
        this.skillTableModel.update();
    }

    private static class SkillTableModel
    extends AbstractTableModel {
        SkillManager manager;
        Map<String, Integer> skills;
        List<String> skillNames;

        private SkillTableModel(Person person) {
            this.manager = person.getMind().getSkillManager();
            String[] keys = this.manager.getKeys();
            this.skills = new HashMap<String, Integer>();
            this.skillNames = new ArrayList<String>();
            for (String key : keys) {
                int level = this.manager.getSkillLevel(key);
                if (level <= 0) continue;
                this.skillNames.add(key);
                this.skills.put(key, level);
            }
        }

        @Override
        public int getRowCount() {
            return this.skillNames.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            }
            if (columnIndex == 1) {
                dataType = Integer.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Skill";
            }
            if (columnIndex == 1) {
                return "Level";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.skillNames.get(row);
            }
            if (column == 1) {
                return this.skills.get(this.skillNames.get(row));
            }
            return "unknown";
        }

        public void update() {
            String[] keys = this.manager.getKeys();
            ArrayList<String> newSkillNames = new ArrayList<String>();
            HashMap<String, Integer> newSkills = new HashMap<String, Integer>();
            for (String key : keys) {
                int level = this.manager.getSkillLevel(key);
                if (level <= 0) continue;
                newSkillNames.add(key);
                newSkills.put(key, level);
            }
            if (!this.skills.equals(newSkills)) {
                this.skillNames = newSkillNames;
                this.skills = newSkills;
                this.fireTableDataChanged();
            }
        }
    }
}

