/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.person;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.social.RelationshipManager;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class SocialTabPanel
extends TabPanel
implements ListSelectionListener {
    private JTable relationshipTable;
    private RelationshipTableModel relationshipTableModel;

    public SocialTabPanel(Person person, MainDesktopPane desktop) {
        super("Social", null, "Social", (Unit)person, desktop);
        JPanel relationshipLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(relationshipLabelPanel);
        JLabel relationshipLabel = new JLabel("Relationships", 0);
        relationshipLabelPanel.add(relationshipLabel);
        JScrollPane relationshipScrollPanel = new JScrollPane();
        relationshipScrollPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add(relationshipScrollPanel);
        this.relationshipTableModel = new RelationshipTableModel(person);
        this.relationshipTable = new JTable(this.relationshipTableModel);
        this.relationshipTable.setPreferredScrollableViewportSize(new Dimension(225, 100));
        this.relationshipTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.relationshipTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.relationshipTable.setCellSelectionEnabled(true);
        this.relationshipTable.setSelectionMode(0);
        this.relationshipTable.getSelectionModel().addListSelectionListener(this);
        relationshipScrollPanel.setViewportView(this.relationshipTable);
    }

    @Override
    public void update() {
        this.relationshipTableModel.update();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.relationshipTable.getSelectedRow();
        Person selectedPerson = (Person)this.relationshipTable.getValueAt(index, 0);
        if (selectedPerson != null) {
            this.desktop.openUnitWindow((Unit)selectedPerson, false);
        }
    }

    private static class RelationshipTableModel
    extends AbstractTableModel {
        RelationshipManager manager;
        Collection knownPeople;
        Person person;

        private RelationshipTableModel(Person person) {
            this.person = person;
            this.manager = Simulation.instance().getRelationshipManager();
            this.knownPeople = this.manager.getAllKnownPeople(person);
        }

        @Override
        public int getRowCount() {
            return this.knownPeople.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            }
            if (columnIndex == 1) {
                dataType = String.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Person";
            }
            if (columnIndex == 1) {
                return "Relationship";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.knownPeople.toArray()[row];
            }
            if (column == 1) {
                double opinion = this.manager.getOpinionOfPerson(this.person, (Person)this.knownPeople.toArray()[row]);
                return this.getRelationshipString(opinion);
            }
            return "unknown";
        }

        public void update() {
            Collection newKnownPeople = this.manager.getAllKnownPeople(this.person);
            if (!this.knownPeople.equals(newKnownPeople)) {
                this.knownPeople = newKnownPeople;
                this.fireTableDataChanged();
            } else {
                this.fireTableDataChanged();
            }
        }

        private String getRelationshipString(double opinion) {
            String result = "";
            result = opinion < 5.0 ? "Hatred" : (opinion < 20.0 ? "Antagonism" : (opinion < 35.0 ? "Unfriendly" : (opinion < 45.0 ? "Bothersome" : (opinion < 55.0 ? "Indifference" : (opinion < 65.0 ? "Cordial" : (opinion < 80.0 ? "Amicable" : (opinion < 95.0 ? "Friendly" : "Devoted")))))));
            return result;
        }
    }
}

