/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionVehicleType;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;

public class ConstructionSitesPanel
extends JPanel {
    private ConstructionManager manager;
    private List<ConstructionSite> sitesCache;
    private JPanel sitesListPane;
    private JScrollPane sitesScrollPane;

    public ConstructionSitesPanel(ConstructionManager manager) {
        this.manager = manager;
        this.setLayout(new BorderLayout());
        this.setBorder(new MarsPanelBorder());
        JPanel titlePanel = new JPanel(new FlowLayout(1));
        this.add((Component)titlePanel, "North");
        JLabel titleLabel = new JLabel("Construction Sites");
        titlePanel.add(titleLabel);
        this.sitesScrollPane = new JScrollPane();
        this.sitesScrollPane.setPreferredSize(new Dimension(200, 75));
        this.sitesScrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.sitesScrollPane, "Center");
        JPanel sitesOuterListPane = new JPanel(new BorderLayout(0, 0));
        this.sitesScrollPane.setViewportView(sitesOuterListPane);
        this.sitesListPane = new JPanel();
        this.sitesListPane.setLayout(new BoxLayout(this.sitesListPane, 1));
        sitesOuterListPane.add((Component)this.sitesListPane, "North");
        this.sitesCache = manager.getConstructionSites();
        Iterator<ConstructionSite> i = this.sitesCache.iterator();
        while (i.hasNext()) {
            this.sitesListPane.add(new ConstructionSitePanel(i.next()));
        }
    }

    public void update() {
        List sites = this.manager.getConstructionSites();
        if (!this.sitesCache.equals(sites)) {
            for (ConstructionSite site : sites) {
                if (this.sitesCache.contains(site)) continue;
                this.sitesListPane.add(new ConstructionSitePanel(site));
            }
            for (ConstructionSite site : this.sitesCache) {
                ConstructionSitePanel panel;
                if (sites.contains(site) || (panel = this.getConstructionSitePanel(site)) == null) continue;
                this.sitesListPane.remove(panel);
            }
            this.sitesScrollPane.validate();
            this.sitesCache.clear();
            this.sitesCache.addAll(sites);
        }
        Iterator i = sites.iterator();
        while (i.hasNext()) {
            ConstructionSitePanel panel = this.getConstructionSitePanel((ConstructionSite)i.next());
            if (panel == null) continue;
            panel.update();
        }
    }

    private ConstructionSitePanel getConstructionSitePanel(ConstructionSite site) {
        ConstructionSitePanel result = null;
        for (int x = 0; x < this.sitesListPane.getComponentCount(); ++x) {
            ConstructionSitePanel panel;
            Component component = this.sitesListPane.getComponent(x);
            if (!(component instanceof ConstructionSitePanel) || !(panel = (ConstructionSitePanel)component).getConstructionSite().equals(site)) continue;
            result = panel;
        }
        return result;
    }

    private static class ConstructionSitePanel
    extends JPanel {
        private ConstructionSite site;
        private JLabel statusLabel;
        private BoundedRangeModel workBarModel;

        private ConstructionSitePanel(ConstructionSite site) {
            this.site = site;
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(new MarsPanelBorder());
            this.statusLabel = new JLabel("Status: ", 2);
            this.add((Component)this.statusLabel, "North");
            JPanel progressBarPanel = new JPanel();
            this.add((Component)progressBarPanel, "Center");
            JProgressBar workBar = new JProgressBar();
            this.workBarModel = workBar.getModel();
            workBar.setStringPainted(true);
            progressBarPanel.add(workBar);
            this.update();
            this.setToolTipText(this.getToolTipString());
        }

        private ConstructionSite getConstructionSite() {
            return this.site;
        }

        private void update() {
            String statusString = this.getStatusString();
            if (statusString.length() > 31) {
                statusString = statusString.substring(0, 31) + "...";
            }
            this.statusLabel.setText(statusString);
            int workProgress = 0;
            ConstructionStage stage = this.site.getCurrentConstructionStage();
            if (stage != null) {
                double completedWork = stage.getCompletedWorkTime();
                double requiredWork = stage.getRequiredWorkTime();
                if (requiredWork > 0.0) {
                    workProgress = (int)(100.0 * completedWork / requiredWork);
                }
            }
            this.workBarModel.setValue(workProgress);
            this.setToolTipText(this.getToolTipString());
        }

        private String getStatusString() {
            String statusString = "";
            ConstructionStage stage = this.site.getCurrentConstructionStage();
            statusString = stage != null ? (this.site.isUndergoingConstruction() ? "Status: constructing " + stage.getInfo().getName() : (this.site.isUndergoingSalvage() ? "Status: salvaging " + stage.getInfo().getName() : (this.site.hasUnfinishedStage() ? (stage.isSalvaging() ? "Status: salvaging " + stage.getInfo().getName() + " unfinished" : "Status: constructing " + stage.getInfo().getName() + " unfinished") : "Status: " + stage.getInfo().getName() + " completed"))) : "No construction";
            return statusString;
        }

        private String getToolTipString() {
            StringBuilder result = new StringBuilder("<html>");
            result.append(this.getStatusString()).append("<br>");
            ConstructionStage stage = this.site.getCurrentConstructionStage();
            if (stage != null) {
                ConstructionStageInfo info = stage.getInfo();
                result.append("Stage Type: ").append(info.getType()).append("<br>");
                if (stage.isSalvaging()) {
                    result.append("Work Type: salvage<br>");
                } else {
                    result.append("Work Type: Construction<br>");
                }
                DecimalFormat formatter = new DecimalFormat("0.0");
                String requiredWorkTime = formatter.format(stage.getRequiredWorkTime() / 1000.0);
                result.append("Work Time Required: ").append(requiredWorkTime).append(" Sols<br>");
                String completedWorkTime = formatter.format(stage.getCompletedWorkTime() / 1000.0);
                result.append("Work Time Completed: ").append(completedWorkTime).append(" Sols<br>");
                result.append("Architect Construction Skill Required: ").append(info.getArchitectConstructionSkill()).append("<br>");
                if (info.getResources().size() > 0 && !stage.isSalvaging()) {
                    result.append("<br>Construction Resources:<br>");
                    for (AmountResource resource : info.getResources().keySet()) {
                        double amount = (Double)info.getResources().get(resource);
                        result.append("&nbsp;&nbsp;").append(resource.getName()).append(": ").append(amount).append(" kg<br>");
                    }
                }
                if (info.getParts().size() > 0) {
                    if (stage.isSalvaging()) {
                        result.append("<br>Salvagable Parts:<br>");
                    } else {
                        result.append("<br>Construction Parts:<br>");
                    }
                    for (Part part : info.getParts().keySet()) {
                        int number = (Integer)info.getParts().get(part);
                        result.append("&nbsp;&nbsp;").append(part.getName()).append(": ").append(number).append("<br>");
                    }
                }
                if (info.getVehicles().size() > 0) {
                    if (stage.isSalvaging()) {
                        result.append("<br>Salvage Vehicles:<br>");
                    } else {
                        result.append("<br>Construction Vehicles:<br>");
                    }
                    for (ConstructionVehicleType vehicle : info.getVehicles()) {
                        result.append("&nbsp;&nbsp;Vehicle Type: ").append(vehicle.getVehicleType()).append("<br>");
                        result.append("&nbsp;&nbsp;Attachment Parts:<br>");
                        Iterator l = vehicle.getAttachmentParts().iterator();
                        while (l.hasNext()) {
                            result.append("&nbsp;&nbsp;&nbsp;&nbsp;").append(((Part)l.next()).getName()).append("<br>");
                        }
                    }
                }
            }
            result.append("</html>");
            return result.toString();
        }
    }
}

