/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.ConstructedBuildingsPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.ConstructionSitesPanel;

public class ConstructionTabPanel
extends TabPanel {
    private Settlement settlement;
    private ConstructionSitesPanel sitesPanel;
    private ConstructedBuildingsPanel buildingsPanel;
    private JCheckBox overrideCheckbox;

    public ConstructionTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Const", null, "Construction", unit, desktop);
        this.settlement = (Settlement)unit;
        ConstructionManager manager = this.settlement.getConstructionManager();
        JPanel titlePanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(titlePanel);
        JLabel constructionLabel = new JLabel("Construction", 0);
        titlePanel.add(constructionLabel);
        JPanel mainContentPanel = new JPanel(new GridLayout(2, 1));
        this.centerContentPanel.add((Component)mainContentPanel, "Center");
        this.sitesPanel = new ConstructionSitesPanel(manager);
        mainContentPanel.add(this.sitesPanel);
        this.buildingsPanel = new ConstructedBuildingsPanel(manager);
        mainContentPanel.add(this.buildingsPanel);
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        bottomPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add((Component)bottomPanel, "South");
        this.overrideCheckbox = new JCheckBox("Override construction & salvage");
        this.overrideCheckbox.setToolTipText("Prevents settlement inhabitants from starting new construction/salvage building missions.");
        this.overrideCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConstructionTabPanel.this.setConstructionOverride(ConstructionTabPanel.this.overrideCheckbox.isSelected());
            }
        });
        this.overrideCheckbox.setSelected(this.settlement.getConstructionOverride());
        bottomPanel.add(this.overrideCheckbox);
    }

    private void setConstructionOverride(boolean constructionOverride) {
        this.settlement.setConstructionOverride(constructionOverride);
    }

    @Override
    public void update() {
        this.sitesPanel.update();
        this.buildingsPanel.update();
        if (this.settlement.getConstructionOverride() != this.overrideCheckbox.isSelected()) {
            this.overrideCheckbox.setSelected(this.settlement.getConstructionOverride());
        }
    }
}

