/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.mars_sim.msp.core.manufacture.ManufactureProcess;
import org.mars_sim.msp.core.manufacture.ManufactureProcessInfo;
import org.mars_sim.msp.core.manufacture.ManufactureProcessItem;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;

public class ManufacturePanel
extends JPanel {
    private ManufactureProcess process;
    private BoundedRangeModel workBarModel;
    private BoundedRangeModel timeBarModel;

    public ManufacturePanel(ManufactureProcess process, boolean showBuilding, int processStringWidth) {
        this.process = process;
        if (showBuilding) {
            this.setLayout(new GridLayout(4, 1, 0, 0));
        } else {
            this.setLayout(new GridLayout(3, 1, 0, 0));
        }
        this.setBorder(new MarsPanelBorder());
        JPanel namePane = new JPanel(new FlowLayout(0, 1, 0));
        this.add(namePane);
        JButton cancelButton = new JButton(ImageLoader.getIcon("CancelSmall"));
        cancelButton.setMargin(new Insets(0, 0, 0, 0));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ManufacturePanel.this.getManufactureProcess().getWorkshop().endManufacturingProcess(ManufacturePanel.this.getManufactureProcess(), true);
            }
        });
        cancelButton.setToolTipText("Cancel manufacturing process");
        namePane.add(cancelButton);
        String name = process.getInfo().getName();
        if (name.length() > 0) {
            String firstLetter = name.substring(0, 1).toUpperCase();
            name = " " + firstLetter + name.substring(1);
        }
        if (name.length() > processStringWidth) {
            name = name.substring(0, processStringWidth) + "...";
        }
        JLabel nameLabel = new JLabel(name, 0);
        namePane.add(nameLabel);
        if (showBuilding) {
            String buildingName = process.getWorkshop().getBuilding().getName();
            JLabel buildingNameLabel = new JLabel(buildingName, 0);
            this.add(buildingNameLabel);
        }
        JPanel workPane = new JPanel(new FlowLayout(1, 0, 0));
        this.add(workPane);
        JLabel workLabel = new JLabel("Work: ", 2);
        workPane.add(workLabel);
        JProgressBar workBar = new JProgressBar();
        this.workBarModel = workBar.getModel();
        workBar.setStringPainted(true);
        workPane.add(workBar);
        JPanel timePane = new JPanel(new FlowLayout(1, 0, 0));
        this.add(timePane);
        JLabel timeLabel = new JLabel("Time: ", 2);
        timePane.add(timeLabel);
        JProgressBar timeBar = new JProgressBar();
        this.timeBarModel = timeBar.getModel();
        timeBar.setStringPainted(true);
        timePane.add(timeBar);
        this.update();
        this.setToolTipText(ManufacturePanel.getToolTipString(process.getInfo(), process.getWorkshop().getBuilding()));
    }

    public void update() {
        double workTimeRequired = this.process.getInfo().getWorkTimeRequired();
        double workTimeRemaining = this.process.getWorkTimeRemaining();
        int workProgress = 100;
        if (workTimeRequired > 0.0) {
            workProgress = (int)(100.0 * (workTimeRequired - workTimeRemaining) / workTimeRequired);
        }
        this.workBarModel.setValue(workProgress);
        double timeRequired = this.process.getInfo().getProcessTimeRequired();
        double timeRemaining = this.process.getProcessTimeRemaining();
        int timeProgress = 100;
        if (timeRequired > 0.0) {
            timeProgress = (int)(100.0 * (timeRequired - timeRemaining) / timeRequired);
        }
        this.timeBarModel.setValue(timeProgress);
    }

    public ManufactureProcess getManufactureProcess() {
        return this.process;
    }

    public static String getToolTipString(ManufactureProcessInfo info, Building building) {
        StringBuilder result = new StringBuilder("<html>");
        result.append("Manufacturing Process: ").append(info.getName()).append("<br>");
        if (building != null) {
            result.append("Manufacture Building: ").append(building.getName()).append("<br>");
        }
        result.append("Effort Time Required: ").append(info.getWorkTimeRequired()).append(" millisols<br>");
        result.append("Process Time Required: ").append(info.getProcessTimeRequired()).append(" millisols<br>");
        result.append("Power Required: ").append(info.getPowerRequired()).append(" kW<br>");
        result.append("Building Tech Level Required: ").append(info.getTechLevelRequired()).append("<br>");
        result.append("Materials Science Skill Level Required: ").append(info.getSkillLevelRequired()).append("<br>");
        result.append("Process Inputs:<br>");
        for (ManufactureProcessItem item : info.getInputList()) {
            result.append("&nbsp;&nbsp;").append(item.getName()).append(": ").append(ManufacturePanel.getItemAmountString(item)).append("<br>");
        }
        result.append("Process Outputs:<br>");
        for (ManufactureProcessItem item : info.getOutputList()) {
            result.append("&nbsp;&nbsp;").append(item.getName()).append(": ").append(ManufacturePanel.getItemAmountString(item)).append("<br>");
        }
        result.append("</html>");
        return result.toString();
    }

    private static String getItemAmountString(ManufactureProcessItem item) {
        String result = "";
        result = "resource".equals(item.getType()) ? item.getAmount() + " kg" : Integer.toString((int)item.getAmount());
        return result;
    }
}

