/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.manufacture.ManufactureProcess;
import org.mars_sim.msp.core.manufacture.ManufactureProcessInfo;
import org.mars_sim.msp.core.manufacture.ManufactureUtil;
import org.mars_sim.msp.core.manufacture.SalvageProcess;
import org.mars_sim.msp.core.manufacture.SalvageProcessInfo;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.Manufacture;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.ManufacturePanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.SalvagePanel;

public class ManufactureTabPanel
extends TabPanel {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.unit_window.structure.ManufactureTabPanel";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private Settlement settlement;
    private JPanel manufactureListPane;
    private JScrollPane manufactureScrollPane;
    private List<ManufactureProcess> processCache;
    private List<SalvageProcess> salvageCache;
    private JComboBox buildingSelection;
    private Vector<Building> buildingSelectionCache;
    private JComboBox processSelection;
    private Vector<ManufactureProcessInfo> processSelectionCache;
    private Vector<SalvageProcessInfo> salvageSelectionCache;
    private JButton newProcessButton;
    private JCheckBox overrideCheckbox;

    public ManufactureTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Manu", null, "Manufacturing", unit, desktop);
        this.settlement = (Settlement)unit;
        this.setHorizontalScrollBarPolicy(31);
        JPanel topPane = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(topPane);
        JLabel manufactureLabel = new JLabel("Manufacturing", 0);
        topPane.add(manufactureLabel);
        this.manufactureScrollPane = new JScrollPane();
        this.manufactureScrollPane.setHorizontalScrollBarPolicy(31);
        this.manufactureScrollPane.setPreferredSize(new Dimension(220, 215));
        this.topContentPanel.add(this.manufactureScrollPane);
        JPanel manufactureOuterListPane = new JPanel(new BorderLayout(0, 0));
        manufactureOuterListPane.setBorder(new MarsPanelBorder());
        this.manufactureScrollPane.setViewportView(manufactureOuterListPane);
        this.manufactureListPane = new JPanel();
        this.manufactureListPane.setLayout(new BoxLayout(this.manufactureListPane, 1));
        manufactureOuterListPane.add((Component)this.manufactureListPane, "North");
        this.processCache = this.getManufactureProcesses();
        Iterator<ManufactureProcess> i = this.processCache.iterator();
        while (i.hasNext()) {
            this.manufactureListPane.add(new ManufacturePanel(i.next(), true, 30));
        }
        this.salvageCache = new ArrayList<SalvageProcess>(this.getSalvageProcesses());
        Iterator<SalvageProcess> j = this.salvageCache.iterator();
        while (j.hasNext()) {
            this.manufactureListPane.add(new SalvagePanel(j.next(), true, 30));
        }
        JPanel interactionPanel = new JPanel(new GridLayout(4, 1, 0, 0));
        this.topContentPanel.add(interactionPanel);
        this.buildingSelectionCache = this.getManufacturingBuildings();
        this.buildingSelection = new JComboBox<Building>(this.buildingSelectionCache);
        this.buildingSelection.setToolTipText("Select a manufacturing building");
        this.buildingSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ManufactureTabPanel.this.update();
            }
        });
        interactionPanel.add(this.buildingSelection);
        Building workshopBuilding = (Building)this.buildingSelection.getSelectedItem();
        this.processSelectionCache = this.getAvailableProcesses(workshopBuilding);
        this.processSelection = new JComboBox<ManufactureProcessInfo>(this.processSelectionCache);
        this.processSelection.setRenderer(new ManufactureSelectionListCellRenderer());
        this.processSelection.setToolTipText("Select an available manufacturing process");
        interactionPanel.add(this.processSelection);
        this.salvageSelectionCache = this.getAvailableSalvageProcesses(workshopBuilding);
        Iterator<SalvageProcessInfo> k = this.salvageSelectionCache.iterator();
        while (k.hasNext()) {
            this.processSelection.addItem(k.next());
        }
        this.newProcessButton = new JButton("Create New Process");
        this.newProcessButton.setEnabled(this.processSelection.getItemCount() > 0);
        this.newProcessButton.setToolTipText("Create a new manufacturing or salvage process");
        this.newProcessButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Building workshopBuilding = (Building)ManufactureTabPanel.this.buildingSelection.getSelectedItem();
                    if (workshopBuilding != null) {
                        Manufacture workshop = (Manufacture)workshopBuilding.getFunction("Manufacture");
                        Object selectedItem = ManufactureTabPanel.this.processSelection.getSelectedItem();
                        if (selectedItem != null) {
                            SalvageProcessInfo selectedSalvage;
                            if (selectedItem instanceof ManufactureProcessInfo) {
                                ManufactureProcessInfo selectedProcess = (ManufactureProcessInfo)selectedItem;
                                if (ManufactureUtil.canProcessBeStarted((ManufactureProcessInfo)selectedProcess, (Manufacture)workshop)) {
                                    workshop.addProcess(new ManufactureProcess(selectedProcess, workshop));
                                    ManufactureTabPanel.this.update();
                                }
                            } else if (selectedItem instanceof SalvageProcessInfo && ManufactureUtil.canSalvageProcessBeStarted((SalvageProcessInfo)(selectedSalvage = (SalvageProcessInfo)selectedItem), (Manufacture)workshop)) {
                                Unit salvagedUnit = ManufactureUtil.findUnitForSalvage((SalvageProcessInfo)selectedSalvage, (Settlement)ManufactureTabPanel.this.settlement);
                                workshop.addSalvageProcess(new SalvageProcess(selectedSalvage, workshop, salvagedUnit));
                                ManufactureTabPanel.this.update();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "new process button", e);
                }
            }
        });
        interactionPanel.add(this.newProcessButton);
        this.overrideCheckbox = new JCheckBox("Override manufacturing");
        this.overrideCheckbox.setToolTipText("Prevents settlement inhabitants from starting new manufacturing or salvage processes.");
        this.overrideCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ManufactureTabPanel.this.setManufactureOverride(ManufactureTabPanel.this.overrideCheckbox.isSelected());
            }
        });
        this.overrideCheckbox.setSelected(this.settlement.getManufactureOverride());
        interactionPanel.add(this.overrideCheckbox);
    }

    @Override
    public void update() {
        List<ManufactureProcess> processes = this.getManufactureProcesses();
        List<SalvageProcess> salvages = this.getSalvageProcesses();
        if (!this.processCache.equals(processes) || !this.salvageCache.equals(salvages)) {
            for (ManufactureProcess process : processes) {
                if (this.processCache.contains(process)) continue;
                this.manufactureListPane.add(new ManufacturePanel(process, true, 30));
            }
            for (SalvageProcess salvage : salvages) {
                if (this.salvageCache.contains(salvage)) continue;
                this.manufactureListPane.add(new SalvagePanel(salvage, true, 23));
            }
            for (ManufactureProcess process : this.processCache) {
                ManufacturePanel panel;
                if (processes.contains(process) || (panel = this.getManufacturePanel(process)) == null) continue;
                this.manufactureListPane.remove(panel);
            }
            for (SalvageProcess salvage : this.salvageCache) {
                SalvagePanel panel;
                if (salvages.contains(salvage) || (panel = this.getSalvagePanel(salvage)) == null) continue;
                this.manufactureListPane.remove(panel);
            }
            this.manufactureScrollPane.validate();
            this.processCache.clear();
            this.processCache.addAll(processes);
            this.salvageCache.clear();
            this.salvageCache.addAll(salvages);
        }
        Iterator<ManufactureProcess> i = processes.iterator();
        while (i.hasNext()) {
            ManufacturePanel panel = this.getManufacturePanel(i.next());
            if (panel == null) continue;
            panel.update();
        }
        Iterator<SalvageProcess> j = salvages.iterator();
        while (j.hasNext()) {
            SalvagePanel panel = this.getSalvagePanel(j.next());
            if (panel == null) continue;
            panel.update();
        }
        Vector<Building> newBuildings = this.getManufacturingBuildings();
        if (!newBuildings.equals(this.buildingSelectionCache)) {
            this.buildingSelectionCache = newBuildings;
            Building currentSelection = (Building)this.buildingSelection.getSelectedItem();
            this.buildingSelection.removeAllItems();
            Iterator<Building> k = this.buildingSelectionCache.iterator();
            while (k.hasNext()) {
                this.buildingSelection.addItem(k.next());
            }
            if (currentSelection != null && this.buildingSelectionCache.contains(currentSelection)) {
                this.buildingSelection.setSelectedItem(currentSelection);
            }
        }
        Building selectedBuilding = (Building)this.buildingSelection.getSelectedItem();
        Vector<ManufactureProcessInfo> newProcesses = this.getAvailableProcesses(selectedBuilding);
        Vector<SalvageProcessInfo> newSalvages = this.getAvailableSalvageProcesses(selectedBuilding);
        if (!newProcesses.equals(this.processSelectionCache) || !newSalvages.equals(this.salvageSelectionCache)) {
            this.processSelectionCache = newProcesses;
            this.salvageSelectionCache = newSalvages;
            Object currentSelection = this.processSelection.getSelectedItem();
            this.processSelection.removeAllItems();
            Iterator<ManufactureProcessInfo> l = this.processSelectionCache.iterator();
            while (l.hasNext()) {
                this.processSelection.addItem(l.next());
            }
            Iterator<SalvageProcessInfo> m = this.salvageSelectionCache.iterator();
            while (m.hasNext()) {
                this.processSelection.addItem(m.next());
            }
            if (currentSelection != null && this.processSelectionCache.contains(currentSelection)) {
                this.processSelection.setSelectedItem(currentSelection);
            }
        }
        this.newProcessButton.setEnabled(this.processSelection.getItemCount() > 0);
        if (this.settlement.getManufactureOverride() != this.overrideCheckbox.isSelected()) {
            this.overrideCheckbox.setSelected(this.settlement.getManufactureOverride());
        }
    }

    private List<ManufactureProcess> getManufactureProcesses() {
        ArrayList<ManufactureProcess> result = new ArrayList<ManufactureProcess>();
        Iterator i = this.settlement.getBuildingManager().getBuildings("Manufacture").iterator();
        while (i.hasNext()) {
            Manufacture workshop = (Manufacture)((Building)i.next()).getFunction("Manufacture");
            result.addAll(workshop.getProcesses());
        }
        return result;
    }

    private List<SalvageProcess> getSalvageProcesses() {
        ArrayList<SalvageProcess> result = new ArrayList<SalvageProcess>();
        Iterator i = this.settlement.getBuildingManager().getBuildings("Manufacture").iterator();
        while (i.hasNext()) {
            Manufacture workshop = (Manufacture)((Building)i.next()).getFunction("Manufacture");
            result.addAll(workshop.getSalvageProcesses());
        }
        return result;
    }

    private ManufacturePanel getManufacturePanel(ManufactureProcess process) {
        ManufacturePanel result = null;
        for (int x = 0; x < this.manufactureListPane.getComponentCount(); ++x) {
            ManufacturePanel panel;
            Component component = this.manufactureListPane.getComponent(x);
            if (!(component instanceof ManufacturePanel) || !(panel = (ManufacturePanel)component).getManufactureProcess().equals(process)) continue;
            result = panel;
        }
        return result;
    }

    private SalvagePanel getSalvagePanel(SalvageProcess process) {
        SalvagePanel result = null;
        for (int x = 0; x < this.manufactureListPane.getComponentCount(); ++x) {
            SalvagePanel panel;
            Component component = this.manufactureListPane.getComponent(x);
            if (!(component instanceof SalvagePanel) || !(panel = (SalvagePanel)component).getSalvageProcess().equals(process)) continue;
            result = panel;
        }
        return result;
    }

    private Vector<Building> getManufacturingBuildings() {
        return new Vector<Building>(this.settlement.getBuildingManager().getBuildings("Manufacture"));
    }

    private Vector<ManufactureProcessInfo> getAvailableProcesses(Building manufactureBuilding) {
        Vector<ManufactureProcessInfo> result = new Vector<ManufactureProcessInfo>();
        try {
            Manufacture workshop;
            if (manufactureBuilding != null && (workshop = (Manufacture)manufactureBuilding.getFunction("Manufacture")).getProcesses().size() < workshop.getConcurrentProcesses()) {
                for (ManufactureProcessInfo process : ManufactureUtil.getManufactureProcessesForTechLevel((int)workshop.getTechLevel())) {
                    if (!ManufactureUtil.canProcessBeStarted((ManufactureProcessInfo)process, (Manufacture)workshop)) continue;
                    result.add(process);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private Vector<SalvageProcessInfo> getAvailableSalvageProcesses(Building manufactureBuilding) {
        Vector<SalvageProcessInfo> result = new Vector<SalvageProcessInfo>();
        try {
            Manufacture workshop;
            if (manufactureBuilding != null && (workshop = (Manufacture)manufactureBuilding.getFunction("Manufacture")).getProcesses().size() < workshop.getConcurrentProcesses()) {
                for (SalvageProcessInfo process : Collections.unmodifiableList(ManufactureUtil.getSalvageProcessesForTechLevel((int)workshop.getTechLevel()))) {
                    if (!ManufactureUtil.canSalvageProcessBeStarted((SalvageProcessInfo)process, (Manufacture)workshop)) continue;
                    result.add(process);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void setManufactureOverride(boolean override) {
        this.settlement.setManufactureOverride(override);
    }

    private static class ManufactureSelectionListCellRenderer
    extends DefaultListCellRenderer {
        private ManufactureSelectionListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SalvageProcessInfo info;
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ManufactureProcessInfo) {
                ManufactureProcessInfo info2 = (ManufactureProcessInfo)value;
                if (info2 != null) {
                    String processName = info2.getName();
                    if (processName.length() > 35) {
                        processName = processName.substring(0, 35) + "...";
                    }
                    ((JLabel)result).setText(processName);
                    ((JComponent)result).setToolTipText(ManufacturePanel.getToolTipString(info2, null));
                }
            } else if (value instanceof SalvageProcessInfo && (info = (SalvageProcessInfo)value) != null) {
                String processName = info.toString();
                if (processName.length() > 35) {
                    processName = processName.substring(0, 35) + "...";
                }
                ((JLabel)result).setText(processName);
                ((JComponent)result).setToolTipText(SalvagePanel.getToolTipString(null, info, null));
            }
            return result;
        }
    }
}

