/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.MissionWindow;
import org.mars_sim.msp.ui.swing.tool.monitor.PersonTableModel;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class MissionTabPanel
extends TabPanel {
    private Settlement settlement;
    private List<Mission> missionsCache;
    private DefaultListModel missionListModel;
    private JList missionList;
    private JButton missionButton;
    private JButton monitorButton;
    private JCheckBox overrideCheckbox;

    public MissionTabPanel(Settlement settlement, MainDesktopPane desktop) {
        super("Mission", null, "Settlement Missions", (Unit)settlement, desktop);
        this.settlement = settlement;
        JPanel labelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(labelPanel);
        JLabel settlementMissionsLabel = new JLabel("Settlement Missions", 0);
        labelPanel.add(settlementMissionsLabel);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add((Component)centerPanel, "Center");
        JPanel missionListPanel = new JPanel();
        centerPanel.add((Component)missionListPanel, "Center");
        JScrollPane missionScrollPanel = new JScrollPane();
        missionScrollPanel.setPreferredSize(new Dimension(190, 220));
        missionListPanel.add(missionScrollPanel);
        this.missionListModel = new DefaultListModel();
        MissionManager manager = Simulation.instance().getMissionManager();
        this.missionsCache = manager.getMissionsForSettlement(settlement);
        Iterator<Mission> i = this.missionsCache.iterator();
        while (i.hasNext()) {
            this.missionListModel.addElement(i.next());
        }
        this.missionList = new JList(this.missionListModel);
        this.missionList.setSelectionMode(0);
        this.missionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean missionSelected = !MissionTabPanel.this.missionList.isSelectionEmpty();
                MissionTabPanel.this.missionButton.setEnabled(missionSelected);
                MissionTabPanel.this.monitorButton.setEnabled(missionSelected);
            }
        });
        missionScrollPanel.setViewportView(this.missionList);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        centerPanel.add((Component)buttonPanel, "East");
        JPanel innerButtonPanel = new JPanel(new GridLayout(2, 1, 0, 2));
        buttonPanel.add((Component)innerButtonPanel, "North");
        this.missionButton = new JButton(ImageLoader.getIcon("Mission"));
        this.missionButton.setMargin(new Insets(1, 1, 1, 1));
        this.missionButton.setToolTipText("Open mission in mission tool.");
        this.missionButton.setEnabled(false);
        this.missionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MissionTabPanel.this.openMissionTool();
            }
        });
        innerButtonPanel.add(this.missionButton);
        this.monitorButton = new JButton(ImageLoader.getIcon("Monitor"));
        this.monitorButton.setMargin(new Insets(1, 1, 1, 1));
        this.monitorButton.setToolTipText("Open tab in monitor tool for this mission.");
        this.monitorButton.setEnabled(false);
        this.monitorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MissionTabPanel.this.openMonitorTool();
            }
        });
        innerButtonPanel.add(this.monitorButton);
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        bottomPanel.setBorder(new MarsPanelBorder());
        this.centerContentPanel.add((Component)bottomPanel, "South");
        this.overrideCheckbox = new JCheckBox("Override new mission creation");
        this.overrideCheckbox.setToolTipText("Prevents settlement inhabitants from starting new missions.");
        this.overrideCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MissionTabPanel.this.setMissionCreationOverride(MissionTabPanel.this.overrideCheckbox.isSelected());
            }
        });
        this.overrideCheckbox.setSelected(settlement.getMissionCreationOverride());
        bottomPanel.add(this.overrideCheckbox);
    }

    @Override
    public void update() {
        MissionManager manager = Simulation.instance().getMissionManager();
        List missions = manager.getMissionsForSettlement(this.settlement);
        if (!missions.equals(this.missionsCache)) {
            Mission selectedMission = (Mission)this.missionList.getSelectedValue();
            this.missionsCache = missions;
            this.missionListModel.clear();
            Iterator<Mission> i = this.missionsCache.iterator();
            while (i.hasNext()) {
                this.missionListModel.addElement(i.next());
            }
            if (selectedMission != null && this.missionListModel.contains(selectedMission)) {
                this.missionList.setSelectedValue(selectedMission, true);
            }
        }
        if (this.settlement.getMissionCreationOverride() != this.overrideCheckbox.isSelected()) {
            this.overrideCheckbox.setSelected(this.settlement.getMissionCreationOverride());
        }
    }

    private void openMissionTool() {
        Mission mission = (Mission)this.missionList.getSelectedValue();
        if (mission != null) {
            ((MissionWindow)this.getDesktop().getToolWindow("Mission Tool")).selectMission(mission);
            this.getDesktop().openToolWindow("Mission Tool");
        }
    }

    private void openMonitorTool() {
        Mission mission = (Mission)this.missionList.getSelectedValue();
        if (mission != null) {
            this.getDesktop().addModel(new PersonTableModel(mission));
        }
    }

    private void setMissionCreationOverride(boolean override) {
        this.settlement.setMissionCreationOverride(override);
    }
}

