/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.collections.CollectionUtils;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.monitor.PersonTableModel;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class PopulationTabPanel
extends TabPanel
implements MouseListener,
ActionListener {
    private JLabel populationNumLabel;
    private JLabel populationCapLabel;
    private DefaultListModel populationListModel;
    private JList populationList;
    private Collection<Person> populationCache;
    private int populationNumCache;
    private int populationCapacityCache;

    public PopulationTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Population", null, "Population of the settlement", unit, desktop);
        Settlement settlement = (Settlement)unit;
        JPanel populationCountPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        populationCountPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(populationCountPanel);
        this.populationNumCache = settlement.getCurrentPopulationNum();
        this.populationNumLabel = new JLabel("Population: " + this.populationNumCache, 0);
        populationCountPanel.add(this.populationNumLabel);
        this.populationCapacityCache = settlement.getPopulationCapacity();
        this.populationCapLabel = new JLabel("Population Capacity: " + this.populationCapacityCache, 0);
        populationCountPanel.add(this.populationCapLabel);
        JPanel populationDisplayPanel = new JPanel(new FlowLayout(0));
        populationDisplayPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(populationDisplayPanel);
        JScrollPane populationScrollPanel = new JScrollPane();
        populationScrollPanel.setPreferredSize(new Dimension(175, 250));
        populationDisplayPanel.add(populationScrollPanel);
        this.populationListModel = new DefaultListModel();
        this.populationCache = settlement.getInhabitants();
        Iterator<Person> i = this.populationCache.iterator();
        while (i.hasNext()) {
            this.populationListModel.addElement(i.next());
        }
        this.populationList = new JList(this.populationListModel);
        this.populationList.addMouseListener(this);
        populationScrollPanel.setViewportView(this.populationList);
        JButton monitorButton = new JButton(ImageLoader.getIcon("Monitor"));
        monitorButton.setMargin(new Insets(1, 1, 1, 1));
        monitorButton.addActionListener(this);
        monitorButton.setToolTipText("Open tab in monitor tool");
        populationDisplayPanel.add(monitorButton);
    }

    @Override
    public void update() {
        Settlement settlement = (Settlement)this.unit;
        if (this.populationNumCache != settlement.getCurrentPopulationNum()) {
            this.populationNumCache = settlement.getCurrentPopulationNum();
            this.populationNumLabel.setText("Population: " + this.populationNumCache);
        }
        if (this.populationCapacityCache != settlement.getPopulationCapacity()) {
            this.populationCapacityCache = settlement.getPopulationCapacity();
            this.populationCapLabel.setText("Population Capacity: " + this.populationCapacityCache);
        }
        if (!CollectionUtils.isEqualCollection(this.populationCache, (Collection)settlement.getInhabitants())) {
            this.populationCache = settlement.getInhabitants();
            this.populationListModel.clear();
            Iterator<Person> i = this.populationCache.iterator();
            while (i.hasNext()) {
                this.populationListModel.addElement(i.next());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.desktop.addModel(new PersonTableModel((Settlement)this.unit, false));
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Person person;
        if (event.getClickCount() >= 2 && (person = (Person)this.populationList.getSelectedValue()) != null) {
            this.desktop.openUnitWindow((Unit)person, false);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

