/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.ResourceProcess;
import org.mars_sim.msp.core.structure.building.function.ResourceProcessing;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class ResourceProcessesTabPanel
extends TabPanel {
    private List<Building> processingBuildings;
    private JScrollPane processesScrollPanel;
    private JPanel processListPanel;
    private JCheckBox overrideCheckbox;

    public ResourceProcessesTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Processes", null, "Resource Processes", unit, desktop);
        Settlement settlement = (Settlement)unit;
        this.processingBuildings = settlement.getBuildingManager().getBuildings("Resource Processing");
        JPanel resourceProcessesLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(resourceProcessesLabelPanel);
        JLabel resourceProcessesLabel = new JLabel("Resource Processes", 0);
        resourceProcessesLabelPanel.add(resourceProcessesLabel);
        this.processesScrollPanel = new JScrollPane();
        this.processesScrollPanel.setPreferredSize(new Dimension(220, 280));
        this.topContentPanel.add(this.processesScrollPanel);
        this.processListPanel = new JPanel(new GridLayout(0, 1, 5, 2));
        this.processListPanel.setBorder(new MarsPanelBorder());
        this.processesScrollPanel.setViewportView(this.processListPanel);
        this.populateProcessList();
        JPanel overrideCheckboxPane = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(overrideCheckboxPane);
        this.overrideCheckbox = new JCheckBox("Override resource process toggling");
        this.overrideCheckbox.setToolTipText("Prevents settlement inhabitants from toggling on/off resource processes.");
        this.overrideCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ResourceProcessesTabPanel.this.setResourceProcessOverride(ResourceProcessesTabPanel.this.overrideCheckbox.isSelected());
            }
        });
        this.overrideCheckbox.setSelected(settlement.getManufactureOverride());
        overrideCheckboxPane.add(this.overrideCheckbox);
    }

    private void populateProcessList() {
        this.processListPanel.removeAll();
        for (Building building : this.processingBuildings) {
            ResourceProcessing processing = (ResourceProcessing)building.getFunction("Resource Processing");
            for (ResourceProcess process : processing.getProcesses()) {
                this.processListPanel.add(new ResourceProcessPanel(process, building));
            }
        }
    }

    @Override
    public void update() {
        Settlement settlement = (Settlement)this.unit;
        List tempBuildings = settlement.getBuildingManager().getBuildings("Resource Processing");
        if (!tempBuildings.equals(this.processingBuildings)) {
            this.processingBuildings = tempBuildings;
            this.populateProcessList();
            this.processesScrollPanel.validate();
        } else {
            Component[] components;
            for (Component component : components = this.processListPanel.getComponents()) {
                ResourceProcessPanel panel = (ResourceProcessPanel)component;
                panel.update();
            }
        }
    }

    private void setResourceProcessOverride(boolean override) {
        Settlement settlement = (Settlement)this.unit;
        settlement.setResourceProcessOverride(override);
    }

    private static class ResourceProcessPanel
    extends JPanel {
        private ResourceProcess process;
        private JLabel label;
        private JButton toggleButton;
        private ImageIcon greenDot;
        private ImageIcon redDot;
        private DecimalFormat decFormatter = new DecimalFormat("0.00");

        ResourceProcessPanel(ResourceProcess process, Building building) {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.process = process;
            this.toggleButton = new JButton();
            this.toggleButton.setMargin(new Insets(0, 0, 0, 0));
            this.toggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ResourceProcess process;
                    process.setProcessRunning(!(process = ResourceProcessPanel.this.getProcess()).isProcessRunning());
                    ResourceProcessPanel.this.update();
                }
            });
            this.toggleButton.setToolTipText("Toggle process on/off");
            this.add(this.toggleButton);
            this.label = new JLabel(" " + building.getName() + ": " + process.getProcessName());
            this.add(this.label);
            this.greenDot = ImageLoader.getIcon("GreenDot");
            this.redDot = ImageLoader.getIcon("RedDot");
            if (process.isProcessRunning()) {
                this.toggleButton.setIcon(this.greenDot);
            } else {
                this.toggleButton.setIcon(this.redDot);
            }
            this.setToolTipText(this.getToolTipString(building));
        }

        private String getToolTipString(Building building) {
            StringBuilder result = new StringBuilder("<html>");
            result.append("Resource Process: ").append(this.process.getProcessName()).append("<br>");
            result.append("Building: ").append(building.getName()).append("<br>");
            result.append("Power Required: ").append(this.decFormatter.format(this.process.getPowerRequired())).append(" kW<br>");
            result.append("Process Inputs:<br>");
            for (AmountResource resource : this.process.getInputResources()) {
                double rate = this.process.getMaxInputResourceRate(resource) * 1000.0;
                String rateString = this.decFormatter.format(rate);
                result.append("&nbsp;&nbsp;");
                if (this.process.isAmbientInputResource(resource)) {
                    result.append("* ");
                }
                result.append(resource.getName()).append(": ").append(rateString).append(" kg/sol<br>");
            }
            result.append("Process Outputs:<br>");
            for (AmountResource resource : this.process.getOutputResources()) {
                double rate = this.process.getMaxOutputResourceRate(resource) * 1000.0;
                String rateString = this.decFormatter.format(rate);
                result.append("&nbsp;&nbsp;").append(resource.getName()).append(": ").append(rateString).append(" kg/sol<br>");
            }
            result.append("</html>");
            return result.toString();
        }

        void update() {
            if (this.process.isProcessRunning()) {
                this.toggleButton.setIcon(this.greenDot);
            } else {
                this.toggleButton.setIcon(this.redDot);
            }
        }

        private ResourceProcess getProcess() {
            return this.process;
        }
    }
}

