/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.mars_sim.msp.core.manufacture.PartSalvage;
import org.mars_sim.msp.core.manufacture.SalvageProcess;
import org.mars_sim.msp.core.manufacture.SalvageProcessInfo;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;

public class SalvagePanel
extends JPanel {
    private SalvageProcess process;
    private BoundedRangeModel workBarModel;

    public SalvagePanel(SalvageProcess process, boolean showBuilding, int processStringWidth) {
        this.process = process;
        if (showBuilding) {
            this.setLayout(new GridLayout(3, 1, 0, 0));
        } else {
            this.setLayout(new GridLayout(2, 1, 0, 0));
        }
        this.setBorder(new MarsPanelBorder());
        JPanel namePane = new JPanel(new FlowLayout(0, 1, 0));
        this.add(namePane);
        JButton cancelButton = new JButton(ImageLoader.getIcon("CancelSmall"));
        cancelButton.setMargin(new Insets(0, 0, 0, 0));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SalvagePanel.this.getSalvageProcess().getWorkshop().endSalvageProcess(SalvagePanel.this.getSalvageProcess(), true);
            }
        });
        cancelButton.setToolTipText("Cancel salvage process");
        namePane.add(cancelButton);
        String name = process.toString() + ": " + process.getSalvagedUnit().getName();
        if (name.length() > 0) {
            String firstLetter = name.substring(0, 1).toUpperCase();
            name = " " + firstLetter + name.substring(1);
        }
        if (name.length() > processStringWidth) {
            name = name.substring(0, processStringWidth) + "...";
        }
        JLabel nameLabel = new JLabel(name, 0);
        namePane.add(nameLabel);
        if (showBuilding) {
            String buildingName = process.getWorkshop().getBuilding().getName();
            JLabel buildingNameLabel = new JLabel(buildingName, 0);
            this.add(buildingNameLabel);
        }
        JPanel workPane = new JPanel(new FlowLayout(1, 0, 0));
        this.add(workPane);
        JLabel workLabel = new JLabel("Work: ", 2);
        workPane.add(workLabel);
        JProgressBar workBar = new JProgressBar();
        this.workBarModel = workBar.getModel();
        workBar.setStringPainted(true);
        workPane.add(workBar);
        this.update();
        this.setToolTipText(SalvagePanel.getToolTipString(process, process.getInfo(), process.getWorkshop().getBuilding()));
    }

    public void update() {
        double workTimeRequired = this.process.getInfo().getWorkTimeRequired();
        double workTimeRemaining = this.process.getWorkTimeRemaining();
        int workProgress = 100;
        if (workTimeRequired > 0.0) {
            workProgress = (int)(100.0 * (workTimeRequired - workTimeRemaining) / workTimeRequired);
        }
        this.workBarModel.setValue(workProgress);
    }

    public SalvageProcess getSalvageProcess() {
        return this.process;
    }

    public static String getToolTipString(SalvageProcess process, SalvageProcessInfo processInfo, Building building) {
        StringBuilder result = new StringBuilder("<html>");
        result.append("Salvage Process: ").append(processInfo.toString()).append("<br>");
        if (building != null) {
            result.append("Manufacture Building: ").append(building.getName()).append("<br>");
        }
        result.append("Effort Time Required: ").append(processInfo.getWorkTimeRequired()).append(" millisols<br>");
        result.append("Building Tech Level Required: ").append(processInfo.getTechLevelRequired()).append("<br>");
        result.append("Materials Science Skill Level Required: ").append(processInfo.getSkillLevelRequired()).append("<br>");
        if (process != null) {
            result.append("Salvaged Item: ").append(process.getSalvagedUnit().getName()).append("<br>");
        } else {
            result.append("Salvaged Item Type: ").append(processInfo.getItemName()).append("<br>");
        }
        result.append("Possible Parts Returned:<br>");
        for (PartSalvage partSalvage : processInfo.getPartSalvageList()) {
            result.append("&nbsp;&nbsp;").append(partSalvage.getName()).append(": ").append(partSalvage.getNumber()).append("<br>");
        }
        result.append("</html>");
        return result.toString();
    }
}

