/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.collections.CollectionUtils;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class VehicleTabPanel
extends TabPanel
implements MouseListener {
    private DefaultListModel vehicleListModel;
    private JList vehicleList;
    private Collection<Vehicle> vehicleCache;

    public VehicleTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Vehicles", null, "Vehicles parked at the settlement", unit, desktop);
        Settlement settlement = (Settlement)unit;
        JPanel vehicleLabelPanel = new JPanel(new FlowLayout(1));
        this.topContentPanel.add(vehicleLabelPanel);
        JLabel vehicleLabel = new JLabel("Parked Vehicles", 0);
        vehicleLabelPanel.add(vehicleLabel);
        JPanel vehicleDisplayPanel = new JPanel(new FlowLayout(1));
        vehicleDisplayPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(vehicleDisplayPanel);
        JScrollPane vehicleScrollPanel = new JScrollPane();
        vehicleScrollPanel.setPreferredSize(new Dimension(175, 200));
        vehicleDisplayPanel.add(vehicleScrollPanel);
        this.vehicleListModel = new DefaultListModel();
        this.vehicleCache = settlement.getParkedVehicles();
        Iterator<Vehicle> i = this.vehicleCache.iterator();
        while (i.hasNext()) {
            this.vehicleListModel.addElement(i.next());
        }
        this.vehicleList = new JList(this.vehicleListModel);
        this.vehicleList.addMouseListener(this);
        vehicleScrollPanel.setViewportView(this.vehicleList);
    }

    @Override
    public void update() {
        Settlement settlement = (Settlement)this.unit;
        if (!CollectionUtils.isEqualCollection(this.vehicleCache, (Collection)settlement.getParkedVehicles())) {
            this.vehicleCache = new ArrayList<Vehicle>(settlement.getParkedVehicles());
            this.vehicleListModel.clear();
            Iterator<Vehicle> i = this.vehicleCache.iterator();
            while (i.hasNext()) {
                this.vehicleListModel.addElement(i.next());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Vehicle vehicle;
        if (event.getClickCount() >= 2 && (vehicle = (Vehicle)this.vehicleList.getSelectedValue()) != null) {
            this.desktop.openUnitWindow((Unit)vehicle, false);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

