/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.structure.building.function.AstronomicalObservation;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class AstronomicalObservationBuildingPanel
extends BuildingFunctionPanel {
    private int currentObserversAmount;
    private AstronomicalObservation function;
    private JLabel observersLabel;

    public AstronomicalObservationBuildingPanel(AstronomicalObservation observatory, MainDesktopPane desktop) {
        super(observatory.getBuilding(), desktop);
        this.setLayout(new BorderLayout());
        this.function = observatory;
        this.currentObserversAmount = this.function.getObserverNum();
        JPanel labelPanel = new JPanel(new GridLayout(4, 1, 0, 0));
        this.add((Component)labelPanel, "North");
        JLabel astronomyLabel = new JLabel("Astronomy Observation", 0);
        labelPanel.add(astronomyLabel);
        this.observersLabel = new JLabel("Number of Observers: " + this.currentObserversAmount, 0);
        labelPanel.add(this.observersLabel);
        JLabel observerCapacityLabel = new JLabel("Observer Capacity: " + this.function.getObservatoryCapacity(), 0);
        labelPanel.add(observerCapacityLabel);
    }

    @Override
    public void update() {
        if (this.currentObserversAmount != this.function.getObserverNum()) {
            this.currentObserversAmount = this.function.getObserverNum();
            this.observersLabel.setText("Number of Observers: " + this.currentObserversAmount);
        }
    }
}

