/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.AstronomicalObservation;
import org.mars_sim.msp.core.structure.building.function.Cooking;
import org.mars_sim.msp.core.structure.building.function.Farming;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;
import org.mars_sim.msp.core.structure.building.function.Manufacture;
import org.mars_sim.msp.core.structure.building.function.MedicalCare;
import org.mars_sim.msp.core.structure.building.function.PowerStorage;
import org.mars_sim.msp.core.structure.building.function.Research;
import org.mars_sim.msp.core.structure.building.function.ResourceProcessing;
import org.mars_sim.msp.core.structure.building.function.Storage;
import org.mars_sim.msp.core.structure.building.function.VehicleMaintenance;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.AstronomicalObservationBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.CookingBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.FarmingBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.InhabitableBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.MaintenanceBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.MalfunctionableBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.ManufactureBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.MedicalCareBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.PowerBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.PowerStorageBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.ResearchBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.ResourceProcessingBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.StorageBuildingPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.VehicleMaintenanceBuildingPanel;

public class BuildingPanel
extends JPanel {
    private String panelName;
    private Building building;
    private List<BuildingFunctionPanel> functionPanels;

    public BuildingPanel(String panelName, Building building, MainDesktopPane desktop) {
        PowerStorage storage;
        this.panelName = panelName;
        this.building = building;
        this.functionPanels = new ArrayList<BuildingFunctionPanel>();
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane functionScrollPanel = new JScrollPane();
        functionScrollPanel.setPreferredSize(new Dimension(200, 220));
        this.add((Component)functionScrollPanel, "North");
        JPanel functionListPanel = new JPanel();
        functionListPanel.setLayout(new BoxLayout(functionListPanel, 1));
        functionScrollPanel.setViewportView(functionListPanel);
        if (building.hasFunction("Life Support")) {
            LifeSupport lifeSupport = (LifeSupport)building.getFunction("Life Support");
            InhabitableBuildingPanel inhabitablePanel = new InhabitableBuildingPanel(lifeSupport, desktop);
            this.functionPanels.add(inhabitablePanel);
            functionListPanel.add(inhabitablePanel);
        }
        if (building.hasFunction("Manufacture")) {
            Manufacture workshop = (Manufacture)building.getFunction("Manufacture");
            ManufactureBuildingPanel manufacturePanel = new ManufactureBuildingPanel(workshop, desktop);
            this.functionPanels.add(manufacturePanel);
            functionListPanel.add(manufacturePanel);
        }
        if (building.hasFunction("Farming")) {
            Farming farm = (Farming)building.getFunction("Farming");
            FarmingBuildingPanel farmingPanel = new FarmingBuildingPanel(farm, desktop);
            this.functionPanels.add(farmingPanel);
            functionListPanel.add(farmingPanel);
        }
        if (building.hasFunction("Cooking")) {
            Cooking kitchen = (Cooking)building.getFunction("Cooking");
            CookingBuildingPanel cookingPanel = new CookingBuildingPanel(kitchen, desktop);
            this.functionPanels.add(cookingPanel);
            functionListPanel.add(cookingPanel);
        }
        if (building.hasFunction("Medical Care")) {
            MedicalCare med = (MedicalCare)building.getFunction("Medical Care");
            MedicalCareBuildingPanel medicalCarePanel = new MedicalCareBuildingPanel(med, desktop);
            this.functionPanels.add(medicalCarePanel);
            functionListPanel.add(medicalCarePanel);
        }
        if (building.hasFunction("Ground Vehicle Maintenance")) {
            VehicleMaintenance garage = (VehicleMaintenance)building.getFunction("Ground Vehicle Maintenance");
            VehicleMaintenanceBuildingPanel vehicleMaintenancePanel = new VehicleMaintenanceBuildingPanel(garage, desktop);
            this.functionPanels.add(vehicleMaintenancePanel);
            functionListPanel.add(vehicleMaintenancePanel);
        }
        if (building.hasFunction("Research")) {
            Research lab = (Research)building.getFunction("Research");
            ResearchBuildingPanel researchPanel = new ResearchBuildingPanel(lab, desktop);
            this.functionPanels.add(researchPanel);
            functionListPanel.add(researchPanel);
        }
        if (building.hasFunction(AstronomicalObservation.NAME)) {
            AstronomicalObservation observation = (AstronomicalObservation)building.getFunction(AstronomicalObservation.NAME);
            AstronomicalObservationBuildingPanel observationPanel = new AstronomicalObservationBuildingPanel(observation, desktop);
            this.functionPanels.add(observationPanel);
            functionListPanel.add(observationPanel);
        }
        PowerBuildingPanel powerPanel = new PowerBuildingPanel(building, desktop);
        this.functionPanels.add(powerPanel);
        functionListPanel.add(powerPanel);
        if (building.hasFunction("Power Storage")) {
            storage = (PowerStorage)building.getFunction("Power Storage");
            PowerStorageBuildingPanel powerStoragePanel = new PowerStorageBuildingPanel(storage, desktop);
            this.functionPanels.add(powerStoragePanel);
            functionListPanel.add(powerStoragePanel);
        }
        if (building.hasFunction("Resource Processing")) {
            ResourceProcessing processor = (ResourceProcessing)building.getFunction("Resource Processing");
            ResourceProcessingBuildingPanel resourceProcessingPanel = new ResourceProcessingBuildingPanel(processor, desktop);
            this.functionPanels.add(resourceProcessingPanel);
            functionListPanel.add(resourceProcessingPanel);
        }
        if (building.hasFunction("Storage")) {
            storage = (Storage)building.getFunction("Storage");
            StorageBuildingPanel storagePanel = new StorageBuildingPanel((Storage)storage, desktop);
            this.functionPanels.add(storagePanel);
            functionListPanel.add(storagePanel);
        }
        MalfunctionableBuildingPanel malfunctionPanel = new MalfunctionableBuildingPanel((Malfunctionable)building, desktop);
        this.functionPanels.add(malfunctionPanel);
        functionListPanel.add(malfunctionPanel);
        MaintenanceBuildingPanel maintenancePanel = new MaintenanceBuildingPanel((Malfunctionable)building, desktop);
        this.functionPanels.add(maintenancePanel);
        functionListPanel.add(maintenancePanel);
    }

    public String getPanelName() {
        return this.panelName;
    }

    public Building getBuilding() {
        return this.building;
    }

    public void update() {
        Iterator<BuildingFunctionPanel> i = this.functionPanels.iterator();
        while (i.hasNext()) {
            i.next().update();
        }
    }
}

