/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.structure.building.function.Cooking;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class CookingBuildingPanel
extends BuildingFunctionPanel {
    private Cooking kitchen;
    private JLabel numCooksLabel;
    private JLabel numMealsLabel;
    private JLabel mealQualityLabel;
    private int numCooksCache;
    private int numMealsCache;
    private int mealQualityCache;

    public CookingBuildingPanel(Cooking kitchen, MainDesktopPane desktop) {
        super(kitchen.getBuilding(), desktop);
        this.kitchen = kitchen;
        this.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(5, 1, 0, 0));
        this.add((Component)labelPanel, "North");
        JLabel cookingLabel = new JLabel("Cooking", 0);
        labelPanel.add(cookingLabel);
        this.numCooksCache = kitchen.getNumCooks();
        this.numCooksLabel = new JLabel("Number of Cooks: " + this.numCooksCache, 0);
        labelPanel.add(this.numCooksLabel);
        JLabel cookCapacityLabel = new JLabel("Cook Capacity: " + kitchen.getCookCapacity(), 0);
        labelPanel.add(cookCapacityLabel);
        this.numMealsCache = kitchen.getNumberOfCookedMeals();
        this.numMealsLabel = new JLabel("Number of Meals: " + this.numMealsCache, 0);
        labelPanel.add(this.numMealsLabel);
        this.mealQualityCache = kitchen.getBestMealQuality();
        this.mealQualityLabel = new JLabel("Quality of Meals: " + this.mealQualityCache, 0);
        labelPanel.add(this.mealQualityLabel);
    }

    @Override
    public void update() {
        if (this.numCooksCache != this.kitchen.getNumCooks()) {
            this.numCooksCache = this.kitchen.getNumCooks();
            this.numCooksLabel.setText("Number of Cooks: " + this.numCooksCache);
        }
        if (this.numMealsCache != this.kitchen.getNumberOfCookedMeals()) {
            this.numMealsCache = this.kitchen.getNumberOfCookedMeals();
            this.numMealsLabel.setText("Number of Meals: " + this.numMealsCache);
        }
        if (this.mealQualityCache != this.kitchen.getBestMealQuality()) {
            this.mealQualityCache = this.kitchen.getBestMealQuality();
            this.mealQualityLabel.setText("Quality of Meals: " + this.mealQualityCache);
        }
    }
}

