/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.structure.building.function.Crop;
import org.mars_sim.msp.core.structure.building.function.Farming;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class FarmingBuildingPanel
extends BuildingFunctionPanel {
    private Farming farm;
    private JLabel farmersLabel;
    private JLabel cropsLabel;
    private CropTableModel cropTableModel;
    private int farmersCache;
    private int cropsCache;

    public FarmingBuildingPanel(Farming farm, MainDesktopPane desktop) {
        super(farm.getBuilding(), desktop);
        this.farm = farm;
        this.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(3, 1, 0, 0));
        this.add((Component)labelPanel, "North");
        JLabel farmingLabel = new JLabel("Farming", 0);
        labelPanel.add(farmingLabel);
        this.farmersCache = farm.getFarmerNum();
        this.farmersLabel = new JLabel("Number of Farmers: " + this.farmersCache, 0);
        labelPanel.add(this.farmersLabel);
        this.cropsCache = farm.getCrops().size();
        this.cropsLabel = new JLabel("Number of Crops: " + this.cropsCache, 0);
        labelPanel.add(this.cropsLabel);
        JScrollPane cropScrollPanel = new JScrollPane();
        cropScrollPanel.setPreferredSize(new Dimension(200, 100));
        this.add((Component)cropScrollPanel, "Center");
        this.cropTableModel = new CropTableModel(farm);
        JTable cropTable = new JTable(this.cropTableModel);
        cropTable.setCellSelectionEnabled(false);
        cropTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        cropTable.getColumnModel().getColumn(1).setPreferredWidth(90);
        cropTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        cropTable.getColumnModel().getColumn(3).setPreferredWidth(40);
        cropScrollPanel.setViewportView(cropTable);
    }

    @Override
    public void update() {
        if (this.farmersCache != this.farm.getFarmerNum()) {
            this.farmersCache = this.farm.getFarmerNum();
            this.farmersLabel.setText("Number of Farmers: " + this.farmersCache);
        }
        if (this.cropsCache != this.farm.getCrops().size()) {
            this.cropsCache = this.farm.getCrops().size();
            this.cropsLabel.setText("Number of Crops: " + this.cropsCache);
        }
        this.cropTableModel.update();
    }

    private static class CropTableModel
    extends AbstractTableModel {
        Farming farm;
        List<Crop> crops;
        ImageIcon redDot;
        ImageIcon yellowDot;
        ImageIcon greenDot;

        private CropTableModel(Farming farm) {
            this.farm = farm;
            this.crops = farm.getCrops();
            this.redDot = ImageLoader.getIcon("RedDot");
            this.yellowDot = ImageLoader.getIcon("YellowDot");
            this.greenDot = ImageLoader.getIcon("GreenDot");
        }

        @Override
        public int getRowCount() {
            return this.crops.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = ImageIcon.class;
            } else if (columnIndex == 1) {
                dataType = String.class;
            } else if (columnIndex == 2) {
                dataType = String.class;
            } else if (columnIndex == 3) {
                dataType = String.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "C";
            }
            if (columnIndex == 1) {
                return "Crop";
            }
            if (columnIndex == 2) {
                return "Phase";
            }
            if (columnIndex == 3) {
                return "Growth";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Crop crop = this.crops.get(row);
            String phase = crop.getPhase();
            if (column == 0) {
                double condition = crop.getCondition();
                if (condition > 0.6666666666666666) {
                    return this.greenDot;
                }
                if (condition > 0.3333333333333333) {
                    return this.yellowDot;
                }
                return this.redDot;
            }
            if (column == 1) {
                return crop.getCropType().getName();
            }
            if (column == 2) {
                return phase;
            }
            if (column == 3) {
                int growth = 0;
                if (phase.equals("Growing")) {
                    double growingCompleted = crop.getGrowingTimeCompleted() / crop.getCropType().getGrowingTime();
                    growth = (int)(growingCompleted * 100.0);
                } else if (phase.equals("Harvesting") || phase.equals("Finished")) {
                    growth = 100;
                }
                return String.valueOf(growth) + "%";
            }
            return "unknown";
        }

        public void update() {
            if (!this.crops.equals(this.farm.getCrops())) {
                this.crops = this.farm.getCrops();
            }
            this.fireTableDataChanged();
        }
    }
}

