/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.collections.CollectionUtils;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.MalfunctionPanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class MalfunctionableBuildingPanel
extends BuildingFunctionPanel {
    private Malfunctionable malfunctionable;
    private Collection<MalfunctionPanel> malfunctionPanels;
    private Collection<Malfunction> malfunctionCache;
    private JPanel malfunctionListPanel;

    public MalfunctionableBuildingPanel(Malfunctionable malfunctionable, MainDesktopPane desktop) {
        super((Building)malfunctionable, desktop);
        this.malfunctionable = malfunctionable;
        this.setLayout(new BorderLayout());
        JLabel malfunctionsLabel = new JLabel("Malfunctions", 0);
        this.add((Component)malfunctionsLabel, "North");
        JScrollPane malfunctionScrollPanel = new JScrollPane();
        malfunctionScrollPanel.setPreferredSize(new Dimension(170, 90));
        this.add((Component)malfunctionScrollPanel, "Center");
        JPanel malfunctionListMainPanel = new JPanel(new BorderLayout(0, 0));
        malfunctionScrollPanel.setViewportView(malfunctionListMainPanel);
        this.malfunctionListPanel = new JPanel();
        this.malfunctionListPanel.setLayout(new BoxLayout(this.malfunctionListPanel, 1));
        malfunctionListMainPanel.add((Component)this.malfunctionListPanel, "North");
        this.malfunctionCache = new ArrayList<Malfunction>(malfunctionable.getMalfunctionManager().getMalfunctions());
        this.malfunctionPanels = new ArrayList<MalfunctionPanel>();
        Iterator<Malfunction> i = this.malfunctionCache.iterator();
        while (i.hasNext()) {
            MalfunctionPanel panel = new MalfunctionPanel(i.next());
            this.malfunctionListPanel.add(panel);
            this.malfunctionPanels.add(panel);
        }
    }

    @Override
    public void update() {
        List malfunctions = this.malfunctionable.getMalfunctionManager().getMalfunctions();
        if (!CollectionUtils.isEqualCollection(this.malfunctionCache, (Collection)malfunctions)) {
            for (Malfunction malfunction : malfunctions) {
                if (this.malfunctionCache.contains(malfunction)) continue;
                MalfunctionPanel panel = new MalfunctionPanel(malfunction);
                this.malfunctionPanels.add(panel);
                this.malfunctionListPanel.add(panel);
            }
            for (Malfunction malfunction : this.malfunctionCache) {
                MalfunctionPanel panel;
                if (malfunctions.contains(malfunction) || (panel = this.getMalfunctionPanel(malfunction)) == null) continue;
                this.malfunctionPanels.remove(panel);
                this.malfunctionListPanel.remove(panel);
            }
            this.malfunctionCache = new ArrayList<Malfunction>(malfunctions);
        }
        Iterator<MalfunctionPanel> i = this.malfunctionPanels.iterator();
        while (i.hasNext()) {
            i.next().update();
        }
    }

    private MalfunctionPanel getMalfunctionPanel(Malfunction malfunction) {
        MalfunctionPanel result = null;
        for (MalfunctionPanel panel : this.malfunctionPanels) {
            if (panel.getMalfunction() != malfunction) continue;
            result = panel;
        }
        return result;
    }
}

