/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.manufacture.ManufactureProcess;
import org.mars_sim.msp.core.manufacture.ManufactureProcessInfo;
import org.mars_sim.msp.core.manufacture.ManufactureUtil;
import org.mars_sim.msp.core.manufacture.SalvageProcess;
import org.mars_sim.msp.core.manufacture.SalvageProcessInfo;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.function.Manufacture;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.ManufacturePanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.SalvagePanel;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class ManufactureBuildingPanel
extends BuildingFunctionPanel {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.unit_window.structure.building.ManufactureBuildingPanel";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private Manufacture workshop;
    private JPanel processListPane;
    private JScrollPane processScrollPane;
    private List<ManufactureProcess> processCache;
    private List<SalvageProcess> salvageCache;
    private JComboBox processSelection;
    private Vector<ManufactureProcessInfo> processSelectionCache;
    private Vector<SalvageProcessInfo> salvageSelectionCache;
    private JButton newProcessButton;

    public ManufactureBuildingPanel(Manufacture workshop, MainDesktopPane desktop) {
        super(workshop.getBuilding(), desktop);
        this.workshop = workshop;
        this.setLayout(new BorderLayout());
        JPanel labelPane = new JPanel(new GridLayout(3, 1, 0, 0));
        this.add((Component)labelPane, "North");
        JLabel manufactureLabel = new JLabel("Manufacturing", 0);
        labelPane.add(manufactureLabel);
        JLabel techLabel = new JLabel("Tech Level: " + workshop.getTechLevel(), 0);
        labelPane.add(techLabel);
        JLabel processCapacityLabel = new JLabel("Process Capacity: " + workshop.getConcurrentProcesses(), 0);
        labelPane.add(processCapacityLabel);
        this.processScrollPane = new JScrollPane();
        this.processScrollPane.setPreferredSize(new Dimension(170, 90));
        this.add((Component)this.processScrollPane, "Center");
        JPanel processListMainPane = new JPanel(new BorderLayout(0, 0));
        this.processScrollPane.setViewportView(processListMainPane);
        this.processListPane = new JPanel();
        this.processListPane.setLayout(new BoxLayout(this.processListPane, 1));
        processListMainPane.add((Component)this.processListPane, "North");
        this.processCache = new ArrayList<ManufactureProcess>(workshop.getProcesses());
        Iterator<ManufactureProcess> i = this.processCache.iterator();
        while (i.hasNext()) {
            this.processListPane.add(new ManufacturePanel(i.next(), false, 23));
        }
        this.salvageCache = new ArrayList<SalvageProcess>(workshop.getSalvageProcesses());
        Iterator<SalvageProcess> j = this.salvageCache.iterator();
        while (j.hasNext()) {
            this.processListPane.add(new SalvagePanel(j.next(), false, 23));
        }
        JPanel interactionPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        this.add((Component)interactionPanel, "South");
        this.processSelectionCache = this.getAvailableProcesses();
        this.processSelection = new JComboBox<ManufactureProcessInfo>(this.processSelectionCache);
        this.processSelection.setRenderer(new ManufactureSelectionListCellRenderer());
        this.processSelection.setToolTipText("Select an available manufacturing process");
        interactionPanel.add(this.processSelection);
        this.salvageSelectionCache = this.getAvailableSalvageProcesses();
        Iterator<SalvageProcessInfo> k = this.salvageSelectionCache.iterator();
        while (k.hasNext()) {
            this.processSelection.addItem(k.next());
        }
        this.newProcessButton = new JButton("Create New Process");
        this.newProcessButton.setEnabled(this.processSelection.getItemCount() > 0);
        this.newProcessButton.setToolTipText("Create a new manufacturing or salvage process");
        this.newProcessButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Object selectedItem = ManufactureBuildingPanel.this.processSelection.getSelectedItem();
                    if (selectedItem != null) {
                        SalvageProcessInfo selectedSalvage;
                        if (selectedItem instanceof ManufactureProcessInfo) {
                            ManufactureProcessInfo selectedProcess = (ManufactureProcessInfo)selectedItem;
                            if (ManufactureUtil.canProcessBeStarted((ManufactureProcessInfo)selectedProcess, (Manufacture)ManufactureBuildingPanel.this.getWorkshop())) {
                                ManufactureBuildingPanel.this.getWorkshop().addProcess(new ManufactureProcess(selectedProcess, ManufactureBuildingPanel.this.getWorkshop()));
                                ManufactureBuildingPanel.this.update();
                            }
                        } else if (selectedItem instanceof SalvageProcessInfo && ManufactureUtil.canSalvageProcessBeStarted((SalvageProcessInfo)(selectedSalvage = (SalvageProcessInfo)selectedItem), (Manufacture)ManufactureBuildingPanel.this.getWorkshop())) {
                            Unit salvagedUnit = ManufactureUtil.findUnitForSalvage((SalvageProcessInfo)selectedSalvage, (Settlement)ManufactureBuildingPanel.this.getWorkshop().getBuilding().getBuildingManager().getSettlement());
                            ManufactureBuildingPanel.this.getWorkshop().addSalvageProcess(new SalvageProcess(selectedSalvage, ManufactureBuildingPanel.this.getWorkshop(), salvagedUnit));
                            ManufactureBuildingPanel.this.update();
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "new process button", e);
                }
            }
        });
        interactionPanel.add(this.newProcessButton);
    }

    @Override
    public void update() {
        List processes = this.workshop.getProcesses();
        List salvages = this.workshop.getSalvageProcesses();
        if (!this.processCache.equals(processes) || !this.salvageCache.equals(salvages)) {
            for (ManufactureProcess process : processes) {
                if (this.processCache.contains(process)) continue;
                this.processListPane.add(new ManufacturePanel(process, false, 23));
            }
            for (SalvageProcess salvage : salvages) {
                if (this.salvageCache.contains(salvage)) continue;
                this.processListPane.add(new SalvagePanel(salvage, false, 23));
            }
            for (ManufactureProcess process : this.processCache) {
                ManufacturePanel panel;
                if (processes.contains(process) || (panel = this.getManufacturePanel(process)) == null) continue;
                this.processListPane.remove(panel);
            }
            for (SalvageProcess salvage : this.salvageCache) {
                SalvagePanel panel;
                if (salvages.contains(salvage) || (panel = this.getSalvagePanel(salvage)) == null) continue;
                this.processListPane.remove(panel);
            }
            this.processCache.clear();
            this.processCache.addAll(processes);
            this.salvageCache.clear();
            this.salvageCache.addAll(salvages);
            this.processScrollPane.validate();
        }
        Iterator i = processes.iterator();
        while (i.hasNext()) {
            ManufacturePanel panel = this.getManufacturePanel((ManufactureProcess)i.next());
            if (panel == null) continue;
            panel.update();
        }
        Iterator j = salvages.iterator();
        while (j.hasNext()) {
            SalvagePanel panel = this.getSalvagePanel((SalvageProcess)j.next());
            if (panel == null) continue;
            panel.update();
        }
        Vector<ManufactureProcessInfo> newProcesses = this.getAvailableProcesses();
        Vector<SalvageProcessInfo> newSalvages = this.getAvailableSalvageProcesses();
        if (!newProcesses.equals(this.processSelectionCache) || !newSalvages.equals(this.salvageSelectionCache)) {
            this.processSelectionCache = newProcesses;
            this.salvageSelectionCache = newSalvages;
            Object currentSelection = this.processSelection.getSelectedItem();
            this.processSelection.removeAllItems();
            Iterator<ManufactureProcessInfo> k = this.processSelectionCache.iterator();
            while (k.hasNext()) {
                this.processSelection.addItem(k.next());
            }
            Iterator<SalvageProcessInfo> l = this.salvageSelectionCache.iterator();
            while (l.hasNext()) {
                this.processSelection.addItem(l.next());
            }
            if (currentSelection != null && this.processSelectionCache.contains(currentSelection)) {
                this.processSelection.setSelectedItem(currentSelection);
            }
        }
        this.newProcessButton.setEnabled(this.processSelection.getItemCount() > 0);
    }

    private ManufacturePanel getManufacturePanel(ManufactureProcess process) {
        ManufacturePanel result = null;
        for (int x = 0; x < this.processListPane.getComponentCount(); ++x) {
            ManufacturePanel panel;
            Component component = this.processListPane.getComponent(x);
            if (!(component instanceof ManufacturePanel) || !(panel = (ManufacturePanel)component).getManufactureProcess().equals(process)) continue;
            result = panel;
        }
        return result;
    }

    private SalvagePanel getSalvagePanel(SalvageProcess process) {
        SalvagePanel result = null;
        for (int x = 0; x < this.processListPane.getComponentCount(); ++x) {
            SalvagePanel panel;
            Component component = this.processListPane.getComponent(x);
            if (!(component instanceof SalvagePanel) || !(panel = (SalvagePanel)component).getSalvageProcess().equals(process)) continue;
            result = panel;
        }
        return result;
    }

    private Vector<ManufactureProcessInfo> getAvailableProcesses() {
        Vector<ManufactureProcessInfo> result = new Vector<ManufactureProcessInfo>();
        if (this.workshop.getProcesses().size() < this.workshop.getConcurrentProcesses()) {
            try {
                for (ManufactureProcessInfo process : Collections.unmodifiableList(ManufactureUtil.getManufactureProcessesForTechLevel((int)this.workshop.getTechLevel()))) {
                    if (!ManufactureUtil.canProcessBeStarted((ManufactureProcessInfo)process, (Manufacture)this.workshop)) continue;
                    result.add(process);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Vector<SalvageProcessInfo> getAvailableSalvageProcesses() {
        Vector<SalvageProcessInfo> result = new Vector<SalvageProcessInfo>();
        if (this.workshop.getProcesses().size() < this.workshop.getConcurrentProcesses()) {
            try {
                for (SalvageProcessInfo process : Collections.unmodifiableList(ManufactureUtil.getSalvageProcessesForTechLevel((int)this.workshop.getTechLevel()))) {
                    if (!ManufactureUtil.canSalvageProcessBeStarted((SalvageProcessInfo)process, (Manufacture)this.workshop)) continue;
                    result.add(process);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Manufacture getWorkshop() {
        return this.workshop;
    }

    private static class ManufactureSelectionListCellRenderer
    extends DefaultListCellRenderer {
        private ManufactureSelectionListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SalvageProcessInfo info;
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ManufactureProcessInfo) {
                ManufactureProcessInfo info2 = (ManufactureProcessInfo)value;
                if (info2 != null) {
                    String processName = info2.getName();
                    if (processName.length() > 28) {
                        processName = processName.substring(0, 28) + "...";
                    }
                    ((JLabel)result).setText(processName);
                    ((JComponent)result).setToolTipText(ManufacturePanel.getToolTipString(info2, null));
                }
            } else if (value instanceof SalvageProcessInfo && (info = (SalvageProcessInfo)value) != null) {
                String processName = info.toString();
                if (processName.length() > 28) {
                    processName = processName.substring(0, 28) + "...";
                }
                ((JLabel)result).setText(processName);
                ((JComponent)result).setToolTipText(SalvagePanel.getToolTipString(null, info, null));
            }
            return result;
        }
    }
}

